# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2007 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from QUENLIG.questions import *
from .check import *

add(name="intro",
    required = ["intro:intro"],
    before="""La commande <tt>make</tt> permet de compiler,
    de lancer, de vrifier et plein d'autres choses sur vos projets,
    que ceux-ci soient du dveloppement ou autre chose.""",
    question = """Lorsque vous lancez la commande <tt>make</tt>,
    combien cela affiche de lignes  l'cran&nbsp;?""",
    tests = ( Good(Comment(Int(1),
                           """La ligne qui est affiche vous indique
                           que la commande <tt>make</tt> n'a pas trouv
                           la description de votre projet."""
                           )
                   ),
              Comment("""Votre rponse est impossible :
              <ul>
              <li> Si le rpertoire courant est vide, montrez
              cela  un enseignant.
              <li> Si le rpertoire courant n'est pas vide
              alors allez dans le bon rpertoire
              (celui que vous venez de crer).
              </ul>""" + navigation),
              ),
    )


add(name="makefile",
    required = ["intro"],
    before="""Copiez le texte suivant dans le fichier nomm <tt>Makefile</tt>
    en utilisant un diteur de texte (<tt>xemacs</tt> de prfrence).
    <pre># Ce qui est  gauche des deux points est nomm un 'but' ou 'cible'.
# Ce qui est  droite est ce dont il dpend.
# Les lignes au dessous (en shell) indiquent comment raliser le but/cible,

CFLAGS = -Wall -Werror -g      # Options de compilation par dfaut
LDLIBS = -lm                   # Bibliothques de fonctions par dfaut

mon-projet <b>:</b> avant-compilation execute-mon-programme apres-compilation

avant-compilation <b>:</b>
	@echo "Dbut compilation  $$(date)"

execute-mon-programme <b>:</b> mon-programme

mon-programme <b>:</b>

apres-compilation <b>:</b>
	@echo "Fin compilation  $$(date)"

</pre>""",
    question = """Lorsque vous lancez la commande <tt>make</tt>,
    combien cela affiche de lignes  l'cran&nbsp;?""",
    tests = (
    Good(Comment(Int(2),
                 """Les deux lignes que vous avez sur l'cran indiquent
                 la date de dbut et de fin de compilation.
                 Cela a t rapide car il n'y a rien  compiler.
                 <pre>Dbut compilation : Sat Nov 24 18:05:18 CET 2007
Fin compilation   : Sat Nov 24 18:05:18 CET 2007</pre>"""
                 )
         ),
    Comment("""Vous n'avez pas russi  faire correctement le copi coll
    pour mettre le texte indiqu sur l'cran.
    <ul>
    <li> Si le message affich est du genre : <tt>Makefile:8: *** missing separator (did you mean TAB instead of 8 spaces?).  Stop.</tt>
    cela veut dire que les deux lignes qui commencent par <tt>@echo</tt>
    ne sont pas indentes avec une caractre tabulation mais
    avec des espaces.
    <li> Sinon, appelez un enseignant.
    </ul>"""),
    ),
    )

add(name="recompile",
    required = ["main:intro"],
    before = "On vous pose la mme question de manire intentionnelle.",
    question = """Lorsque vous lancez la commande <tt>make</tt>,
    combien cela affiche de lignes  l'cran&nbsp;?""",
    tests = (
    Good(Comment(Int(2),
                 """La commande <tt>make</tt> s'est rendue compte en regardant
                 les dates de modification des fichiers que le programme
                 avait dj t compil et que c'tait un perte de temps
                 de le recompiler""")),
    Comment("""Ne rpondez pas au hasard, tapez <tt>make</tt> dans
    le terminal et comptez les lignes"""),
    ),
    )

add(name="excuter",
    required = ["recompile"],
    before = """La commande <tt>make</tt> peut en plus lancer l'excutable
    aprs la cration si vous lui demandez.
    <p>
    Ajoutez dans votre fichier <tt>Makefile</tt> la ligne en jaune.
    <pre>...
execute-mon-programme <b>:</b> mon-programme
<span style="background:yellow">	mon-programme arg1 arg2 arg3</span>
...""",
    question = """Lorsque vous lancez la commande <tt>make</tt>,
    combien cela affiche de lignes  l'cran&nbsp;?""",
    tests = (
    Good(Comment(Int(3),
                 """La ligne du milieu indique que la commande
                 <tt>make</tt> a excut votre programme.
                 Mais celui-ci n'affiche rien :-(""")),
    Comment("""Ne rpondez pas au hasard, tapez <tt>make</tt> dans
    le terminal et comptez les lignes"""),
    ),
    )

add(name="erreur compile",
    required = ["excuter"],
    before = """Quand la commande <tt>make</tt> rencontre une erreur
    lors de la fabrication d'une cible, elle s'arrte.""",
    question = """Remplacez le <tt>return</tt> par <tt>Return</tt>
    dans le fichier <tt>mon=programme.c</tt> puis lancez <tt>make</tt>
    <p>
    Combien de lignes sont affiches&nbsp;?""",
    tests = ( Good(Comment(IntGT(6),
                           """Aprs le lancement de la compilation C
                           vous voyez de nombreux messages venant
                           du compilateur.
                           <ul>
                           <li> La premire est la plus importante car
                           souvent elle dclenche les suivantes.
                           <li> Sur chaque ligne le nom du fichier
                           source et le numro de ligne sont indiqus.
                           </ul>
                           
                           <p>
                           La dernire ligne est affiche par la commande
                           <tt>make</tt> et indique la cible qui
                           n'a pas pu tre cre.
                           <p>
                           <b>Si vous avez lanc la commande <tt>make</tt>
                            partir d'<tt>emacs</tt> ou <tt>xemacs</tt>
                           il vous suffit de taper <u><tt>^X `</tt></u>
                           (control-X puis anti-cote)
                           pour que votre curseur se positionne
                           automatiquement sur la prochaine erreur
                           de compilation</b>
                           <p>
                           <em>N'oubliez pas de remettre <tt>return</tt>
                           au lieu de <tt>Return</tt></em>
                           """)),
              Comment("""Avez-vous :
              <ul>
              <li> Mis une majuscule  <tt>return</tt>&nbsp;?
              <li> Sauvegard le fichier&nbsp;?
              <li> dit le bon fichier&nbsp;?
              </ul>"""),
              ),
    ),
add(name="erreur",
    required = ["excuter"],
    before = """Quand la commande <tt>make</tt> rencontre une erreur
    lors d'une excution, elle s'arrte.""",
    question = """Remplacez le <tt>return 0</tt> par <tt>return 1</tt>
    dans le fichier <tt>mon=programme.c</tt> puis lancez <tt>make</tt>
    <p>
    Quelle est la cible que la commande <tt>make</tt> n'arrive
    pas  crer&nbsp;?""",
    tests = ( Good(Comment(Equal('execute-mon-programme'),
                           """Maintenant remettez le <tt>return 0</tt>
                           car il indique que le programme c'est bien
                           excut""")),
              Comment("""La cible qui a choue est indiqu sur la dernire
              ligne entre les crochets."""),
              ),
    ),
    


   


    
    
