# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2007-2008 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *
from configuration_salles import *

add(name="intro",
    before="""Le sujet du premier TP est  faire sur <b>deux sances</b>
    (6 heures).
    Vous devez imprativement rester sur le mme poste pour la prochaine
    sance.
    En effet, <b>vos rponses dpendent du poste sur lequel vous tes</b>.
    <p>
    Le but du TP est de faire un rseau
    qui a une topologie de boucle avec quelque routeurs.
    <p>
    Vous aprendrez  configurer les liaisons sries et ethernet
    des routeurs ainsi que de votre PC.
<!--
    <p>
    L'ensemble des rponses que vous allez donner seront analyses
    afin de dfinir votre note de TP, le calcul ressemblera  :
    <b>Soit les variables 'bonnes', 'mauvaises', 'indices' entre 0 et 1.
    La note de TP est gale  :  bonnes<sup>2</sup>*(20-6*mauvaises<sup>0.3</sup>-2*indices<sup>0.3</sup>).</b>
    En rpondant  toutes les questions vous avez donc 12/20 au minimum.
    En rpondant  la moiti des questions sans faire aucune erreur
    et sans demander d'indice, vous avez au mieux 5/20.
-->
<!--
<p><b>
A la fin de la deuxime sance, vous rendez les feuilles MANUSCRITES
sur lesquelles vous avez pris vos notes au cours des 2 sances de TP.
On ne vous demande pas un compte rendu de TP.
Vous serez not en fonction de la pertinence de vos notes.
</b>
-->

    <p>
    En dehors des sances vous ne pourrez plus continuer ce TP,
    vous avez donc tout intrt  vous dpcher.
    <p>
    Il y a des informations utiles dans le menu de gauche&nbsp;:
    <em>Aide/Explications</em>
    <p>
    ATTENTION, durant ce TP on configure peu  peu le rseau,
    chaque fois que vous avancez dans les questions c'est que le
    rseau est mieux configur.
    Si par contre il y a une rgression de configuration non prvue,
    comme un <em>reboot</em> ou un cable dbranch,
    alors le questionnaire ne pourra la deviner et risque de vous
    compter des rponses fausses.
    
    """,
    question="tes-vous prt pour l'aventure&nbsp;? Rpondez OUI s'il vous plait.",
    tests = ( yes("Rpondez OUI s'il vous plait"), ),
    good_answer = """Vous pouvez directement taper <tt>return</tt> pour
    voir la prochaine question.
    <p>
    Vous devez imprativement rpondre immdiatement aux questions
    dont le nom est sur fond noir.
    <p>
    La question en caractres gras est celle qui dbloque
    le plus de questions.""",
    )


add(name="stop",
    required=["hard:on off"],
    before = "Si le CISCO est allum, teignez-le.",
    question = "Le CISCO est-il teint&nbsp;?",
    tests = (yes("Alors teignez-le&nbsp;!"),),
    )

add(name="votre poste",
    required=['stop'],
    before="""Vous devez avoir sous les yeux le plan du rseau que
    vous allez configurer.
    <p>
    Sur les ordinateurs il y a une tiquette avec le nom de l'ordinateur,
    ce nom est compos d'une lettre (A-P) et d'un chiffre (1-3).
    <p>
    Sur le routeur associ  votre poste, vous trouverez
    le mme nom prfix par '<tt>R</tt>'
    et s'il y a un commutateur (<em>switch</em>)
    il est prfix par '<tt>S</tt>'.
    """,
    question="""Quel est le nom indiqu sur l'tiquette colle
    sur votre ordinateur (pas routeur)&nbsp;?""",
    tests=(
    answer_length_is(2, "La rponse est sur 2 caractres"),
    good("{name}", parse_strings=host, uppercase=True),
    ),
    )

add(name="nom routeur",
    required=['votre poste', 'terminal:quitter'],
    question="""Quel nom devrez-vous donner  votre routeur&nbsp;?
    <p>
    Sur le plan il y a une liaison console entre votre PC
    et votre routeur.
    <p>
    <b>Respectez la casse.</b>
    """,
    tests = (
        good("{C0.remote_port.host.name}", parse_strings=host),
        Bad(Comment(HostReplace(UpperCase(Equal('{C0.remote_port.host.name}'))),
                    """Dans la question, en <b>gras</b> on vous dit de
                    respecter la casse (diffrence majuscule/minuscule)""")),
        ),
    good_answer = """Vrifiez bien que le routeur pos  cot
    de votre ordinateur porte bien ce nom.
    Si ce n'est pas le cas, trouvez le bon routeur et mettez le
     sa place.""",
    )

    
add(name="change nom",
    required=['serie:prompt', 'nom routeur'],
    before=en_mode_config + "<p>Regardez le nom du routeur sur le plan.",
    question="""Que tapez-vous pour mettre le bon nom au routeur&nbsp;?""",
    tests = (
    require('{C0.remote_port.host.name}',
            "Je ne vois pas le nom de votre routeur", parse_strings=host),
    require('host', 'La commande commence par <tt>host</tt>'),
    good('hostname {C0.remote_port.host.name}', parse_strings=host),
    ),
    indices = ( """C'est la mme commande que sous Unix.""",
                """En anglais c'est nom de l'hte"""),
    )

add(name="nouveau prompt",
    required=['change nom'],
    before=en_mode_config,
    question="Quel est le <em>prompt</em>&nbsp;?",
    tests = (
    good('{C0.remote_port.host.name}(config)#', parse_strings=host),
    good('Router(config)#', "Vous n'avez pas chang le nom du routeur"),
    ),
    highlight = True,
    )

add(name="arrt marche",
    required=['nouveau prompt'],
    before="""
    <ul>
    <li> teignez physiquement le routeur.
    <li> Attendez 5 secondes.
    <li> Allumez-le.
    <li> Rpondez <tt>no</tt> s'il demande si vous voulez entrer
    dans le dialogue de configuration initial.
    </ul>
    <p>
    Attendez qu'il redmarre puis faites apparatre le <em>prompt</em>
    en tapant plusieurs fois sur la touche <tt>Return</tt>.
    """,
    question="Quel est le <em>prompt</em>&nbsp;?",
    tests = (
    bad('Router', 'Je pense que vous avez oubli un caractre...'),
    good('Router>'),
    good('Router#', 'On ne vous a pas demande de faire <tt>enable</tt>...'),
    ),
    bad_answer = """Cette situation est absolument impossible.
    <p>
    Ou vous n'avez pas lu et fait ce qui est expliqu
    dans <em>avant de rpondre</em>.
    <p>
    Ou vous avez sauvegard la configuration sans que l'on
    vous l'ai demand.
    <p>
    Ou le <em>prompt</em> n'tait pas gal  <tt>Router&gt;</tt>
    la premire fois que vous avez dmarr le routeur.
    Dans ce cas, vous avez menti en rpondant au questionnaire.
    <p>
    """,
    )

add(name="sauve config",
    required=['doc:intro', 'arrt marche', 'change nom'],
    before="""Remettez le bon nom au routeur.""",
    # et refaites  <tt>no ip domain lookup</tt>""",
    question="""Que tapez-vous pour sauvegarder la configuration
    en cours d'utilisation dans la configuration qui sera
    utilise au dmarrage&nbsp;?""",
    tests = (
    good("copy running-config startup-config"),
    bad('copy', "Le routeur vous dit que la commande est incomplte"),
    bad("copy running-config", "Il faut indiquez o vous sauvez"),
    reject("copy running-config ",
        """Si vous copiez ailleurs que dans <tt>startup-config</tt>
        la configuration ne sera pas lue au dmarrage"""),
    expect('copy'),
    expect('startup-config'),
    expect('running-config'),
    ),
    indices = (
    """La commande fait une <b>copie</b> de la configuration courante qui
    est en train de fonctionner dans la configuration qui sera
    utilise lors du dmarrage du routeur""",
    """La commande est <tt>copy</tt>""",
    ),
    good_answer = """Attention :
    <ul>
    <li> vous ne devez en aucun cas teindre le routeur pendant la sauvegarde.
    <li> vous ne devez pas faire de sauvegarde aprs avoir mis un mot de passe.
    </ul>
    <p>
    Si le registre de configuration vaut <tt>0x2142</tt>
    alors au prochain dmarrage votre configuration ne sera
    pas prise en compte.
    <p>
    Pour changer le registre de configuration et qu'il permette
    la lecture de votre configuration, il faut taper&nbsp;:
<pre>
configure terminal 
config-register 0x2102
</pre>
    """,
    )

add(name="routeur nomme machine",
    required=["tp1_eth:config pc eth", "votre poste", "tp1_route:les routes"],
    question="""Quelle commande tapez-vous dans le routeur pour associer
    le bon nom  l'adresse IP de votre ordinateur&nbsp;?
    <p>
    <b>Respectez la casse pour le nom de la machine.</b>
    """,
    tests=(
    require_startswith("ip ", "On utilise la commande <tt>ip</tt>"),
    require_startswith("ip host",
                       """On utilise le paramtre <tt>host</tt> de
                       la commande <tt>ip</tt>"""),
    require("{name}", "Je ne vois pas le petit nom de votre machine.",
            parse_strings=host),
    require("{E0.port.ip}", "Je ne vois pas l'adresse IP de votre machine.",
            parse_strings=host),
    good("ip host {name} {E0.port.ip}", parse_strings=host),
    bad("ip host {E0.port.ip} {name}",
        "L'ordre des paramtres est important...", parse_strings=host),
    ),
    )

add(name="machine nomme routeur",
    required=["tp1_route:les routes"],
    question="""Quel fichier modifiez-vous sous unix pour
    donner un petit nom au routeur&nbsp;?
    <p>
    Donnez le nom absolu.
    """,
    tests=(
    require_startswith("/", "Un nom absolu commence par '/'"),
    require_startswith("/etc", "Le fichier est dans <tt>/etc</tt>"),
    good("/etc/hosts"),
    bad("/etc/hostname",
        "Ce fichier donne un nom  votre machine, pas votre routeur"),
    ),
    )

add(name="AVANT DE PARTIR",
    required=["sauve config"],
    question=avant_de_partir,
    )


add(name="final",
    required=["hard:flash", "terminal:password console",
              "terminal:combien", "tp1_route:arp nombre",
              "machine nomme routeur", "routeur nomme machine",
              "tp1_route:statiques", "tp1_route:combien",
              "tp1_route:connectes", "tp1_route:arp nombre",
              ],
    question="""Redmarrez votre ordinateur sous windows,
    et configurez les interfaces rseaux windows pour
    que votre ordinateur puisse pinguer les autres routeurs.
    <p>
    Rpondez OUI  cette question en tant sous Windows
    et quand tout fonctionnera.""",
    tests = ( yes("Rpondez OUI"), ),
    )





    
