# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2007 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *
from configuration_salles import *

add(name="connecteur srie",
    required=["admin:administrateur"],
    question="""Quel est le type (pas le genre) du connecteur RS232C
    qui est sur le PC et sur lequel vous branchez le cable console
    du routeur CISCO&nbsp;?""",
    tests = (
    answer_length_is(3, "La rponse est en 3 caractres"),
    good('DB9', uppercase=True, replace=((' ',''),)),
    ),
    )

add(name="route par dfaut",
    required=["lien:routeur>pc ?"],
    question="""Donnez la commande permettant de configurer la route
    par dfaut de votre ordinateur pour quelle passe par votre routeur.""",
    tests = (
    require("{C0.remote_port.host.E0.port.ip}",
            "Je ne vois pas l'adresse IP du port thernet de votre routeur",
             parse_strings=host),
    good("route add default gw {C0.remote_port.host.E0.port.ip}",
         parse_strings=host),    
    ),
    good_answer = "N'oubliez pas de configurer la route !",
    )

add(name="si loin de moi",
    required=["route par dfaut"],
    before = """Cette question est complique, vous avez besoin
    d'un papier et d'un crayon pour rpondre.
    <p>
    On suppose que les paquets empruntent la route la plus courte.
    """,
    question="""Combien de routeurs et de commutateurs sont traverss
    au maximum par les paquets qui partent de votre PC&nbsp;?""",
    tests = (
    require_int(),
    MaxDistance(),
    ),
    indices = ("""L'algorithme est simple, vous notez -1 sur votre PC.
    <p>
    Tant qu'il y a des quippements sans numro :
    <ul>
    <li> <em>n := n + 1</em>
    <li> Numrotez n tous les quippements actifs non numrots
    accessibles  partir
    d'un quippement not <em>n - 1</em>
    </ul>
    <p>
    Le plus grand nombre que vous aurez not sur un PC sera
    la rponse  cette question.
    """,
               ),
    )

add(name="traceroute",
    required=["Hop s1 OK", "Hop s0 OK"],
    before="""L'utilitaire <tt>traceroute</tt> sous Linux
    (ou <tt>tracert</tt> sous Windows) permet
    d'afficher les routeurs traverss par un paquet.""",
    question="""Utilisez la commande <tt>traceroute</tt> sur
    les chemins les plus longs.
    <p>
    En supposant les machines les plus loignes en fonctionnement,
    combien de lignes numrotes la commande vous affiche-t-elle\
    quand vous tracez la route&nbsp;?
    """,
    tests = (
    require_int(),
    MaxDistanceRouteur(),
    ),
    good_answer = """On ne peut pas tracer le passage  travers
    les quipements qui ne font pas de routage (les <em>switchs</em>).""",
    indices = ("""Testez avec des petits chemins qui fonctionnent pour
    savoir ce que reprsentent les lignes affiches par <tt>traceroute</tt>""",
               ),
    )

add(name="traceroute -n",
    required=["traceroute"],
    question="""Testez l'option <tt>-n</tt> de <tt>traceroute</tt>.
    <p>
    En une phrase, donnez les diffrences de fonctionnement entre la version
    avec et sans l'option.
    """,
    tests = (
    require(("DNS", "LOGIQUE", "DOMAIN", "NOM", "IP"),
            "L'affichage est-il le mme&nbsp;?",
            all_agree = True, uppercase = True,          
            ),
    require(("RAPIDE","LENT", "VITESSE"),
            """Et dans la vie relle, le fait de ne pas faire d'interrogation
            DNS change quoi  part ce qui change sur l'cran&nbsp;?""",
            all_agree = True, uppercase = True,          
            ),
    good_if_contains(""),
    ),
    )

for i in (0,1):
    add(name="vers routeur s%d" % i,
        required=["route par dfaut", "lien:serial%d ?" % i],
        question="""Quelle commande tapez-vous sur le PC pour pinguer
        l'interface srie %d du routeur&nbsp;?
        <p>
        Donnez votre rponse mme si le ping choue.
        """ % i,
        tests = (
        good("ping {C0.remote_port.host.S%d.port.ip}"%i, parse_strings=host),
        ),
        )
    add(name="vers routeur s%d ?" % i,
        required=["vers routeur s%d" % i],
        question="""Rpondez OUI si votre ordinateur peut pinguer l'interface
        srie %d de votre routeur""" % i,
        tests = (
        yes("""Ce n'est vraiment pas normal.
        Avez-vous mis la route par dfaut sur l'ordinateur&nbsp;?"""),
        ),
        )

add(name="eth0",
    required=["tp2:test branchement", "rip:RIP", "admin:relance routeur",
              "admin:password telnet"],
    question="""Quelle commande tapez-vous pour configurer l'interface
    <tt>eth0</tt> de l'ordinateur&nbsp;:""",
    tests = (
    good("ifconfig {E0.port.name} {E0.port.ip} netmask {E0.mask}",
         parse_strings=host),
    good("ifconfig {E0.port.name} {E0.port.ip}/{E0.nr_bits_netmask}",
         parse_strings=host),
    ),
    )

add(name="vers routeur eth0",
    required=["eth0", "lien:routeur eth0"],
    question="""Quelle commande tapez-vous sur votre PC
    pour pinguer votre routeur&nbsp;?
    <p>
    Donnez votre rponse mme si le ping choue.
    """,
    tests = (
    good("ping {C0.remote_port.host.E0.port.ip}",parse_strings=host),
    ),
    )


add(name="vers routeur eth0 ?",
    required=["vers routeur eth0"],
    question="Rpondez OUI si votre ordinateur peut pinguer votre routeur.",
    tests = (
    yes("""Vrifiez les cables et les commandes que vous avez excut,
    vrifiez que eth0 est bien sur la carte mre en utilisant <tt>dmesg</tt>.
    <p>
    Prvenez un enseignant si cela ne fonctionne toujours pas"""),
    ),
    )

for i in (0,1):
    add(name="Hop s%d OK" % i,
        required=["rip:Et Hop s%d OK" % i, "vers routeur s%d ?" % i],
        question=""" partir de votre ordinateur,
        le ping du port ethernet du routeur distant (via serial%d)
        a-t-il fonctionn&nbsp;?""" % i,
        tests = (
        yes("""Cela devrait fonctionner. Un cable c'est dbranch&nbsp;?"""),
        ),
        )

add(name="table routage",
    required=["route par dfaut"],
    question="""Quelle commande tapez-vous sous UNIX pour voir
    la liste des routes""",
    tests = (
    good("route", "Vous pouvez aussi tapez <tt>ip route</tt>"),
    good("ip route", "Vous pouvez aussi utiliser la commande <tt>route</tt>"),
    ),
    )

add(name="application",
    required=["admin:password telnet"],
    question="""Proposez une application du PC permettant de tester la couche
    application du routeur.""",
    tests = (
    good("telnet"),
    ),
    indices = ("Une application permettant de ce connecter  distance",
               ),
    )

add(name="vitesse",
    required=["traceroute"],
    before = """
    Pour pinguer TOUTES les machines (PC) vous pouvez complter la liste
    des machines et lancer la boucle suivante sous UNIX&nbsp;:
    
    <pre>for I in 0.1 0.3 1.5 1.7 2.9 2.11 .....
do
  ping -c 1 -s 60000 -W 1 192.168.$I |
  tail -n 1 |
  sed -e 's/.* = //' -e 's/\// /' |
  (read A B ; echo "$A millisecondes pour transmettre 60Ko  192.168.$I")
done</pre>
<p>
Vous pouvez la lancer plusieurs fois et prendre le minimum.
    """,
    question="""Combien de ``classes de temps trouvez-vous&nbsp;?
    <p>
    On entend par classe des valeurs suffisemment diffrentes pour
    que la diffrence ne soit pas le fruit du hasard.
    """,
    tests = (
    require_int(),
    good("3"),
    bad("2",
        """Le <em>ping</em> peut traverser un cble srie (lent),
        un cble ethernet ou ne pas passer par le rseau car local
         la machine.
        Il ne peut donc pas y avoir moins de 3 classes de temps."""),
    ),
    )

add(name="rpar ?",
    required=["vitesse", "tp2:dmontage"],
    question="""Pouvez-vous pinguer toutes les machines
     partir de votre PC&nbsp;?""",
    tests = (
    yes("""2 cbles on t dbranchs en trop ou bien vous n'avez
    pas attendu que les tables de routages soient  jour."""),
    ),
    )



