# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2007 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from check import *
from configuration_salles import *

add(name="defaut pc",
    required=["tp1_eth:machine>routeur 2 ?", "tp1_eth:routeur>remote eth OK"],
    question="""Quelle commande tapez-vous pour ajouter une route par
    dfaut  votre ordinateur pour qu'il envoit tout au routeur&nbsp;?""",
    tests = (
    require_startswith("route",
                       """Vous devez utiliser la commande <tt>route</tt>
                       pour indiquer la route par dfaut"""
                       ),
    require("default", """Je ne vois pas le mot clef <tt>default</tt>
    indiquant que vous voulez dfinir la route par dfaut"""),
    require("{E0.remote_port.ip}",
            "Je ne vois pas l'adresse IP du routeur connect  votre machine",
            parse_strings=host),
    require("gw", "Je ne vois pas le mot clef <tt>gw</tt>"),
    good("route add default gw {E0.remote_port.ip}", parse_strings=host),
    ),
    good_answer="Excutez la commande",
    indices = (
    """Tapez <tt>man route</tt>""",
    ),
    )

add(name="defaut pc OK",
    required=["defaut pc", "tp1_eth:machine>routeur OK"],
    question = """Rpondez OUI  cette question seulement
    si le ping de votre ordinateur vers le port srie 0
    de votre routeur fonctionne.""",
    tests = ( yes('Tapez OUI'), ),
    )

add(name="machine>routeur s0",
    required=["defaut pc OK", "routeur>s0 routeur ?"],
    before="""Vous pouvez pinguer les interfaces de votre routeur
     partir de votre PC, mais pouvez-vous pinguer les autres
    routeurs&nbsp;?""",
    question="""Donnez la ligne commande que vous tapez sur votre ordinateur
    pour <em>pinguer</em> le routeur connect au port srie 0
    de votre routeur.""",
    tests = (
    require_ping,
    require("{E0.remote_port.host.S0.remote_port.ip}",
            "Je ne vois pas l'adresse IP du port srie 0 de votre routeur",
            parse_strings=host),
    good("ping {E0.remote_port.host.S0.remote_port.ip}",
         parse_strings=host),
    ),
    )

add(name="machine>routeur s1",
    required=["defaut pc OK", "routeur>s1 routeur ?"],
    before="""Vous pouvez pinguer les interfaces de votre routeur
     partir de votre PC, mais pouvez-vous pinguer les autres
    routeurs&nbsp;?""",
    question="""Donnez la ligne commande que vous tapez sur votre ordinateur
    pour <em>pinguer</em> le routeur connect au port srie 1
    de votre routeur.""",
    tests = (
    require_ping,
    require("{E0.remote_port.host.S1.remote_port.ip}",
            "Je ne vois pas l'adresse IP du port srie 0 de votre routeur",
            parse_strings=host),
    good("ping {E0.remote_port.host.S1.remote_port.ip}",
         parse_strings=host),
    ),
    )

add(name="machine>routeur s1 OK",
    required=["machine>routeur s1",
              "tp1_serie:routeur>remote s1 OK",
              ],
    question = """Rpondez OUI quand le ping de votre ordinateur
    vers le routeur connect au port srie 1 de votre routeur fonctionnera.
    <p>
    Ceci fonctionnera quand l'autre routeur aura configur
    sa route par dfaut.
    """,
    tests = (
    yes('Rpondez OUI'),
    ),
    )

add(name="machine>routeur s0 OK",
    required=["machine>routeur s0",
              "tp1_serie:routeur>remote s0 OK",
              "machine>routeur s1 OK",
              ],
    question = """Rpondez OUI quand le ping de votre ordinateur
    vers le routeur connect au port srie 0 de votre routeur fonctionnera.
    <p>
    Ceci fonctionnera quand <b>tous</b> les routeurs de la boucle
    auront configur leur route par dfaut.
    """,
    tests = (
    yes('Rpondez OUI'),
    ),
    )


add(name="dfaut routeur",
    required=["doc:intro",
              "tp1_serie:routeur>s0 routeur ?",
              "tp1_serie:routeur>s1 routeur ?"],
    before="""Les routeurs tant organiss sous la forme d'une boucle,
    nous allons faire circuler les informations sur la boucle
    jusqu' ce qu'un routeur les routent lui-mme
    ou que les paquets se retrouvent avec un TTL de 0.""",
    question="""Quelle commande tapez-vous sur le routeur pour configurer
    la route par dfaut en direction du routeur connect sur le port
    srie 0&nbsp;?
    <p>
    N'oubliez pas de d'excuter la commande quand vous aurez rpondu
    correctement  cette question.""",
    tests = (
    bad("ip default-gateway {C0.remote_port.host.S0.remote_port.ip}",
        """Cette commande fonctionne seulement pour le <em>boot</em>.
        En utilisation normal, elle n'est pas utilise.""",
         parse_strings=host),
    good("ip route 0.0.0.0 0.0.0.0 {C0.remote_port.host.S0.name}",
        """Attention, cette commande ne fonctionne que dans le cas
        d'une liaison bipoint mais pas sur un rseau thernet car le paquet
        n'est pas adress  une passerelle.
        <p>
        Normalement vous devriez indiquer l'adresse IP de la passerelle.
        """,
        parse_strings=host),
    require("{C0.remote_port.host.S0.remote_port.ip}",
            "Je ne vois pas l'adresse IP de la passerelle par dfaut",
            parse_strings=host),
    good("ip route 0.0.0.0 0.0.0.0 {C0.remote_port.host.S0.remote_port.ip}",
         parse_strings=host),
    ),
    good_answer = "Et bien tapez cette commande.",
    )

for i in range(2):
    add(name="routeur>s%d routeur ?" % i,
        required=["dfaut routeur", "tp1_serie:routeur>s%d routeur" % i],
        question = """Le ping  partir de votre routeur
        via le port srie %d sur l'autre port srie
        du routeur distant fonctionne-t-il correctement&nbsp;?""" % i,
        tests = ( yes("""Cela aurai du fonctionner car maintenant
        votre routeur sait ou envoyer le paquet et l'autre sait rpondre."""),
                  ),
        )


add(name="les routes",
    required=["cli:show liste",
              "routeur>s0 routeur ?", "routeur>s1 routeur ?", "defaut pc OK"],
    before="""Attention, les routes ne sont pas affiches si la liaison
    qu'elles utilisent n'est pas branche.""",
    question="""Quelle commande tapez-vous sur le routeur pour lister
    les routes&nbsp;?""",
    tests = (    
    good("show ip route"),
    ),
    )

add(name="combien",
    required=["les routes"],
    question="Combien votre routeur affiche-t-il de routes&nbsp;?",
    tests = (
    require_int(),
    good("4"),
    ),
    )

add(name="statiques",
    required=["les routes"],
    question="Combien votre routeur affiche-t-il de routes statiques&nbsp;?",
    tests = (
    require_int(),
    good("1"),
    ),
    )

add(name="connectes",
    required=["les routes"],
    question="""Combien votre routeur affiche-t-il de routes connectes,
    c'est--dire pour lesquel la destination est directement connecte
    au routeur&nbsp;?""",
    tests = (
    require_int(),
    good("3"),
    ),
    )

add(name="arp",
    required=["les routes"],
    question="""Quelle commande tapez-vous sur le routeur pour afficher
    le contenu de la table ARP&nbsp;?""",
    tests = (
    good("show arp"),
    ),
    )

add(name="arp nombre",
    required=["arp"],
    question="Combien la table ARP contient de lignes (hors titre)&nbsp;?",
    tests = (
    require_int(),
    good("2"),
    ),
    )



    



    
