# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2007 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *
from configuration_salles import *

add(name="intro",
    before="""Le but de ces 3 heures de TP est de faire un rseau
    qui a une topologie de boucle avec quelque routeurs.
    <p>
    Vous aprendrez  configurer les liaisons sries et ethernet
    des routeurs ainsi que de votre PC.
    <p>
    L'ensemble des rponses que vous allez donner seront analyses
    afin de dfinir votre note de TP.
    <p>
     la fin de la sance vous ne pourrez plus continuer ce TP,
    vous avez donc tout intrt  vous dpcher.
    <p>
    Le plan du rseau  monter est dans le menu de gauche&nbsp;:
    <em>Aide/Explications</em>
    """,
    question="tes-vous prt pour l'aventure&nbsp;?",
    tests = ( yes("Rpondez OUI s'il vous plais"), ),
    )


add(name="stop",
    required=["hard:on off"],
    before = "Si le CISCO est allum, teignez-le.",
    question = "Le CISCO est-il teint&nbsp;?",
    tests = (yes("Alors teignez-le&nbsp;!"),),
    )

add(name="votre poste",
    required=['stop'],
    before="""Vous devez avoir sous les yeux le plan du rseau que
    vous allez tous configurer.
    <p>
    Sur les ordinateurs il y a une tiquette avec le nom de l'ordinateur,
    ce nom est compos d'une lettre (A-P) et d'un chiffre (1-3).""",
    question="""Quel est le nom indiqu sur l'tiquette colle
    sur votre ordinateur (pas routeur)&nbsp;?""",
    tests=(
    answer_length_is(2, "La rponse est sur 2 caractres"),
    good("{name}", parse_strings=host, uppercase=True),
    ),
    )

add(name="nom routeur",
    required=['votre poste', 'terminal:quitter'],
    question="""Quel nom devez-vous donner  votre routeur&nbsp;?
    <p>
    Sur le plan il y a une liaison console entre votre PC
    et votre routeur.
    """,
    tests = (
    good("{C0.remote_port.host.name}", parse_strings=host),
    ),
    good_answer = """Vrifiez bien que le routeur pos  gauche
    de votre ordinateur porte bien ce nom.
    Si ce n'est pas le cas, trouvez le bon routeur et mettez le
     sa place.""",
    )

    
add(name="change nom",
    required=['serie:prompt', 'nom routeur'],
    before=en_mode_config,
    question="""Que tapez-vous pour mettre le bon nom au routeur&nbsp;?""",
    tests = (
    require('{C0.remote_port.host.name}',
            "Je ne vois pas le nom de votre routeur", parse_strings=host),
    require('host', 'La commande commence par <tt>host</tt>'),
    good('hostname {C0.remote_port.host.name}', parse_strings=host),
    ),
    )

add(name="nouveau prompt",
    required=['change nom'],
    before=en_mode_config,
    question="Quel est le <em>prompt</em>&nbsp;?",
    tests = (
    good('{C0.remote_port.host.name}(config)#', parse_strings=host),
    good('Router(config)#', "Vous n'avez pas chang le nom du routeur"),
    ),
    highlight = True,
    )

add(name="arrt marche",
    required=['nouveau prompt'],
    before="""
    <ul>
    <li> teignez physiquement le routeur.
    <li> Attendez 5 secondes.
    <li> Allumez-le.
    <li> Rpondez <tt>no</tt> s'il demande si vous voulez le configurer.
    </ul>
    <p>
    Attendez qu'il redmarre puis faites apparatre le prompt.
    """,
    question="Quel est le <em>prompt</em>&nbsp;?",
    tests = (
    bad('Router', 'Je pense que vous avez oubli un caractre...'),
    good('Router>'),
    good('Router#', 'On ne vous a pas demande de faire <tt>enable</tt>...'),
    ),
    )

add(name="sauve config",
    required=['doc:intro', 'arrt marche', 'change nom'],
    before="""Remettez le bon nom au routeur.""",
    # et refaites  <tt>no ip domain lookup</tt>""",
    question="""Que tapez-vous pour sauvegarder la configuration
    en cours d'utilisation et donc le nom&nbsp;?""",
    tests = (
    good("copy running-config startup-config"),
    bad("copy running-config", "Il faut indiquez o vous sauvez"),
    reject("copy running-config ",
        """Si vous copiez ailleurs que dans <tt>startup-config</tt>
        la configuration ne sera pas lue au dmarrage"""),
    ),
    indices = (
    """La commande fait une copie de la configuration courante qui
    est en train de fonctionner dans la configuration qui sera
    utilise lors du dmarrage du routeur""",
    """La commande est <tt>copy</tt>""",
    ),
    good_answer = """Attention :
    <ul>
    <li> vous ne devez en aucun cas teindre le routeur pendant la sauvegarde.
    <li> vous ne devez pas faire de sauvegarde aprs avoir mis un mot de passe.
    </ul>""",
    )

add(name="routeur nomme machine",
    required=["tp1_route:les routes"],
    question="""Quelle commande tapez-vous dans le routeur pour associer
    le bon nom  l'adresse IP de votre ordinateur&nbsp;?
    """,
    tests=(
    require_startswith("ip ", "On utilise la commande <tt>ip</tt>"),
    require_startswith("ip host",
                       """On utilise le paramtre <tt>host</tt> de
                       la commande <tt>ip</tt>"""),
    require("{name}", "Je ne vois pas le petit nom de votre machine.",
            parse_strings=host),
    require("{E0.port.ip}", "Je ne vois pas l'adresse IP de votre machine.",
            parse_strings=host),
    good("ip host {name} {E0.port.ip}", parse_strings=host),
    ),
    )

add(name="machine nomme routeur",
    required=["tp1_route:les routes"],
    question="""Quel fichier modifiez-vous sous unix pour
    donner un petit nom au routeur&nbsp;?
    <p>
    Donnez le nom absolu.
    """,
    tests=(
    require_startswith("/", "Un nom absolu commence par '/'"),
    require_startswith("/etc", "Le fichier est dans <tt>/etc</tt>"),
    good("/etc/hosts"),
    ),
    )

add(name="AVANT DE PARTIR",
    required=["sauve config"],
    question=avant_de_partir,
    tests=( good("J'ai fini"), ),
    )


add(name="final",
    required=["hard:flash", "terminal:password console",
              "terminal:combien", "tp1_route:arp nombre",
              "machine nomme routeur", "routeur nomme machine",
              "tp1_route:statiques", "tp1_route:combien",
              "tp1_route:connectes", "tp1_route:arp nombre",
              ],
    question="""Redmarrez votre ordinateur sous windows,
    et configurez les interfaces rseaux windows pour
    que votre ordinateur puisse pinguer les autres routeurs.
    <p>
    Rpondez OUI  cette question en tant sous Windows
    et quand tout fonctionnera.""",
    tests = ( yes("Rpondez OUI"), ),
    )





    
