# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

aide = """La mthode la plus simple pour tester les expressions
    rgulire est d'excuter la commande suivante&nbsp;:
    <pre>sed -r 's/votre_expression_regulire/(((&)))/g'</pre>
    Vous tapez ensuite du texte au clavier et les chanes de caractres
    reconnues apparatront dans les triples parenthses."""

add(name="intro",
    required=["sh:console", "sh:configurer", "remplacer:intro"],
    before=aide,
    question="""Quelle expression rgulire reprsente une chane
    de caractre quelconque.""",
    tests=(
    good('.*'),
    bad('*', "Non a c'est pour le shell."),
    bad(".", "Ce <em>pattern</em> reprsente un caractre quelconque"),
    reject("sed",
           """On demande le <em>pattern</em>,
           pas la ligne de commande permettant de le tester"""),
    reject("[",
           """Vous n'allez pas numrer tous les
           caractres possibles&nbsp;!
           N'utilisez pas les crochets."""),
    require(".",
            """On indique un caractre quelconque avec un '.'
            Une ligne quelconque est une rptition de caractres
            quelconques."""),
    require("*",
            """On indique que l'on rpte ce qui prcde
            en utilisant le symbole <tt>*</tt>"""),
    reject("\\.*",
           """<tt>\\.*</tt> reprsente une srie
           de points de longueur quelconque"""),
    reject("'",
           """On dsire l'expression rgulire,
           on ne se soucie pas du shell,
           donc on ne veut pas de <tt>'</tt> ou <tt>\"</tt>
           """),
    ),
    good_answer="Par dfaut la chane tient dans une seul ligne",
    indices = (
    """C'est la rptition un nombre indtermin de fois
    d'un caractre quelconque""",
    ),
    )

add(name="ligne de A",
    question="""Quelle expression rgulire tendue reprsente les lignes
    ne contenant que des caractres A et rien d'autre""",
    tests=(
    good('^A+$'),
    good(('^[A]+$', '^(A)+$', '^AA*$'),
         "Il est plus simple d'crire <pre>^A+$</pre>"
         ),
    bad(('^A*$', '^[A]*$', '^(A)*$'),
        "Ce n'est pas bon car cela reprsente aussi les lignes vides."),
    bad('^A$', "Ceci reprsente les lignes contenant un seul A"),
    require("^",
            """Si vous n'indiquez pas qu'elle commence au dbut de la ligne,
            l'expression rgulire peut commencer n'importe ou."""),
    require("$",
            """Si vous n'indiquez qu'elle finit  la fin
            de la ligne, l'expression rgulire peut finir n'importe ou."""),
    reject("[",
           """Pas besoin de spcifier une liste de
           lettres car il n'y en a qu'une seule&nbsp;: A"""),
    reject(" ",
           """Si vous mettez un espace cela veut dire que vous dsirez
           que la chaine de caractre contienne un espace."""
           ),
    ),
    indices=("Le caractre <tt>^</tt> indique le dbut de ligne",
    "Le caractre <tt>$</tt> indique la fin de ligne",
    ),
    )

add(name="un spcial",
    required=["intro"],
    question="""Quelle expression reprsente le caractre point&nbsp;:<tt>.</tt>
    au lieu de reprsenter un caractre quelconque&nbsp;?""",
    tests=(
    good( ("\\.", "[.]") ),
    require('.', "Je ne vois pas de caractre <tt>.</tt> dans votre rponse"),
    bad( ".", "Cette expression reprsente un caractre quelconque"),
    reject(('"',"'"),
           """Une expression rgulire n'a pas la mme syntaxe que le
           shell, les apostrophes et guillemets ne sont pas spciaux"""),
    ),
    indices=("""Attention le <tt>.</tt> est un caractre spcial,
    il faut annuler sa signification""",
             """Le caractre d'chappement dans les expressions
             rgulire est \\""",
             ),
    )

add(name="deux spcial",
    required=["un spcial"],
    question="""Quelle expression rgulire reprsente la chaine de caractres <tt>2*</tt> (un chiffre deux suivi d'une toile)&nbsp;?""",
    tests=(
    good( ("2\\*", "2[*]") ),
    bad( "2*", "Cette expression reprsente une suite de 2"),
    require('2', 'Trop fort, je ne vois pas de 2 dans votre rponse&nbsp;!'),
    require('*', 'Trop fort, je ne vois pas de * dans votre rponse&nbsp;!'),
    reject(('"',"'"),
           """Guillemets et apostrophes sont reconnus par le shell
           pas par les expressions rgulires,
           vous devez utiliser autre chose pour annuler
           la signification de l'toile"""),
    reject('\\2', "Pourquoi protger le 2, il n'est pas spcial"),
    ),
    indices=("""Attention le <tt>*</tt> est un caractre spcial,
    il faut annuler sa signification""",
             """Le caractre d'chappement dans les expressions
             rgulire est \\""",
             ),
    )

add(name="spcial",
    required=["un spcial"],
    question="""Quelle expression reprsente les lignes compltes
    contenant un caractre <tt>.</tt> quelque part&nbsp;?
    """,
    tests=(
    good( (".*\\..*", ".*[.].*") ),
    bad( ("\\.","[.]"),
         """L'expression reprsente le <tt>.</tt> pas la ligne complte"""),
    bad("*.*",
        """C'est la bonne rponse pour les <em>pattern</em>
        du shell. Mais on vous demande une expression rgulire"""),
    reject(('[',']'), """Pas besoin de crochets,
    Utilisez plutt un anti-slash pour annuler les significations
    des caractres spciaux"""),
    require(".*",
            """On ne veut pas que le '.' mais aussi
            la chaine de caractres quelconques
             sa gauche et  sa droite."""),
    reject(("^", "$"),
           """Pas la peine de spcifier les indicateurs
           de dbut/fin de ligne car le <tt>.*</tt>
           prend la plus grande chaine possible.
           Donc jusqu'au bout"""),
    number_of_is('.*', 2, """Il y a deux chaines de caractres quelconques,
    une  gauche et une  droite du point"""),
    number_of_is('\\', 1, """Il y a un seul caractre spcial pour lequel
    la signification doit tre annule, vous n'avez donc besoin
    que d'un seul anti-slash"""),
    
    ),
    indices=(
    """L'expression solution reprsente une chaine de caractres quelconques
    suivie d'un point suivie d'une chaine de caractres quelconques""",
    """La rponse la plus courte tient en 6 caractres""",
    """N'oubliez pas que le <tt>.*</tt> correspond
     la plus longue chane possible""",
             ),
    )

add(name='ngation',
    before=aide,
    required=["intro"],
    question="""Quelle expression rgulire reprsente un caractre qui ne soit
    ni une lettre de l'alphabet en minuscule ni un chiffre""",
    tests=(
    reject("!", "La ngation n'est pas la mme que celle du shell"),
    require(("[", "]"),
            """Il faut spcifier une liste de caractres en utilisant
            les crochets"""),
    require("-", "Il faut utiliser le <tt>-</tt> pour indiquer un interval"),
    require("^", "Je ne trouve pas le caractre indiquant <em>tout sauf</em>"),
    reject('A', "Pas en minuscule, j'ai pas dis pas en majuscule"),
    reject("^[a", """La ngation est le premier caractre aprs
    le crochet. Sinon elle indique un dbut de ligne."""),
    number_of_is('^',1,
                 """Vous ne devez employer la ngation qu'une seule fois"""),
    reject(' ', "Attention, les espaces sont significatifs"),
    require('0-9', """Je ne trouve pas l'interval indiquant tous les
    chiffre de 0  9 inclus"""),
    good("[^a-z0-9]"),
    good("[^0-9a-z]",
         """J'attendais <tt>[^a-z0-9]</tt>, j'accepte votre
         solution car elle fonctionne mais s'il vous plais
         ne changez pas l'ordre de ce qui es demand dans l'nonc."""),
    ),
    )

add(name='suite de chiffres',
    before=aide,
    required=["intro"],
    question="""Quelle expression reprsente des suites de chiffres
           quelconques d'au moins un chiffre (mme <tt>000</tt>
           ou <tt>01</tt>)""",
    tests=(
    bad("[0-9]*", """Cette expression correspond aussi  une chaine vide,
    mais nous recherchons les chaines contenant au moins un chiffre"""),
    bad('[:digit:]+', """C'est une expression rgulire qui rpond
     la question, mais on vous demande une solution qui n'utilise
    que des connaissances de base."""),
    require('0-9', "Je ne trouve pas l'interval des chiffres de 0  9"),
    reject('.', """Une suite de chiffre ne contient pas de caractres
    quelconques, pourquoi indiquez-vous le caractre '.'&nbsp;?"""),
    reject(('(',')'), "Pas besoin de parenthser"),
    reject(('[0-9]+[0-9]*', '[0-9]*[0-9]+'),
           """Vous pouvez faire deux fois plus court.
           En effet votre expression dcrit deux suites de chiffres
           l'un colle  l'autre"""),
    good( "[0-9]+",
    "C'est un expression rguire tendue car vous utilisez <tt>+</tt>"),
    good( "[0-9][0-9]*" ),
    good( "[0-9]*[0-9]", "On crit plutt <tt>[0-9][0-9]*</tt>" ),
    ),
    )

add(name='entier positif',
    before=aide,
    required=["suite de chiffres"],
    question="""Quelle expression reprsente des suites de chiffres
           ne commenant pas par <tt>0</tt> sauf pour le nombre <tt>0</tt>.
           Exemple de ce que l'on doit trouver&nbsp;:
           
           <pre>dfsfd<span class='boxed'>67</span>sdfsfds-<span class='boxed'>0</span>sdfdsf++<span class='boxed'>0</span><span class='boxed'>8090</span>dsfs<span class='boxed'>0</span><span class='boxed'>0</span>ppp</pre>


           """,
    tests=(
    reject('sed', "On veut l'expression rgulire, pas la commande"),
    require('|', """Il faut utiliser un <b>ou</b>, en effet,
    c'est zro ou un nombre de commenant pas par zro."""),
    reject('.',
           "Un nombre entier, pas un nombre flottant, donc pas de point"),
    require('[0-9]',
           "Vous n'autorisez pas les nombres  contenir des 0&nbsp;: 608"),
    reject(' ', """Si vous mettez un espace dans une expression rgulire,
    cet espace devra tre trouv"""),
    reject('[0]', "Il est plus simple d'crire <tt>0</tt> que <tt>[0]</tt>"),
    require('[1-9]', """Vous n'indiquez pas que le premier chiffre est
    entre 1 et 9"""),
    require('*', """Vous n'indiquez pas qu'il y a un nombre indfini de
    chiffre aprs le premier (y compris aucun)"""),
    
    good( "0|[1-9][0-9]*" ),
    good( "(0|[1-9][0-9]*)" ),
    good( "[1-9][0-9]*|0" ),
    good( "([1-9][0-9]*|0)" ),
    ),
    )

def test_nombre_entier(a):
    if a.find("[1-9]") == -1:
        return False, '''Tous les nombres entiers commencent par un chiffre
        diffrent de 0 sauf 0.'''
    if " " in a:
        return False, '''Les espaces sont <b>significatif</b>'''
    if a.find("|") == -1:
        return False, '''0 est un cas  part car on ne lui met pas un signe'''
    if a.count("|") > 1:
        return False, '''Un seul | suffit, ne compliquez pas inutilement'''
    if a[0] != "(" or a[-1] != ")":
        return False, """Je n'accepterais la solution que si vous parenthsez
    le ou, crivez <tt>(a|b)</tt> au lieu de <tt>a|b</tt>"""
    if a.find("[0-9]*") == -1:
        return False, """La fin d'un nombre entier contient un nombre
        indfini de nombre entre 0 et 9."""
    if a.find("[+-]") != -1:
        return False, """Si un liste de caractres entre crochets contient
        '-' il est conseill de le mettre en premier"""
    if a.find("[-+][0-9]") != -1 or a.find("[-+]?[0-9]") != -1:
        return False, """Un nombre entier ne commence pas par 0 sauf 0"""
    if a.find("[-+][0-9]") != -1:
        return False, """Un nombre entier peut tre crit sans signe."""
    return False, """Si aprs avoir test votre expression rgulire elle
    vous semble juste alors laissez un commentaire pour le faire savoir."""
    
    

add(name='nombre entier',
    required=["entier positif"],
    before=aide,
    question="""Quelle expression rgulire tendue reprsente les nombres
    entiers avec leur signe&nbsp;:
    <pre>dfsfd<span class='boxed'>+6</span>sdfsfds-<span class='boxed'>0</span>sdfdsf++<span class='boxed'>0</span>sdfs<span class='boxed'>89</span>dsfs<span class='boxed'>-45</span>sdff+<span class='boxed'>-342</span>fd<span class='boxed'>56</span>ssfsdf<span class='boxed'>0</span><span class='boxed'>76</span>werwer-<span class='boxed'>0</span><span class='boxed'>89</span>sdf</pre>
    Les boites indiquent les nombres que votre expression rgulire doit trouver.
    """,
    tests=(    
    good( ('([-+]?[1-9][0-9]*|0)',
           '(0|[-+]?[1-9][0-9]*)',
           '((-|+|)[1-9][0-9]*|0)',
           '(0|(-|+|)[1-9][0-9]*)',
           '((+|-|)[1-9][0-9]*|0)',
           '(0|(+|-|)[1-9][0-9]*)'
           ) ),
    good( '(0|+[1-9][0-9]*|-[1-9][0-9]*)',
          "Il est plus court d'crire : <pre>(0|[-+]?[1-9][0-9]*)</pre>"),
    test_nombre_entier,
    ),
    )
    
    
add(name='identique',
    question="""Quelle expression rgulire tendue reprsente les
    lignes ne contenant que des caractres identiques.
    """,
    tests=(
    require(('(',')'),
            """Vous devez grouper des caractres et rutilis le texte
            trouv par le groupe"""),
    require(('^', '$'),
            """Vous devez indiquez le dbut et la fin de ligne sinon
            l'expression pourra correspondre  une suite de caractres
            identiques en plein milieu"""),
    require('\\1', 'Vous devez utiliser les caractres trouvs par le groupe'),
    good('^(.)\\1*$'),
    bad('^(.)\\1+$', """Presque, mais cela ne trouve pas
    les lignes d'un seul caractre"""),
    ),
    indices=("""Il faut mettre le premier caractre de la ligne dans
    un groupe et dire que le reste de la ligne est la rptition
    du contenu de ce groupe""",
             """Les groupes sont dfinis par les parenthses&nbsp;:
             <tt>a(.*)b(.*)c</tt>
             <p>
             Cette expression dfinit 2 groupes sans les utiliser.
             """,
             """Les groupes sont nomms anti-slash numro de groupe.
             <tt>\\1</tt> est le numro du premier groupe.
             """,
             """Pour cette exercice, le premier groupe est un caractre
             quelconque et la suite de la ligne est une rptition
             du premier groupe.
             """,
             ),
    )


