# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *


add(name="intro",
    required=["manuel:chercher", "sh:rpertoire courant",
              "sh:rpertoire connexion"],
    question="""Quel est le nom de la commande permettant de trouver
    des fichiers dans une hirarchie de fichier&nbsp;?""",
    tests=(
    reject('ls', "<tt>ls</tt> permet de les voir, pas de les chercher"),
    reject('grep', "<tt>grep</tt> cherche dans les fichiers pas les fichiers"),
    good("find"),
    ),
    indices=("C'est le mot 'trouver' en anglais",
             ),
    )

find_required = require("find",
                        "Pour chercher des fichiers on utilise <tt>find</tt>")

find_dot_required = require("find .",
                            """On demande  <tt>find</tt> de chercher partout
                            dans le rpertoire courant.
                            <p>
                            Ne pas indiquer l'endroit ou l'on cherche
                            fonctionne peut-tre sous linux,
                            mais pour beaucoup d'autres systmes UNIX
                            cela ne fonctionnera pas.
                            """)

find_usr_lib_required = require("find /usr/lib",
                                """On demande  <tt>find</tt> de chercher
                                partout dans <tt>/usr/lib</tt>""")

find_name_required = require(
    "-name",
    """Il faut indiquer que le critre de recherche est le nom""")

find_dash_required = reject(
    (" type", " name", " o", " size"),
    """Vous oubliez le <tt>-</tt> devant l'option""")

find_pattern_protect_required = reject(
    " *",
    """Il faut protger le <em>pattern</em> sinon c'est le shell
    qui fait la substitution et le <tt>find</tt> ne verra
    pas le <em>pattern</em>""")

find_tilde_required = require("~",
                              "On cherche dans le rpertoire de connexion.")

dumb_replace = (
    ("./ ", ". "),
    ("~/ ", "~ "),
    ("GIF", "gif"),
    ("PNG", "png"),
    ("JPG", "jpg"),
    ("Gg", "gG"), ("Ii", "iI"), ("Ff", "fF"),
    ('-or', '-o'),
    ('-and', '-a'),
    (' -print', ''),
    (' a-x ', ' -x '),
    (' a+x ', ' +x '),
    )

dumb_replace_remove_type_f = list(dumb_replace) + [('-type f', '')]

add(name="simple",
    required=["intro"],
    question="""Quelle ligne de commande permet d'afficher
    tous les fichiers (de n'importe quel type) qui se nomment <tt>toto</tt>
    dans la hirarchie dont la racine est le rpertoire courant&nbsp;?""",
    tests=(
    shell_good("find . -name toto", dumb_replace=dumb_replace),
    shell_bad(("find toto", "find ./toto"),
              """Votre commande trouve <tt>toto</tt> dans le rpertoire
              courant et pas dans la hirarchie."""),
    shell_bad("find -name toto",
              """Cette ligne de commande fonctionne peut tre
              sur votre machine, mais pas sur un Unix standard.
              Vous devez spcifier le(s) rpertoires ou chercher.
              """),
    find_required, find_dot_required, find_name_required,
    reject("*",
           """On veut les fichiers qui se nomment <tt>toto</tt>
           pas ceux qui commence ou finissent par <tt>toto</tt>"""),
    reject("./", """Utilisez <tt>.</tt> plutt que <tt>./</tt>"""),
    shell_display,
    ),
    indices=("Le test doit tre ralis sur le nom (<em>name</em>) du fichier",
             ),
    )

add(name="fichier",
    required=["intro"],
    question="""Quelle ligne de commande permet d'afficher
    tous les fichiers de type fichier (qui ne sont pas des rpertoire,
    ni des liens symboliques, ...)
    dans la hirarchie dont la racine est le rpertoire courant&nbsp;?""",
    tests=(
    shell_good("find . -type f", dumb_replace=dumb_replace),
    find_required, find_dot_required, find_dash_required,
    require("-type",
            """Vous avez oubliez d'imposer le type de fichier recherch"""),\
    reject('*', " quoi vous sert l'toile&nbsp;?"),
    reject('!', """Pas besoin de ngation, on veut seulement
    les objets de type <tt>f</tt> comme fichier"""),
    shell_display,
    ),
    indices=("Le test doit tre ralis sur le type du fichier",
             ),
    )

add(name="taille",
    required=["intro"],
    question="""Quelle ligne de commande permet d'afficher
    tous les noms de fichiers (ou rpertoires) de plus de 1024ko
    qui sont dans la hirarchie
    dont la racine est </tt>/usr/lib</tt>&nbsp;?""",
    tests=(
    find_required, find_usr_lib_required, find_dash_required,
    require("-size",
            """Vous devez mettre l'option indiquant que le critre
            de recherche est la taille"""),
    reject("1M", "Avec 1M cela ne fonctionne pas, ou ce n'est pas portable"),
    require("1024", "Il faut indiquer la taille"),
    require("1024k", "Il faut indiquer l'unit de mesure de taille"),
    require("+1024k",
            """Il faut indiquer que vous recherchez les fichiers
            plus grand que <tt>1024k</tt> pas seulement ceux
            qui font exactement cette taille."""),
    reject("ko",
           """L'unit kilo-octet est spcifi par <tt>k</tt>
           pas par <tt>ko</tt>"""),
    reject("-size 1024",
            """Il faut indiquer que vous tes intress par
            les fichiers qui sont plus grand que"""),
    reject("*", """Pas besoin d'toile la commande cherche
    dans toute l'arborescence"""),
    shell_good("find /usr/lib -size +1024k",
               dumb_replace=dumb_replace_remove_type_f),
    shell_display,
    ),
    indices=(
    """Les arguments numriques de <tt>find</tt> peuvent
    tre prcds de <tt>-</tt> pour dire 'moins de' et
    <tt>+</tt> pour dire 'plus de'.""",
    ),    
    )

add(name="vide",
    required=["taille"],
    question="""Afficher les noms de tous les fichiers de <tt>/etc</tt>
    qui sont vides""",
    tests=(
    reject(('-0','+0'), """La taille recherche n'est ni plus grande
    ni plus petite que 0, donc pas de symbole moins ou plus"""),
    find_required, find_dash_required,
    reject('-empty', """C'est bien, vous avez trouv l'option <tt>empty</tt>.
    Votre commande marche peut tre.
    Mais n'est ce pas plus simple d'crire que la taille est nulle&nbsp;?"""),
    require('/etc', "On veut cherche dans <tt>/etc</tt>"),
    require('0', "Un fichier vide a une taille de 0 !"),
    number_of_is('/', 1, "Pas besoin de mettre des / inutiles"),
    reject('=', """Il faut un espace, pas un gale entre le
    paramtre et sa valeur"""),
    shell_good(("find /etc -size 0",
                "find /etc -size 0k",
                "find /etc -size 0b",
                ),
               dumb_replace=dumb_replace_remove_type_f),
    shell_display,
    ),
    indices=("On n'a pas besoin d'indiquer les units pour zro&nbsp!",
             ),
    )


add(name="excuter",
    required=["simple", "copier:simple"],
    before="""La commande <tt>find</tt> peut dclencher l'excution
    d'une ligne de commande shell chaque fois qu'elle trouve
    un fichier.
    La ligne suivante affiche les fichiers trouvs avec <tt>ls</tt>&nbsp;:
    <pre>find . -name "*.c" -exec ls -ld {} \;</pre>""",
    question="""Modifiez la ligne prcdente, pour faire
    un copie de tous les fichiers qui se terminent par <tt>.c</tt>
    en leur ajoutant l'extension <tt>.bak</tt>.
    Par exemple <tt>toto.c</tt> doit tre copi dans <tt>toto.c.bak</tt>
    """,
    tests=(
    require(("find", "-exec"),
            "Repartez de la ligne donne en exemple"),
    require("cp",
            "Pour faire la copie, on utilise la commande <tt>cp</tt>"
            ),
    require("{}",
            """<tt>find</tt> remplace tous les <tt>{}</tt>
            qui sont aprs le <tt>-exec</tt>
            et excute la commande pour chacun
            des fichiers qu'il trouve."""
            ),
    require("{}.bak",
            """Le nom du fichier destination n'apparat pas.
            C'est le nom du fichier trouv avec <tt>.bak</tt> derrire.
            C'est donc&nbsp;: <tt>{}.bak</tt>
            """
            ),
    number_of_is("{}", 2,
                 """La commande <\tt>cp</tt> utilise 2 arguments,
                 le nom de l'original et le nom de la copie.
                 Vous n'en fournissez qu'un seul"""),
    require("\\;",
            """Vous avez oubli le <tt>\\\\;</tt> final
            qui indique la fin de l'action <tt>-exec</tt>"""
            ),
    reject("ls", """On vous demande pas de lister les informations
    sur les fichiers, on veut les copier"""),
    shell_good("find . -name '*.c' -exec cp {} {}.bak \;", dumb_replace=dumb_replace),
    shell_display,
    ),
    )
    
    
add(name="pattern",
    required=["simple", "sh:affiche toile", "pattern:fini par tilde"],
    question="""Quelle ligne de commande permet d'afficher
    tous les fichiers et rpertoires (de n'importe quel type)
    dont le nom se termine par <tt>~</tt>
    dans la hirarchie dont la racine est le rpertoire courant&nbsp;?""",
    tests=(
    shell_good("find . -name '*~'", dumb_replace=dumb_replace),
    find_required, find_dot_required, find_name_required,
    find_pattern_protect_required,
    reject("*.*",
           """Vous n'allez pas trouver les fichiers dont
           le nom ne contient pas de caractre '<tt>.</tt>'"""),
    reject('\\~', """Pas la peine de protger le tilde
    il est spcial seulement en premire lettre"""),
    require("*~", """Je ne vois pas le <em>pattern</em> indiquant
    que le nom du fichier se termine par <tt>~</tt>"""),
    number_of_is('.',1, """Votre commande n'a besoin que d'un seul point,
    celui qui indique ou chercher"""),
                 
    shell_display,
    ),
    indices=("""N'oubliez pas que le shell remplace
    les patterns non protgs qui sont sur la ligne de commande.""",
             ),
    )


add(name="et",
    required=["pattern", "taille", "fichier"],
    before="""Vous avez besoin de trouver les plus petites bibliothques
    partages du systme. Comment faire&nbsp;?""",
    question="""Quelle ligne de commande permet d'afficher
    les noms des fichiers qui respectent les critres suivants
    (dans l'ordre)&nbsp;:
    <ul>
    <li> dans la hirarchie <tt>/usr/lib</tt>
    <li> Des vrais fichiers : de type fichier, pas les liens symboliques
    ni les rpertoires, ...
    <li> La taille est infrieur  6 kilo octets.
    <li> Le nom se termine par <tt>.so</tt>
    </ul>
    <p>
    <b>Respectez l'ordre des conditions sinon votre solution
    sera refuse.</b>
    """,
    tests=(
    shell_good("find /usr/lib -type f -size -6k -name '*.so'",
               dumb_replace=dumb_replace,
               ),
    shell_good("find /usr/lib -type f -a -size -6k -a -name '*.so'",
               """Les <tt>-a</tt> ou <tt>-and</tt> sont inutiles,
               le ET est fait par dfaut.""",
               dumb_replace=dumb_replace,
               ),
    shell_good("find /usr/lib \\( -type f -a -size -6k -a -name '*.so' \\)",
               """Les <tt>\\(</tt> et <tt>\\)</tt> sont inutiles,
               car il n'y a pas d'ambiguit""",
               dumb_replace=dumb_replace,
               ),
    find_pattern_protect_required,
    reject("-6 ", """Il faut indiquer l'unit de mesure pour la taille"""),
    require("-6k", """Il faut indiquer la taille du fichier"""),
    shell_display,
    ),
    indices=("""N'oubliez pas que le shell remplace les patterns non protgs
    qui sont sur la ligne de commande.""",
             ),
    )

    
    

add(name="casse insensible",
    required=["pattern", "sh:rpertoire connexion"],
    question="""Donner la ligne de commande permettant de rechercher
    toutes les images dont le nom se termine par <tt>.GIF</tt>
    dans votre rpertoire de connexion (et au dessous).
    Malheureusement, la casse n'est pas toujours
    respecte et peut tre&nbsp;: <tt>.GIF</tt>, <tt>.gif</tt>,
    <tt>.Gif</tt>, ...
    <p>
    Vous ne devez pas lister tous les cas possibles
    en utilisant les crochets (<tt>[Gg][Ii][Ff]</tt>)
    """,
    tests=(
    shell_good("find ~ -iname '*.gif'", dumb_replace=dumb_replace),
    shell_bad("find ~ -name '*.[gG][iI][fF]'",
              "Cela fonctionne, mais il y a plus simple",
              dumb_replace=dumb_replace
              ),
    shell_bad(("find ~ -name *.gif", "find ~ -iname *.gif"),
              """On vous a dj expliqu que la command <tt>find</tt>
              ne verrait pas le <em>pattern</em> s'il y avait un <tt>.gif</tt>
              dans le rpertoire courant car
              le shell ferait la substitution""",
              dumb_replace=dumb_replace
              ),    
    require("find", "Vous devez utiliser la commande <tt>find</tt>"),
    find_tilde_required,
    require('*', """Vous devez donner un <em>pattern</em> indiquant
    qu'il y a n'importe quoi avant <tt>.gif</tt> vous devez
    donc utilisez une toile"""),
    require("name",
            """Vous n'avez pas indiqu que le critre de recherche
            est le nom du fichier"""),
    reject("-name",
            """<tt>-name</tt> permet de chercher en respectant la casse,
            ce n'est donc pas cette option qu'il faut utiliser"""),
    reject("-ilname",
           """-lname cherche dans le nom du fichier point
           par le lien symbolique"""),
    reject(("'.gif'", "'.GIF'", '".GIF"', '".gif"'),
           """Vous cherchez les fichiers s'appellant '.gif'
           pas se terminant par '.gif'"""),
    shell_display,
    ),
    )

add(name="ou simple",
    required=["pattern"],
    question="""Ligne de commande permettant de rechercher
    tous les fichiers/rpertoires de la hirarchie courante dont
    le nom se termine par
    <tt>.sh</tt> ou <tt>.pl</tt> ou <tt>.py</tt>
    (Ne changez pas l'ordre des 3 extensions dans votre commande.)
    """,
    tests=(
    shell_good(("find . -name '*.sh' -o -name '*.pl' -o -name '*.py'",
                "find . \\( -name '*.sh' -o -name '*.pl' -o -name '*.py' \\)",
                ),
               dumb_replace=dumb_replace),
    find_required, find_dot_required, find_name_required,
    find_pattern_protect_required,
    require("-o", """N'oubliez pas d'indiquer que vous faites un ou"""),
    require(("*.sh", "*.py", "*.pl"),
            """Il manque au moins un <em>pattern</em> indiquant
            l'une des extensions  rechercher"""),
    number_of_is('-name',3,"Il faut rpter 3 fois <tt>-name</tt>"),
    reject("-name -o",
           """<tt>-name -o</tt> indique que l'on recherche un fichier
           nomm <tt>-o</tt>"""),
    shell_display,
    ),
    indices=("Lire ce qu'crit <tt>find --help</tt>",
             "'Ou' c'est <tt>-o</tt> ou <tt>-or</tt>",
             """N'oubliez pas d'indiquer l'option <tt>-name</tt>
             aprs chaque <tt>-o</tt>""",
             "Faites attention aux espaces",
             ),
    )



add(name="images",
    required=["ou simple", "casse insensible"],
    question="""Donner la ligne de commande permettant d'afficher
    les noms de toutes les images <tt>.GIF</tt>, <tt>.JPG</tt>, <tt>.PNG</tt>
    qui sont dans votre rpertoire de connexion.
    videmment on ne tient pas compte de la casse.
    """,
    tests=(
    require("-o", """N'oubliez pas d'indiquer que vous faites un ou"""),
    require('*', "S'il n'y a pas d'toile, vous cherchez un nom exacte."),
    shell_good(("find ~ -iname '*.gif' -o -iname '*.jpg' -o -iname '*.png'",
                "find ~ \\( -iname '*.gif' -o -iname '*.jpg' -o -iname '*.png' \\)",
                ),
               dumb_replace=dumb_replace),
    reject("-name", "On va a dit de ne pas tenir compte de la casse"),
    find_tilde_required,
    shell_display,
    ),
    indices=("Lire ce qu'crit <tt>find --help</tt>",
             "ou = -o = -or",
             "Ne changez pas l'ordre des tests",
             "Faites attention aux espaces",
             ),
    )


    
