#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#
import utilities
from shellParser import parse, parse_only_not_commented
from questions import _format

def _get_answer_(html_class, strings, comment, replacement, dumb_replace):
    return ("<TR CLASS='a_test test_shell " + html_class + "'>" +
            "<td class='a'></td><td class='b'></td>" +
            "<td class='c'>" + _format(strings) + "</td>" +
            "<td class='d'>" + comment + "</td>" +
            "<td class='e'>" + _format(replacement) + "</td>" +
            "<td class='f'>" + _format(dumb_replace) + "</td>" +
            "</tr>\n")

def shell_good(strings, comment='', replacement=(), dumb_replace=(),
               get_answer=False):
    strings = utilities.rewrite_string(strings)
    strings_parsed = utilities.rewrite_string(
        strings, parser = parse_only_not_commented)

    def shell_good_(v, get_answer=False):
        if get_answer:
            return _get_answer_('test_good test_is', strings, comment,
                                replacement, dumb_replace)

        commented, uncommented = parse(v, replacement, dumb_replace)
        for t in strings_parsed:
            if t == uncommented:
                return True, comment + commented
        return None, ""
    return shell_good_

def shell_bad(strings, comment='', replacement=(), dumb_replace=(),
              get_answer=False):
    strings = utilities.rewrite_string(strings)
    strings_parsed = utilities.rewrite_string(
        strings, parser = parse_only_not_commented)

    def shell_bad_(v, get_answer=False):
        if get_answer:
            return _get_answer_('test_bad test_is', strings, comment,
                                replacement, dumb_replace)
        commented, uncommented = parse(v, replacement, dumb_replace)
        for t in strings_parsed:
            if t == uncommented:
                return False, comment + commented
        return None, ""
    return shell_bad_

def shell_require(strings, comment='', replacement=(), dumb_replace=(),
              get_answer=False):
    strings = utilities.rewrite_string(strings)

    def shell_require_(v, get_answer=False):
        if get_answer:
            return _get_answer_('test_bad test_require', strings, comment,
                                replacement, dumb_replace)
        commented, uncommented = parse(v, replacement, dumb_replace)
        if uncommented == "":
            return None, ""
        for string in strings:
            if uncommented.find(string) == -1:
                return False, comment + commented
        return None, ""
    return shell_require_

def shell_reject(strings, comment='', replacement=(), dumb_replace=(),
              get_answer=False):
    strings = utilities.rewrite_string(strings)

    def shell_reject_(v, get_answer=False):
        if get_answer:
            return _get_answer_('test_bad test_reject', strings, comment,
                                replacement, dumb_replace)
        commented, uncommented = parse(v, replacement, dumb_replace)
        for string in strings:
            if uncommented.find(string) != -1:
                return False, comment + commented
        return None, ""
    return shell_reject_

def shell_display(v, get_answer=False):
    if get_answer:
        return "<tr class='test_unknown'><td colspan=6>Affiche l'arbre syntaxique</td></tr>"
    commented, uncommented = parse(v)
    return None, commented
