# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

add(name="intro",
    required=["sh:console"],
    question="""Quel est la commande standard sous UNIX pour
    pouvoir accder au manuel d'utilisation&nbsp;?""",
    tests=(
    good("man"),
    bad("info", "Cette commande n'est pas standard, c'est une commande GNU"),
    ),
    )

add(name="commande",
    required=["intro", "paginer:navigation"],
    question="""Que tapez-vous pour avoir le manuel
    de la commande <tt>man</tt>&nbsp;?""",
    tests=(
    shell_good("man man"),
    shell_bad(("man --help", "man -h"),
              "Ce n'est pas un manuel, seulement une page d'aide"),
    shell_bad("man",
              "Vous n'avez pas essay, cela retourne un message d'erreur"),
    ),
    )

add(name="section",
    required=["commande"],
    before="""Quand vous affichez une page de manuel,
    le nom de la page ainsi que la section du manuel ou
    a t trouv cette page sont affichs en haut.""",
    question="Dans quelle section du manuel trouve-t-on <tt>fstab</tt>&nbsp;?",
    tests=(
    good("5"),
    require_int,
    ),
    )

man_is_required = require("man", "On doit utiliser la commande <tt>man</tt>")

add(name="chercher",
    required=["commande", "section"],
    before="""Avoir des informations sur une commande ou le format
    d'un fichier est facile quand on connait son nom.
    Mais comment trouver ce nom&nbsp;?""",
    question="""Que tapez-vous pour avoir la liste des
    commande qui ont le mot <tt>image</tt> dans leur description&nbsp;?""",
    tests=(
    shell_good("man -k image"),
    man_is_required,
    require("-",
            """Vous devez utiliser une option de la commande <tt>man</tt>"""),
    require("-k",
            """Vous n'avez pas trouv la bonne option.
            Mot-clef en anglais ce dit <em>keyword</em>"""),
    shell_display,
    ),
    bad_answer="""Lisez le manuel de la commande <tt>man</tt> pour avoir
    la rponse""",
    )

add(name="voir aussi",
    required=["commande"],
    before="""Dans la documentation, une des choses les plus importantes
    mais la moins visible est la liste des autres documentations
    qui sont lies  celle-ci.
    En effet cette liste est  la fin de la documentation.""",
    question="Citez l'une des <b>commandes</b> lies  <tt>man</tt>",
    tests=(
    good(("manpath", "apropos", "whatis", "less", "nroff", "troff",
          "groff", "zsoelim", "mandb", "catman", "less", "setlocale",
          "ascii", "latin1")),
    reject((" ", "-"),
           """On veut un nom de commande, pas une ligne de commande"""),
    ),
    indices=("Faites <tt>man man</tt>",)
    )

add(name="section commande",
    required=["section"],
    before="""Quand on cherche la documentation de <tt>passwd</tt> cela peut
    tre celle du fichier <tt>/etc/passwd</tt> qui contient
    la description des utilisateur ou bien celle
    de la commande <tt>/usr/bin/passwd</tt> qui permet de changer
    son mot de passe""",
    question="""Quelle commande <tt>man</tt> permet d'avoir la description
    du format du fichier <tt>/etc/passwd</tt>&nbsp;?""",
    tests=(
    reject("/etc/passwd",
           """Quand vous demandez le manuel sur la commande
           <tt>ls</tt> vous ne tapez pas <tt>man /bin/ls</tt>"""),
    require("passwd",
            """Comment la commande <tt>man</tt> va deviner
            que vous voulez des informations sur
            <tt>passwd</tt>. Par tlpathie&nbsp;?"""),
    require("5",
            """Vous n'avez pas indiqu la bonne section.
            Vous devez chercher dans la section contenant
            la description des formats de fichier"""),
    shell_good("man 5 passwd"),
    shell_good("man -S 5 passwd", "Le <tt>-S</tt> est inutile"),
    shell_display,
    ),
    )
