# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

add(name="intro",
    required=["archiver:cration"],
    before="""La compression et la dcompression d'un fichier
    peut tre faites avec diffrents outils.
    <table>
    <tbody>
    <tr>
    <th>Extension</th><th>compresseur</th><th>dcompresseur</th><th>Commentaire</th>
    </tr>
    <tr>
    <td>.Z</td><td><tt>compress</tt></td><td><tt>uncompress</tt></td>
    <td>Outils standard unix maintenant totalement obsolete</td>
    </tr>
    <tr>
    <td>.gz</td><td><tt>gzip</tt></td><td><tt>gunzip</tt></td>
    <td>Outils le plus couramment utilis (<a href="http://www.gnu.org/licenses/licenses.fr.html">licence GPL</a>)</td>
    </tr>
    <tr>
    <td>.bz2</td><td><tt>bzip2</tt></td><td><tt>bunzip2</tt></td>
    <td>Plus performant que <tt>gzip</tt></td>
    </tr>
    </tbody>
    </table>""",
    question="""Si l'on suit le troupeau (demandez  <a href="http://google.com/">Google</a>) quel compresseur allons-nous utiliser&nbsp;?""",
    tests=(
    bad('zip',
        """Cet outil (non propos dans la liste) est un archiveur/compresseur,
        Ce n'est donc pas un simple compresseur"""),
    good("gzip"),
    ),
    )

add(name="comprimons",
    required=["intro"],
    question="""Quelle commande tapez-vous pour comprimer
    le fichier <tt>toto</tt>""",
    tests=(
    reject(("<",">"), "On veut la version simple sans redirection"),
    reject('tar', """On ne veut pas crer une archive contenant
    plusieurs fichiers mais simplement comrpimer un fichier"""),
    shell_good("gzip toto"),
    shell_bad("gzip -c toto", "L'option <tt>-c</tt> est inutile"),
    shell_display,
    ),
    good_answer="""Vous remarquerez que votre fichier <tt>toto</tt>
     disparu, il n'y a que <tt>toto.gz</tt>""",
    )

add(name="garde l'original",
    required=["intro", "sh:'Bonjour' dans 'toto'", "variable:lire ligne"],
    question="""Quelle commande tapez-vous pour comprimer
    le fichier <tt>toto</tt> mais en gardant l'original
    et en stockant le rsultat dans <tt>toto.gz</tt>.""",
    tests=(
    require(("<",">"),
            "Il suffit de rediriger l'entre et la sortie standard"),
    shell_good("gzip <toto >toto.gz"),
    shell_display,
    ),
    )

add(name="dcomprimons",
    required=["comprimons"],
    question="""Quelle commande tapez-vous pour dcomprimer
    le fichier <tt>toto.gz</tt>""",
    tests=(
    reject(("<",">"), "On veut la version simple sans redirection"),
    require('toto.gz', "C'est <tt>toto.gz</tt> que vous voulez dcomprimer"),
    shell_good("gzip -d toto.gz",
               """La commande que vous avez indique est excellente
               pour les scripts, mais en interactif <tt>gunzip</tt>
               est plus courte.
               Seul celle-ci sera accepte dans la suite du TP."""),
    shell_good("gunzip toto.gz"),
    shell_display,
    ),
    good_answer="""Vous remarquerez que votre fichier <tt>toto.gz</tt>
     disparu, il n'y a que <tt>toto</tt>""",
    )

add(name="garde le compress",
    required=["dcomprimons","sh:'Bonjour' dans 'toto'","variable:lire ligne"],
    question="""Quelle commande tapez-vous pour dcomprimer
    le fichier <tt>toto.gz</tt> mais en gardant l'original
    et en stockant le rsultat dans <tt>toto</tt>.""",
    tests=(
    require(("<",">"),
            "Il suffit de rediriger l'entre et la sortie standard"),
    shell_good("zcat <toto.gz >toto", "Le &lt; est inutile"),
    shell_good("zcat toto.gz >toto"),
    shell_good("gunzip <toto.gz >toto", "<tt>zcat</tt> est plus court"),
    shell_display,
    ),
    )

import archiver

add(name="comp. archive",
    required=["garde l'original", "archiver:cration", "pipeline:intro"],
    before="""Pour beaucoup de commandes Unix,
    le nom de fichier <tt>-</tt> (tiret ou moins)
    reprsente l'entre ou la sortie standard.""",
    question="""Faites un archivage du rpertoire <tt>PratiqueUnix</tt>
    et stocker l'archive compresse dans <tt>PratiqueUnix.tar.gz</tt>.
    <p>
    Attention&nbsp;:
    <ul>
    <li> Vous ne devez pas stocker un fichier non comprim sur le disque.
    <li> Vous n'avez pas besoin de chercher une nouvelle option
    dans la documentation car vous connaissez dj tout ce qui est ncessaire.
    </ul>
    """,
    tests=(
    require('-c',
            """Pour <tt>tar</tt>,
            ll faut indiquer l'option de cration <tt>c</tt>,
            N'oubliez pas le tiret avant les options.
            Il faut le mettre mme si cela marche sans."""),
    reject('gzip -', "Pas besoin d'option pour <tt>gzip</tt>"),
    require('gzip', "On comprime avec <tt>gzip</tt>"),
    require(' - ', """Ou est le tiret indiquant que <tt>tar</tt>
    doit crire l'archive sur la sortie standard&nbsp;?"""),
    
    shell_good("tar -cf - PratiqueUnix | gzip >PratiqueUnix.tar.gz",
               dumb_replace=archiver.dumb_replace),
    shell_display,
    ),
    )

add(name="decomp. archive",
    required=["comp. archive", "garde le compress"],
    question="""Dcompressez <tt>PratiqueUnix.tar.gz</tt>
    dans le rpertoire courant.
    """,
    tests=(
    require('|', "Comme pour la compression, il faut un pipeline"),
    shell_bad("gunzip PratiqueUnix.tar.gz | tar -xf -",
              """Cela ne fonctionne pas, vous venez de dcomprimer
              l'archive dans le rpertoire courant sans l'extraire.""",
               dumb_replace=archiver.dumb_replace),
    shell_good("gunzip <PratiqueUnix.tar.gz | tar -xf -",
               dumb_replace=archiver.dumb_replace),
    shell_good("zcat PratiqueUnix.tar.gz | tar -xf -",
               dumb_replace=archiver.dumb_replace),
    shell_display,
    ),    
    )




    
 
