# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

add(name="intro",
    required=["copier:recursif"],
    question="""Quel est le nom de la commande permettant d'archiver
    une hirarchie de fichier dans un seul fichier&nbsp;?""",
    tests=(
    reject('cp', """<tt>cp</tt> copier des fichiers, il ne permet
    pas de transformer un hirarchie en un seul fichier."""),
    reject(' ', "On veut seulement un nom de commande, pas d'argument"),
    good("tar"),
    bad("cpio",
        """Cette commande est standard mais n'est pas beaucoup utilise.
        Vous ne trouver pas de fichiers <tt>cpio</tt> sur
        Internet, mais des fichiers...."""),
    ),
    indices=(
    """C'est la contraction de <tt>Tape archival</tt>, <em>tape</em>
    veut dire 'bande'.""",
    ),
    good_answer="""Il est intressant d'utiliser une telle archive
    pour stocker sur une clef USB par exemple car on a l'assurance
    de ne pas perdre d'information sur les noms et les
    droits des fichiers.
    Ce qui n'est pas le cas si l'on utilise la commande <tt>cp</tt>""",
    )

dumb_replace = ( ('-fc', '-cf'), ('-fx', '-xf'), ('v', ''))

add(name="cration",
    required=["intro"],
    question="""Donnez la ligne de commande permettant
    d'archiver la hirarchie <tt>PratiqueUnix</tt>
    dans le fichier <tt>PratiqueUnix.tar</tt>""",
    tests=(
    require('-', """Mme si la commande accepte que l'on ne mette
    pas le tiret devant les options il est conseill de le mettre."""),
    require('tar', "On vous dit d'utiliser <tt>tar</tt>&nbsp;!"),
    require('f', """Vous devez utiliser l'option <tt>f</tt> pour
    indiquer le fichier destination"""),
    require('c', """Vous devez utiliser l'option <tt>c</tt> pour
    indiquer que c'est une cration d'archive"""),
    reject(('-c -f', '-f -c'), "Il est plus court d'crire <tt>-cf</tt>"),
    shell_bad("tar -cf - PratiqueUnix >PratiqueUnix.tar",
              """C'est juste, mais il y a plus court (sans
              le <tt>-</tt> et le <tt>&gt;</tt>""",
              dumb_replace=dumb_replace),
    shell_bad("tar -cf PratiqueUnix PratiqueUnix.tar",
              """Vous n'avez pas essay, il y a un problme d'ordre
              des arguments"""),
    shell_good("tar -cf PratiqueUnix.tar PratiqueUnix",
               dumb_replace=dumb_replace),
    shell_good("tar -cf PratiqueUnix.tar PratiqueUnix/",
               """Le <tt>/</tt> final n'est utile que dans le cas
               ou le rpertoire <tt>PratiqueUnix</tt> est un lien symbolique.
               En effet, si c'est le cas, alors sans le <tt>/</tt>
               c'est le lien qui serait sauvez et non le rpertoire point.""",
               dumb_replace=dumb_replace),
    shell_display,
    ),
    good_answer = """C'est une trs mauvaise ide de faire&nbsp;:
    <pre>tar -cf PratiqueUnix.tar .</pre>
    Car&nbsp;:
    <ul>
    <li> La commande va essayer d'archiver le fichier <tt>PratiqueUnix.tar</tt>
    dans lui-mme.
    <li> Et si l'on corrige le problme prcdent en mettant
    <tt>/tmp/PratiqueUnix.tar</tt> alors c'est pnible pour la personne
    qui extrait l'archive dans son rpertoire de connexion
    car cela va lui ajouter tous les fichiers de l'archive dedans :-(.
    </ul>""",
    )

add(name="extraction",
    required=["cration"],
    question="""Donnez la ligne de commande permettant
    d'extraire le contenu du fichier <tt>PratiqueUnix.tar</tt>
    en le mettant dans le rpertoire courant.""",
    tests=(
    require('tar', "On utilise <tt>tar</tt>"),
    require('-x', """Vous devez utiliser l'option <tt>x</tt> pour
    indiquer que c'est une extraction d'archive"""),
    reject(' .', """L'extraction est toujours faite dans le rpertoire courant,
    ce n'est donc pas la peine de l'indiquer."""),
    shell_good("tar -xf PratiqueUnix.tar",
               dumb_replace=dumb_replace),
    shell_display,
    ),
    )

add(name="copie distante",
    required=["cration", "extraction", "distancer:des commandes",
              "pipeline:intro", "sh:aller dans"],
    question="""On suppose que le rpertoire <tt>/tmp/toto</tt>
    sur la machine <tt>b201pc34</tt> existe et est vide.
    <p>
    Donner la ligne de commande permettant de copier la hirarchie
    courante (donc <tt>.</tt>)
    dans le rpertoire <tt>/tmp/toto</tt> de la machine <tt>b201pc34</tt>
    <p>
    Vous connaissez dj tout ce qui est ncessaire pour le faire.
    """,
    tests=(
    reject(('scp', 'rcp'), """Avec <tt>scp</tt> ou <tt>rcp</tt> c'est bien,
    mais on vous demande de rpondre avec ce que vous connaissez dj"""),
    require('tar',
            "Il faut utiliser <tt>tar</tt> pour copier une hirarchie"),
    require('|',
            "On utilise un <em>pipeline</em> pour connecter les <tt>tar</tt>"),
    require('ssh',
            "On utilise <tt>ssh</tt> pour excuter une commande  distance."),
    shell_good("tar -cf - . | ssh b201pc34 'cd /tmp/toto ; tar -xf -'",
               dumb_replace=dumb_replace),
    shell_display,
    ),
    )
    



    
