# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

dumb_replace = (
    ('-re ', '-r '), ('-er -', '-r '),
    (' -e ', ' '), ('g; s', 'g;s'), ('g ; s', 'g;s'),
    ('<tp.c', 'tp.c'), ('< tp.c', 'tp.c'), )

add(name="intro",
    required=["manuel:chercher"],
    before="""La commande <tt>sed</tt> permet d'diter
    de trs gros fichiers sans les charger en mmoire.
    Par dfaut le fichier est lu sur l'entre standard
    et la nouvelle version est crite sur la sortie standard.
    La syntaxe de base est la substitution&nbsp;:
    <pre>sed -e 's/ancien texte/nouveau texte/g'</pre>
    Le <tt>g</tt> de la fin indique que l'on remplace
    toutes les occurrences qui sont dans la ligne
    et pas seulement la premire.""",
    question="""Donner la ligne de commande permettant de remplacer
    tous les <tt>blue</tt> de l'entre standard
    par des <tt>black</tt> sur la sortie standard.""",
    tests=(
    require('/g',
            """Si vous n'indiquez pas <tt>/g</tt>
            seul la premire occurrence dans la ligne sera substitue"""),
    require('/blue/', """Je ne vois nul part de <tt>/blue/</tt>"""),
    require('/black/', """Je ne vois nul part de <tt>/black/</tt>"""),
    require('s/',
            """Je ne vois nulle part le <tt>s/</tt> qui indique
            que l'on veut faire une substitution"""),
    shell_good("sed 's/blue/black/g'", dumb_replace=dumb_replace),
    shell_display,
    ),
    )

add(name="slash",
    required=["intro"],
    before="""Le caractre d'chappement utilis dans les commandes
    <tt>sed</tt> est le mme que celui utilis dans le shell,
    dans le langage C, dans les expressions rgulires, ...""",
    question="""Donner la ligne de commande permettant de remplacer
    tous les <tt>/</tt> de l'entre standard
    par des <tt>:</tt> (deux points) sur la sortie standard.""",
    tests=(
    require('/g', """N'oubliez pas le <tt>/g</tt> !"""),
    reject("s///",
              """Vous n'avez pas essay la commande....
              <tt>sed</tt> fait une erreur car il croit qu'on
              lui demande de remplace 'vide' par 'vide'
              et aprs il y a des caractres qu'il ne comprend pas.
              <p>
              Il faut banaliser le caractre <tt>/</tt> que vous voulez
              remplacer.
              """),
    shell_good(r"sed 's/\//:/g'",
               "L'autre solution tait <tt>[/]</tt> au lieu de <tt>\\/</tt>",
               dumb_replace=dumb_replace),
    shell_good(r"sed 's/[/]/:/g'",
               "L'autre solution tait <tt>\\/</tt> au lieu de <tt>[/]</tt>",
               dumb_replace=dumb_replace),
    require('\\', "Je ne vois pas le caractre d'chappement ncessaire"),
    reject('-r', "On a pas besoin d'expression rgulire tendue"),
    shell_display,
    ),
    indices=(
    """Vous ne trouverez pas la solution en multipliant les guillemets
    ou les apostrophes car le <tt>/</tt> n'est pas un caractre
    spcial pour le shell mais pour la commande <tt>sed</tt>""",
    "Le caractre d'chappement est \\",
    ),
    )

add(name="dans fichier",
    required=["intro", "sh:redirection sortie"],
    question="""Donnez la commande prenant le contenu du
    fichier <tt>xxx</tt>, remplaant tous les <tt>a</tt> par des <tt>b</tt>
    et stockant le rsultat dans le fichier <tt>yyy</tt>""",
    tests=(
    reject(('tr', 'cat'),
           """La seule commande qui vous est ncessaire est <tt>sed</tt>"""),
    require('sed', """Il faut utiliser <tt>sed</tt> pour la substitution"""),
    require('s/a/b/g',
            """Il faut indiquer  <tt>sed</tt>
            que l'on veux remplacer tous les <tt>a</tt> par des <tt>b</tt>"""),
    shell_good(("sed 's/a/b/g' <xxx >yyy",
                "sed 's/a/b/g' xxx >yyy") , dumb_replace=dumb_replace),
    require(('<', '>'),
            """Il faut rediriger l'entre
            et la sortie standard de <tt>sed</tt>"""),
    shell_display,
    ),
    indices=("Il faut rediriger l'entre et la sortie standard",),
    )

add(name="enlve commentaires",
    required=["dans fichier", "slash", "expreg:intro"],
    question="""On veut enlever tous les commentaires dfinis
    par <tt>// commentaire jusqu' la fin de la ligne</tt>
    du fichier <tt>tp.c</tt> et stocker le rsultat dans
    <tt>tp_.c</tt>""",
    tests=(
    require(".*",
            """Vous n'avez pas indiqu le <em>pattern</em> reprsentant
            une chaine de caractre quelconque pour indiquer
            ce qu'il y a aprs le <tt>//</tt>."""),
    reject("^", "Un commentaire ne commence pas forcment en dbut de ligne"),
    reject("/g", """L'option <tt>g</tt> de <tt>sed</tt>
    est inutile car il n'y a qu'une seule substitution  faire dans
    la ligne"""),
    reject("$", """Le <tt>$</tt> est inutile car le <tt>.*</tt>
    prend le maximum de caractres possible,
    il va donc jusqu' la fin de la ligne"""),    
    shell_good(r"sed 's/\/\/.*//' tp.c >tp_.c", dumb_replace=dumb_replace),
    shell_good(r"sed 's/\/\/.*//g' tp.c >tp_.c",
               """Le <tt>/g</tt> est inutile car il ne peut
               y avoir qu'une seule occurrence.""",
               dumb_replace=dumb_replace,
               ),
    shell_good(r"sed 's/\/\/.*$//' tp.c >tp_.c",
               """Le <tt>$</tt> est inutile car c'est
               la chaine la plus longue qui est substitue.""",
               dumb_replace=dumb_replace),
    require('\\/\\/',
            """Je ne vois pas les 2 <em>slashs</em> du commentaire
            dans l'expression.
            Avez-vous oubli de les protger
            avec un <em>anti-slash</em>&nbsp;?"""),
    require('//', """Il faut indiquer que vous remplacez le commentaire
    par une chaine vide"""),
    reject('-r',
           """Vous n'avez pas besoin d'expression rgulire tendue,
           enlevez les <tt>-r</tt>"""),
    shell_display,
    ),
    indices=("Il faut rediriger l'entre et la sortie standard",
             "Il ne faut pas oublier d'annuler le <tt>/</tt>",
             ),
    )

dollar_required = require('$',
                     "Je ne vois pas le <tt>$</tt> indiquant la fin de ligne")

add(name="enlever dernier",
    required=["intro", "expreg:ligne de A"],
    question="""Donnez la commande permettant d'enlever
    le dernier caractre de chaque ligne quel qu'il soit.
    <p>
    La commande lit le fichier  transformer sur son entre
    standard et crit le rsultat sur sa sortie standard.
    C'est donc un filtre.""",
    tests=(
    dollar_required,
    require('.',
            """Je ne vois pas le <tt>.</tt> reprsentant un
            caractre quelconque"""),
    shell_good("sed 's/.$//'", dumb_replace=dumb_replace),
    shell_bad("sed 's/.$//g'",
              """Le <tt>g</tt> est inutile car il n'y a qu'une seule
              substitution  faire sur la ligne.""",
              dumb_replace=dumb_replace),
    shell_display,
    ),
    )

add(name="ajouter fin",
    required=["enlever dernier"],
    question="""Donnez le filtre ajoutant <tt>toto</tt>
     la fin de chaque ligne lue.""",
    tests=(
    dollar_required,
    shell_good("sed 's/$/toto/'", dumb_replace=dumb_replace),
    shell_display,
    ),
    indices=(
    """Commencez par rpondre  la question en remplaant le
    dernier caractre par <tt>toto</tt> puis ensuite modifiez
    la commande pour ne plus tenir compte du dernier caractre.
    <em>N'oubliez pas, on veut la commande la plus courte</em>""",    
    ),
    )
    

add(name="mot",
    required=["intro", "expreg:ngation"],
    before="""On considrera qu'un mot est un ensemble de
    caractres ne contenant pas d'espace (mais pouvant contenir
    d'autres sparateurs).""",
    question="""Donner la ligne de commande permettant de remplacer
    tous les mots par le texte suivant&nbsp;: <tt>MOT</tt>.
    On ne changera pas le nombre d'espaces entre les mots.
    """,
    tests=(
    shell_good( ("sed -r 's/[^ ]+/MOT/g'", "sed 's/[^ ][^ ]*/MOT/g'"),
                dumb_replace=dumb_replace,
                ),
    shell_bad("sed 's/[^ ]*/MOT/g'",
              """Avec cette syntaxe, insre un mot entre
              chaque paire d'espace.""",
              dumb_replace=dumb_replace),              
    shell_bad("sed 's/[^ ]+/MOT/g'",
              """Presque ! Il faut dire  <tt>sed</tt> que vous
              utilisez une expression rgulire tendue""",
              dumb_replace=dumb_replace,
              ),
    reject(".*",
           """<tt>.*</tt> prend la plus grande chaine possible
           il va donc contenir des espaces, ce n'est donc pas un mot"""),
    require("[^ ]",
            """Je ne vois pas le <em>pattern</em> reprsentant
            un caractre qui n'est pas un espace"""),
    shell_require("[^ ]+",
                  """Je ne vois pas le <em>pattern</em> reprsentant
                  un mot sans espace""",
                  dumb_replace=( ("[^ ][^ ]*", "[^ ]+"), ),
                  ),
    shell_display,
    ),
    )

add(name="squencielle",
    required=["intro"],
    question="""Donner la ligne de commande travaillant sur
    l'entre standard qui&nbsp;:
    <ul>
    <li> Remplace tous les <tt>bleu</tt> par <tt>blanc</tt>
    <li> Remplace tous les <tt>c</tt> par <tt>C</tt>
    </ul>
    <p>En lanant une seule fois la commande de remplacement.
    """,
    tests=(
    require("/bleu/blanc/",
            "Je ne vois pas la substitution de <tt>bleu</tt> en <tt>blanc</tt>"
            ),
    require("/c/C/",
            "Je ne vois pas la substitutions de <tt>c</tt> en <tt>C</tt>"
            ),
    shell_good("sed -e 's/bleu/blanc/g' -e 's/c/C/g'"),
    shell_good("sed 's/bleu/blanc/g;s/c/C/g'",
               """Dans les exercices suivant, la syntaxe avec le <tt>;</tt>
               sera refuse, il est en effet prfrable de faire&nbsp;:
               <pre>sed -e 's/bleu/blanc/g' -e 's/c/C/g'</pre>""",
               dumb_replace=dumb_replace),
    shell_display,
    ),
    indices=("Respectez l'ordre de l'nonc sinon le rsultat est diffrent",
             "Il faut indiquer plusieurs fois <tt>-e</tt>",
             ),
    )
    


add(name="inverse",
    required=["intro", "expreg:identique", "mot"],
    before="""On a un fichier contenant dans chaque ligne
    une nom et un prnom.
    On suppose que le seul espace de la ligne est entre
    le nom et le prnom.""",
    question="""Donnez la ligne de commande utilisant <tt>sed</tt> permettant
    d'inverser le nom et le prnom.
    On laissera <tt>sed</tt> travailler sur l'entre et la sortie standard.
    <p>
    Testez bien la commande avant de proposer la solution,
    comme d'habitude c'est une solution simple qui est demande.
    """,
    tests=(
    shell_good( ("sed -r 's/([^ ]*) ([^ ]*)/\\2 \\1/'",
                 "sed -r 's/(.*) (.*)/\\2 \\1/'"),
                dumb_replace=dumb_replace,
                ),
    shell_bad( ("sed -r 's/([^ ]+) ([^ ]+)/\\2 \\1/'",
                "sed -r 's/(.+) (.+)/\\2 \\1/'"),
               """Presque juste, mais cela ne fonctionne
               pas si le nom ou le prnom est vide.""",
               dumb_replace=dumb_replace),
    reject('/g', """Le <tt>/g</tt> est inutiles puisqu'il n'y a qu'une
    rptition dans la ligne"""),
    shell_display,
    ),
    indices=("""On doit donner une option particulire  <tt>sed</tt>
    pour qu'il utilise les expressions rgulire tendues""",
             """Ne mettez pas de caractres inutiles comme le <tt>$</tt>
             ou bien le <tt>g</tt>""",
             """Il faut utiliser le tout sauf espace.""",
             """Pensez  utiliser les groupes.""",
             ),
    )

les_modes = """<p>
Comme vous utilisez <tt>mv</tt> le fichier <tt>xxx</tt>
est remplac par le fichier <tt>yyy</tt> qui a t cr avec
les modes par dfaut. Les modes du fichier <tt>xxx</tt>
sont donc perdu.
Pour conserver les modes, il faut faire&nbsp;:
<tt>cat yyy >xxx ; rm yyy</tt>
"""

add(name="fiable",
    required=["dans fichier", "sh:fiable", "deplacer:intro"],
    before="""Vous aurez besoin d'un nom de fichier temporaire,
    prenez <tt>yyy</tt>""",
    question="""Donnez la ligne commande FIABLE prenant le contenu du
    fichier <tt>xxx</tt>, remplaant tous les <tt>a</tt> par des <tt>b</tt>
    et stockant le rsultat dans le fichier <tt>xxx</tt>""",
    tests=(
    require("mv",
            "Vous aviez utilis <tt>mv</tt> pour faire le remplacement fiable"),
    require("&&",
            "Vous aviez utilis <tt>&amp;&amp;</tt> pour faire le remplacement fiable"),
    shell_good(("sed 's/a/b/g' <xxx >yyy && mv yyy xxx",
                "sed 's/a/b/g' xxx >yyy && mv yyy xxx"),
               dumb_replace=dumb_replace),
    shell_good( ("if sed 's/a/b/g' <xxx >yyy ; then mv yyy xxx ; fi",
                 "if sed 's/a/b/g' xxx >yyy ; then mv yyy xxx ; fi",
                 ),
                """Une rponse plus simple&nbsp;:
                <tt>sed -e 's/a/b/g' &lt;xxx &gt;yyy && mv yyy xxx</tt>""",
                dumb_replace=dumb_replace),
    shell_bad( ("sed 's/a/b/g' <xxx >xxx", "sed 's/a/b/g' xxx >xxx"),
               """Cette commande ne fonctionne pas car le fichier est vid
               avant que <tt>sed</tt> ai eu le temps de le lire.
               Vous devez passer par un fichier intermdiaire.""",
               dumb_replace=dumb_replace,
               ),
    shell_bad( ("sed 's/a/b/g' <xxx >yyy ; mv yyy xxx",
                "sed 's/a/b/g' xxx >yyy ; mv yyy xxx",
                ),
               """Cette commande fonctionne, mais elle n'est pas fiable
               car si la substitution est arrte, le disque est plein ou
               s'il y a une erreur dans les arguments de <tt>sed</tt>
               le <tt>mv</tt> aura quand mme lieu et crasera votre fichier.
               Il faut que le <tt>mv</tt> s'excute seulement
               si le remplacement c'est bien pass.
               """,
               dumb_replace=dumb_replace,
               ),
    shell_display,
    ),
    indices=("""Utilisez <tt>mv</tt> pour remplacer <tt>xxx</tt> par
    <tt>yyy</tt>""",
             """Vous devez stocker le rsultat de la substitution
             dans <tt>yyy</tt> puis le dplacer  la place <tt>xxx</tt>
             si tout c'est bien pass""",
             ),
    good_answer="""
    Cette solution n'est pas parfaite, en effet les droits d'accs,
    le propritaire, ... du fichier on pu changer en effet ils
    ont t remplac par ceux du fichier <tt>yyy</tt> cr
    avec les valeurs par dfaut.
    <p>
    On peut contourner ce problme en remplaant <tt>mv yyy xxx</tt> par&nbsp;:
    <pre>cat yyy >xxx ; rm yyy</pre>
    L'inconvnient majeur de cette solution est qu'elle n'est plus fiable
    en effet si le disque est plein le fichier <tt>xxx</tt> est tronqu.
    <p>
    Une autre manire de contourner est de faire&nbsp;:
    <pre>chmod --reference=xxx yyy && mv yyy xxx</pre>
    Cette solution est fiable dans le cas ou vous tes propritaire
    du fichier <tt>xxx</tt>
    """,
    )



add(name="remplacer hirarchie",
    required=["fiable", "sh:boucle"],
    before="""Pour remplacer un mot par un autre dans un fichier,
    nous avons fait&nbsp;:
    <pre>sed -e 's/blue/black/g' &lt;xxx &gt;yyy && mv yyy xxx</pre>
    """,
    question="""Quelle ligne de commande permet de remplacer
    <tt>&lt;h1&gt;</tt> par <tt>&lt;h2&gt;</tt>
    dans tous les fichiers se terminant par <tt>.html</tt>
    dans le rpertoire courant.
    <p>
    Vous utiliserez la variable <tt>I</tt> comme indice de boucle.
    Et <tt>yyy</tt> comme fichier temporaire.
    """,
    tests=(
    shell_good((
    "for I in *.html ; do sed 's/<h1>/<h2>/g' <$I >yyy && mv yyy \"$I\" ; done",
    "for I in *.html ; do sed 's/<h1>/<h2>/g' <\"$I\" >yyy && mv yyy \"$I\" ; done"),
               dumb_replace=dumb_replace),
    shell_bad(
    "for I in *.html ; do sed 's/<h1>/<h2>/g' <$I >yyy && mv yyy $I ; done",
    "Ne fonctionne pas si un nom de fichier contient un espace",
    dumb_replace=dumb_replace),
    reject("xxx",
           "Vous devez remplacer <tt>xxx</tt> par le fichier  transformer"),
    require( ("<h1>", "<h2>"), "Je ne vois pas les texte  remplacer"),
    require( "for", "Vous devez faire une boucle"),
    require( "done", "Et le <tt>do</tt> / <tt>done</tt> ?"),
    require( "&&", "N'oubliez pas, on veut une substitution fiable"),
    require( '$I', "Ou utilisez-vous la variable&nbsp;?"),
    require( '"', """tes-vous sur que cela fonctionne si le nom
    des fichiers contiennent un espace&nbsp;?"""),
    reject("ls",
           "On a pas besoin de <tt>ls</tt> pour avoir la liste des fichiers"),
    shell_display,
    ),
    )

add(name="cherche PATH",
    required=["intro", "variable:intro", "sh:boucle", "sh:remplacement",
              "lister:affichage long"],
    before="""Quand on lance la commande <tt>sed</tt>,
    le shell recherche la commande dans tous les rpertoires
    indiqus dans la variable <tt>PATH</tt>.
    Il lance la premire commande trouve.
    """,
    question="""On veut excuter la commande <tt>ls -ld</tt>
    sur tous les fichiers de la forme <tt>XXX/sed</tt>
    ou les <tt>XXX</tt> sont les noms des rpertoires indiqus dans
    la variable <tt>PATH</tt>.
    Pour faire cela, vous avez besoin de&nbsp;:
    <ul>
    <li> De la boucle pour.
    <li> De remplacer une commande par le rsultat de son excution.
    Ceci pour gnrer la liste des indices de la boucle
    car les <tt>:</tt> qui sont dans <tt>PATH</tt>
    ne sont pas des sparateurs pour le shell.
    <li> Du corps de boucle pour faire le <tt>ls -ld</tt>
    </ul>
    Vous utiliserez <tt>I</tt> comme indice de boucle.
    """,
    indices=("""On utilise <tt>sed</tt> pour remplacer les ':' par des ' '""",
    """On utilise <tt>echo</tt> pour remplir
    l'entre standard de <tt>sed</tt>""",
    ),
    tests=(
    require("I", "Vous n'avez pas utilis la variable <tt>I</tt>"),
    require("PATH", "Vous n'avez pas utilis la variable <tt>PATH</tt>"),
    require("/ /", "Vous n'indiquez pas que vous remplacez par un espace"),
    require("/g",
            "Indiquez que vous voulez remplacer toutes les occurrences"),
    require("/sed",
            """On veut les informations sur le fichier <tt>sed</tt>
            dans chacun des rpertoires"""),
    shell_good(
    "for I in $(echo \"$PATH\" | sed 's/:/ /g') ; do ls -ld \"$I\"/sed ; done",
    dumb_replace=dumb_replace),
    shell_good(
        ("for I in $(echo $PATH | sed 's/:/ /g'); do ls -ld \"$I\"/sed ; done",
         "for I in $(echo \"$PATH\" | sed 's/:/ /g'); do ls -ld $I/sed ; done",
         "for I in $(echo $PATH | sed 's/:/ /g'); do ls -ld $I/sed ; done",
         ),
        """Il est fortement recommand de mettre systmatiquement
        des guillemets autour des accs aux variables&nbsp;:
        <tt>"$PATH"</tt> au lieu de <tt>$PATH</tt>""",
        dumb_replace=dumb_replace),
    shell_require(">PATH</variable>",
                  "Vous n'utilisez pas le contenu de la variable <tt>PATH</tt>"),
    shell_require(">I</variable>",
                  "Vous n'utilisez pas le contenu de <tt>I</tt>"),
    shell_display,
    ),
    good_answer="""La solution que vous avez propose est en effet
    la plus simple.
    Mais elle montre l'norme limitation du shell&nbsp;:
    il peut faire n'importe quoi ds que des variables
    contiennent des espaces.
    <p>
    Si la variable <tt>PATH</tt> contient des noms de rpertoires
    avec des espaces votre script ne fonctionnera pas.""",
    )


add(name="garde slash",
    required=["mot", "slash"],
    question="""Donner la commande lisant son entre standard
    et affichant sur sa sortie standard que les <tt>/</tt>.
    <p>
    <tt>/usr/include</tt> devient <tt>//</tt>""",
    tests=(
    reject('*', "Pourquoi utilisez-vous une rptition de caractres&nbsp;?"),
    reject('-r', "Pas besoin d'expression rgulire tendue"),
    shell_good(r"sed 's/[^\/]//g'", dumb_replace=dumb_replace),
    shell_bad( "sed 's/[^/]//g'",
                """Cela fonctionne, mais dans certain cas le /
                va tre interprt comme un sparateur et non
                un caractre de la liste.
                Il est plus prudent d'annuler sa valeur.""",
               dumb_replace=dumb_replace
               ),
    shell_display,
    ),
    )
    
add(name="annule racine",
    required=["mot", "slash"],
    question="""Donner la commande lisant son entre standard
    et affichant sur sa sortie standard ce qu'elle a lu,
     l'exception de la ligne complte <tt>/</tt>
    qui est  remplace par une ligne vide.
    <p>
    <tt>usr/include</tt> est inchang<br>
    <tt>/</tt> disparait, il reste une ligne vide""",
    tests=(
    reject("/g", """Il n'y a qu'une seule substitution  faire
    sur la ligne, vous avez mis une option de remplacement en trop."""),
    shell_good(r"sed 's/^\/$//'", dumb_replace=dumb_replace),
    shell_bad( "sed 's/^[/]$//g'",
                """Il y a plus simple que les crochets pour
                annuler la signification du slash.""",
               dumb_replace=dumb_replace),
    require(('^','$'), """Pour indiquer que <tt>/</tt> est seul sur
    la ligne, il faut indiquer qu'il va du dbut jusqu' la fin"""),
    shell_display,
    ),
    indices=("""<tt>^</tt> reprsente le dbut de ligne et
    <tt>$</tt> reprsente la fin de ligne""",),
    )

comm = """Donnez la ligne de commande affichant votre profondeur
    dans la hirarchie de fichier.    
    <p>
    Si vous tes dans <tt>/</tt> cela doit vous afficher 1.<br>
    Si vous tes dans <tt>/etc</tt> cela doit vous afficher 2.<br>
    Si vous tes dans <tt>/usr/include</tt> cela doit vous afficher 3.
    <p>
    """

add(name="profondeur wc",
    required=["compte:echo", "sh:directory courant",
              "intro", "annule racine", "garde slash", "pipeline:intro",
              "squencielle"
              ],
    question=comm + """<b>Vous utiliserez la commande <tt>wc</tt>
    pour calculer la longueur</b>""",
    tests=(
    shell_good(r'''pwd | sed -e 's/^\/$//' -e 's/[^\/]//g' | wc -c'''),
    shell_good(r'''pwd | sed    's/^\/$//' -e 's/[^\/]//g' | wc -c''',
               "Gnralement on met l'option <tt>-e</tt> deux fois"),
    shell_bad(r'''pwd | sed -e 's/[^\/]//g' | wc -c''',
              "Ne fonctionne pas pour la racine"),
    number_of_is("sed", 1,
                 "On lance la commande <tt>sed</tt> une seule fois"),
    shell_display,
    ),
    indices=( """Il faut compter le nombre de <tt>/</tt>""",
              """La racine (<tt>/</tt> tout seul) est un cas particulier,
              cela devrait tre une chaine vide.""",
              ),
    )

add(name="profondeur expr",
    required=["profondeur wc", "sh:remplacement", "calculer:longueur"],
    question=comm + """<b>Vous utiliserez la commande <tt>expr</tt>
    pour calculer la longueur</b>""",
    tests=(
    shell_good(r'''expr length "$(pwd | sed -e 's/^\/$//' -e 's/[^\/]//g')"'''),
    shell_good(r'''expr length $(pwd | sed -e 's/^\/$//' -e 's/[^\/]//g')'''),
    shell_display,               
    ),
    )

add(name="basename",
    required=["sh:boucle", "pattern:.c et .h",
              "sh:remplacement", "deplacer:intro", "slash",
              "enlve commentaires"],
    before="""La commande standard <tt>basename NomFichier Extension</tt>
    fait l'quivalent de&nbsp;:
    <pre>echo NomFichier | sed -e 's/.*\\///' -e 's/Extension$//'</pre>
    Elle enlve donc le nom du rpertoire et l'extension.
    <tt>basename /usr/include/stdio.h .h</tt> donne donc <tt>stdio</tt>
    """,
    question="""Pour tous les fichiers <tt>.c</tt> du rpertoire
    courant renommez les fichiers en remplaant le <tt>.c</tt>
    par <tt>.cpp</tt>
    <p>
    Vous utiliserez la variable shell <tt>I</tt> comme
    indice de boucle.
    """,
    tests=(
    reject("sed",
           """Utilisez la commande <tt>basename</tt>, pas <tt>sed</tt>
           qui tait l seulement pour vous expliquer."""),
    require("mv", "On renomme avec la commande <tt>mv</tt>"),
    require("for", "On doit faire une boucle <tt>for</tt>"),
    require("basename", "On veut utiliser la commande <tt>basename</tt>"),
    reject(" c", "Le fichier <tt>toc</tt> va tre renomm en <tt>tocpp</tt>"),
    require(".cpp", "On veut mettre le suffixe <tt>.cpp</tt>"),
    require('"',
            """N'oubliez pas le cas ou le nom du fichier contient un espace,
            il faut protger l'accs au variables."""),
    reject(" $I ",
           "Tous les accs aux variables doivent tre entre guillemets"),
    shell_good('for I in *.c ; do mv "$I" "$(basename "$I" .c).cpp" ; done'),
    shell_bad(('for I in *.c ; do mv "$I" $(basename "$I" .c).cpp ; done',
               'for I in *.c ; do mv "$I" "$(basename $I .c)".cpp ; done'),
              """Presque&nbsp;! Il manque encore des guillemets."""),
    shell_display,               
    ),
    good_answer="""
    Attention, je ne garantis pas que cette commande s'valuera
    correctement avec tous les interprteurs shells.
    Il y a en effet une imbrication de guillemets dans cette commande.""",
    )
    



# Pas possible
##add(name='balise HTML',
##    required=[],
##    question="""Quelle commande tapez-vous pour copier le
##    fichier <tt>xxx.html</tt> sous le nom  <tt>yyy.html</tt>
##    en passant en majuscules les balises HTML.
##    <table>
##    <tbody>
##    <tr>
##    <th>Avant</th>
##    <td>
##    &lt;p&gt;La traduction de &lt;span lang=\"en\"&gt;directory&lt;/span&gt;
##    est rpertoire.&lt;/p&gt;
##    </td>
##    </tr>
##    <tr>
##    <th>Aprs</th>
##    <td>
##    &lt;P&gt;La traduction de &lt;SPAN lang=\"en\"&gt;directory&lt;/SPAN&gt;
##    est rpertoire..&lt;/P&gt;
##    </td>
##    </tr>
##    </tbody>
##    </table>
##    """,
##    tests=(
##    good("sed xxx.html >yyy.html 's/<")
##    ),
    
##    )

# Faire le 2> /dev/null
# Faire la version avec while

              
    
    
    
    
