#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr

# To make casauth work we should not use a proxy
import os
for i in ('http_proxy', 'https_proxy'):
    if os.environ.has_key(i):
        del os.environ[i]

import urllib2
import configuration

def redirect(serv, service):
    """Redirect user browser on login page"""
    serv.send_response(307)
    serv.send_header('Location', '%s/login?service=%s' % (
        configuration.CAS,service))
    serv.end_headers()

def get_name(ticket, service):
    print service
    # raise IOError("Can't authenticate ticket")
    checkparams = "?service=" + service + "&ticket=" + ticket
    casdata = urllib2.urlopen("%s/validate?service=%s&ticket=%s" % (
        configuration.CAS, service, ticket))
    
    test = casdata.readline().strip()
    if test == 'yes':
        return casdata.readline().strip().lower()               
    else:
        raise IOError("Can't authenticate ticket")

import sys

def logout_url():
    return configuration.CAS + "/logout"
    
