#!/usr/bin/env python
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

"""
BACKUP YOUR FILES BEFORE USING THIS SCRIPT.
THIS SCRIPT DOES NOT MAKE BACKUP.

It works at 99%, the last percent must by done with your hands....

Move questions from one file to another.
  - Files are created if necessary.
  - Question files are edited to rename requireds.
  - Log files are edited to rename the question.

The parameters are:
  - The directory name (as 'unix') containing the questions
  - A list of pairs of full question names (old, new)

For example :
      'intro:basic delete' 'delete:basic' 'intro:recursive delete' 'delete:'

In the second name, the first or second part may be omited.

When a new file is created, the header of the old file is used
to create a header for the new file

"""



import os
import sys
from dotdot.pages import extract_question
import sre

def file_read(old):
    f = open(old, 'r')
    c = f.read()
    f.close()
    return c

def file_replace(old, content):
    print '\t%s < %s' % (old, content.split('\n')[0][:25])
    f = open(old, 'w')
    f.write(content)
    f.close()

def file_append(new, question, header):
    print '\t%s << %s (header=%s)' % (
        new, question.split('\n')[0], header.split('\n')[0][:25])
    if not os.path.exists(new):
        f = open(new, 'w')
        f.write(header)
        f.close()
    f = open(new, 'a')
    f.write('\n' + question)
    f.close()

def parse_name(name, error_if_empty=False):
    """Verify if the question name is legal.
    Returns the splitted question name"""
    
    if name == ':':
        raise ValueError("'%s' is an illegal name" % name)
    n = name.split(':')
    if len(n) != 2:
        raise ValueError("'%s' must contains one ':'" % name)
    if error_if_empty and (n[0]=='' or n[1]==''):
        raise ValueError("'%s' must have a filename and a question name"%name)
    return n

class Rename:
    def __init__(self, old, new):
        global full_questions_dir
        
        self.old, self.old_question = parse_name(old, error_if_empty=True)
        self.new, self.new_question = parse_name(new)
        if self.new == '':
            self.new = self.old
        elif self.new_question == '':
            self.new_question = self.old_question
        self.old_filename = os.path.join(full_questions_dir, self.old + '.py')
        self.new_filename = os.path.join(full_questions_dir, self.new + '.py')
        self.content = file_read(self.old_filename)
        self.question = extract_question(self.content, self.old_question)
        self.header = sre.findall('(?s).*\n(?:(?:from|import)[^\n]*\n)+',
                                  self.content)[0]

    def rename_question(self, text, default_file, move=False):
        # If 'move' is True then the old filename added
        # at the start of the requireds without filename.
        # add( name= '.....:....',
        # required = [ '....:....', ... ],
        new_name = '%s:%s' % (self.new, sre.escape(self.new_question))
        old_name = '%s:%s' % (self.old, sre.escape(self.old_question))

        r = r'name\s*=\s*([\'"])%s\1\s*,'
        if default_file == self.old:
            print r % sre.escape(self.old_question),'name="%s",'% new_name
            text = sre.sub(r % sre.escape(self.old_question),
                           'name="%s",'% new_name, text)
        text = sre.sub(r % sre.escape(old_name),
                       'name="%s",' % new_name, text)

        r = r'\n *required *=.*\n'
        for required in {}.fromkeys(sre.findall(r, text)):
            new = []
            value = sre.sub('.*= *', '', required)
            value = sre.sub(',\s*\n','', value)
            for i in eval(value):
                if default_file == self.old:
                    if i == self.old_question:
                        i = new_name
                if i == old_name:
                    i = new_name
                if move:
                    if i.find(':') == -1:
                        i = self.old + ':' + i
                new.append(i)
            text = text.replace(required, '\n    required='+str(new)+',\n')
        
        return text
    
    def move(self):
        global full_questions_dir
        
        for fn in os.listdir(full_questions_dir):
            if not fn.endswith('.py'):
                continue
            full_fn = os.path.join(full_questions_dir, fn)
            if full_fn == self.old_filename:
                continue
            c_orig = c = file_read(full_fn)
            c = self.rename_question(c, fn[:-3])
            if c_orig != c:
                file_replace(full_fn, c)

        file_replace(self.old_filename,
                     self.rename_question(self.content.replace(self.question,
                                                               '\n#removed\n'),
                                          self.old)
                     )
        file_append(r.new_filename,
                    self.rename_question(self.question, self.old, move=True),
                    self.header)



    def __str__(self):
        return '%s:%s ==> %s:%s' % (self.old, self.old_question,
                                    self.new, self.new_question)

def arguments(args):
    """Take all the programs argument as pairs of question names"""
    while True:
        try:
            old = args.next()
            new = args.next()
            yield Rename(old, new)
        except StopIteration:
            return

if __name__ == '__main__':
    if not os.path.exists('Students') or not os.path.exists('Questions'):
        sys.stderr.write('The script must be launched in Quenlig top dir')
        sys.exit(1)

    args = sys.argv.__iter__()
    args.next()
    questions_dir = args.next()
    full_questions_dir = os.path.join('Questions', questions_dir)
    if not os.path.isdir(full_questions_dir):
        sys.stderr.write("Can't find the questions in 'Questions'")
        sys.exit(1)
    

    d = {}
    for r in arguments(args):
        print r
        r.move()
        d[r.old + ':' + r.old_question] = r.new + ':' + r.new_question

    for session in os.listdir('Students'):
        if file_read(os.path.join('Students', session, 'questions')) \
               != full_questions_dir:
            continue
        print 'in session', session
        logs = os.path.join('Students', session, 'Logs')
        for student in os.listdir(logs):
            student_log = os.path.join(logs, student, 'log')
            if not os.path.exists(student_log):
                continue
            c_orig = c = file_read(student_log)
            
            for name in d:
                c = c.replace(name + '', d[name] + '')
            if c_orig != c:
                file_replace(student_log, c)
