# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

require_passwd = require('/etc/passwd',
                         '''Je ne vois pas le fichier <tt>passwd</tt>
                         dans votre ligne de commande''')

add(name="intro",
    required=["manuel:chercher"],
    question="""Quel commande permet de n'afficher que la fin
    d'un fichier&nbsp;?""",
    tests=(
    good("tail"),
    reject( (" ", "-"), "Que le nom de la commande, pas d'options"),
    ),
    indices=("C'est la 'queue' du fichier mais en anglais",
             "Essayez <tt>man -k last</tt>",
             ),
    )

add(name="simple",
    question="""Donnez une ligne de commande affichant les
    dernires lignes du fichier <tt>/etc/passwd</tt>""",
    tests=(
    shell_good(("tail /etc/passwd", "tail </etc/passwd")),
    reject( "-",
            "Il n'y a pas besoin d'options pour rpondre  la question"),
    require_passwd,
    shell_display,
    ),
    )

add(name="dernire",
    question="""Donnez une commande affichant la dernire ligne du fichier
    <tt>/etc/passwd</tt>""",
    tests=(
    shell_good(("tail -1 /etc/passwd",
                "tail -1 </etc/passwd",
                "tail -n1 /etc/passwd",
                "tail -n1 </etc/passwd",
                )),
    shell_bad(("tail /etc/passwd -n1",
               "tail </etc/passwd -n1",
               ),
              """Il est possible que cette commande fonctionne.
              Mais si c'est le cas c'est un bug de la commande.
              En effet les options sont toujours avant
              les noms des fichiers"""),
    shell_bad("tail -n /etc/passwd",
              "Vous n'avez mme pas essay la commande"),
    require("tail", "On utilise <tt>tail</tt> bien sur"),
    require_passwd,
    shell_display,
    ),
    )
    
