# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *

image = "<img src='boxes.png'>"

add(name="intro",
    required=["repondre:rpondre"],
    before="""
    Voici un reprsentation du systme de fichier.
    Les cases noires contiennent les noms courts des fichiers.
    Les vertes sont des fichiers de donnes excutables
    ou non et les jaunes des fichiers reprsentant des priphriques.
    La plus grand boite est la racine et ne porte pas de nom.
    Les cases <tt>.</tt> et <tt>..</tt> apparaissent
    dans tous les rpertoires.
    <p>
    """ + image,
    question="Combien de rpertoires sont visibles sur la figure&nbsp;?",
    tests=(
    good("11"),
    require_int,
    ),
    indices=("Comptez les case <tt>..</tt> ou les case blanches au choix.",
             ),
    )

reject_double_slash = reject("//",
           """Mettre plus d'un '<tt>/</tt>' revient  en mettre un seul,
           Comme dans la suite des questions on vous demande tous
           le temps la rponse la plus courte,
           celle-ci ne sera pas accepte""")

reject_space = reject(" ","On fait les concatnations sans ajouter d'espaces.")

reject_dot = reject(".",
                    """On vous a dit d'enlever tous les
                    <tt>.</tt>, <tt>..</tt> pour que cela soit court."""
                    )

def reject_trailing_slash(v):
    if v and v[-1] == '/':
        return False, """Mettre un <tt>/</tt>  la fin d'un nom n'est utile
        que dans le cas du lien symbolique
        quand on veux spcifier ce qui est point
        par le lien symbolique plutt que le lien symbolique lui-mme.
        <p>
        Ce <tt>/</tt> final n'est pas incorrecte mais vos rponses
        seront nanmoins refuses si vous le mettez"""
    return None, ""

add(name="nom absolu",
    required=["intro"],
    before="""
    Pour obtenir un nom absolu, vous partez de la boite la plus extrieure
    jusqu' celle qui vous intresse.
    Le nom absolu est la concatnation de tous les noms courts
    de ces boites en les sparant par un caractre '<tt>/</tt>'
    <p>
    """ + image + """
    <p>
    Bien que la boite extrieur ne porte pas de nom court
    son nom absolu n'est pas vide, c'est&nbsp;: <tt>/</tt>
    """,
    question="""Quel est le nom absolu de la boite dont le nom est <tt>etc</tt>
    sur la figure&nbsp;?""",
    tests=(
    good("/etc"),
    bad("//etc",
        """Cette rponse fonctionne mais est  viter car elle
        est non-portable."""),
    require("etc",
            """Je ne vois pas <tt>etc</tt> comment
            est-ce que cela peut le dsigner&nbsp;?"""),
    reject_trailing_slash,
    reject_double_slash,
    reject_space,
    ),
    indices=(
    """Comme <tt>etc</tt> est dans la plus grande boite
    la rponse est&nbsp;: <tt>nom court de la racine/nom court de la boite etc</tt>""",
    """Le nom court de la racine est une chaine de caractre vide.""",
    ),
    )

add(name="nom absolu 2",
    required=["nom absolu"],
    before=image,
    question="""Quel est le nom absolu de la boite
    dont le nom est <tt>xemacs</tt> sur la figure&nbsp;?""",
    tests=(
    good("/usr/bin/xemacs"),
    reject_trailing_slash,
    reject_double_slash,
    reject_space,
    ),
    indices=(
    """La rponse est&nbsp;:
    <tt>nom court racine/nom court 1/nom court 2/nom court xemacs</tt>""",
    ),
    )

add(name="point",
    required=["nom absolu 2"],
    before="""Le contenu de la boite <tt>.</tt> est le mme que
    celui de la boite qui la contient.
    C'est  dire que <tt>/etc/.</tt> est la mme chose que
    <tt>/etc</tt><p>""" + image,
    question="""Donnez le nom absolu le plus court qui
    reprsente la mme chose que <tt>/./home/././p0123456/Toto/.</tt>
    """,
    tests=(
    good("/home/p0123456/Toto"),
    require(("home", "p0123456", "Toto"),
            "Il manque des noms courts dans votre chemin"),
    require("/",
            "C'est un chemin absolu, il doit contenir des <tt>/</tt>"),
    reject_trailing_slash,
    reject_double_slash,
    reject_space,
    reject_dot,
    ),
    )

add(name="point point",
    required=["nom absolu 2"],
    before="""Le contenu de la boite <tt>..</tt> est la mme que
    celui de la boite qui la contient.
    C'est--dire que <tt>/usr/include/..</tt> est la mme boite que
    <tt>/usr</tt>
    <p>
    <tt>/..</tt> est un cas particulier car il n'y a pas
    de boite au dessus et il reprsente la mme
    chose que <tt>/</tt>
    <p>
    """ + image,
    question="""Donnez le nom absolu le plus court qui
    reprsente la mme chose que <tt>/home/p0123456/Toto/..</tt>""",
    tests=(
    good("/home/p0123456"),
    reject_trailing_slash,
    reject_double_slash,
    reject_space,
    reject_dot,
    ),
    )
    
add(name="point point 2",
    required=["point point", "point"],
    before=image,
    question="""Donnez le nom absolu le plus court qui
    reprsente la mme chose que <tt>/./home/./p0123456/../../toto</tt>""",
    indices=(
    """Un nom de fichier inexistant est ncessaire si l'on dsire
    crer le fichier""",
    ),
    tests=(
    good("/toto"),
    reject_trailing_slash,
    reject_double_slash,
    reject_space,
    reject_dot,
    ),
    )

add(name="rpertoire courant",
    required=["nom absolu 2"],
    before="""
    Tous les processus ont un rpertoire courant,
    le rpertoire courant permet d'crire des noms
    de fichier relatif qui sont beaucoup plus court
     crire que les noms de fichier absolu.
    <p>
    Le chemin absolu du fichier indiqu en relatif
    est la concatnation du chemin absolu du rpertoire
    courant d'un <tt>/</tt> et du chemin relatif.
    <p>
    Les chemins relatifs ont l'avantage de pouvoir tre exprims
    sans rfrence  l'endroit ou sont stocks les fichiers.
    <p>
    Si <tt>/usr</tt> est le rpertoire courant
    alors le chemin relatif <tt>include</tt>
    indique le rpertoire <tt>/usr/include</tt>.    
    <p>
    """ + image,
    question="""Si <tt>/usr</tt> est le rpertoire courant,
    quel est le chemin relatif le plus court indiquant
    <tt>/usr/bin</tt>""",
    tests=(
    good("bin"),
    bad("/bin", "Vous venez de donner un nom absolu et non relatif"),    
    reject_trailing_slash,
    reject_dot,
    reject_space,
    ),
    )

add(name="relatif",
    required=["rpertoire courant"],
    before=image,
    question="""Si <tt>/usr</tt> est le rpertoire courant,
    quel est le chemin relatif le plus court indiquant
    <tt>/usr/bin/xemacs</tt>""",
    tests=(
    good("bin/xemacs"),
    reject_double_slash,
    reject_space,
    reject_dot,
    ),
    )


add(name="ici",
    required=["rpertoire courant", "point"],
    question="""Donnez le nom relatif le plus court indiquant le rpertoire courant""",
    tests=(
    good("."),
    bad("~",
        "Ce n'est pas le rpertoire courant mais le rpertoire de connexion"),
    bad("pwd",
        """C'est le nom d'une commande affichant le rpertoire courant.
        On vous demande un nom de fichier, pas une commande  excuter"""),
    reject_trailing_slash,
    ),
    indices=("La rponse tient sur un caractre",
             ),
    )

add(name="pre",
    required=["rpertoire courant", "point point"],
    question="""Donnez le nom relatif le plus court indiquant le pre du rpertoire courant""",
    tests=(
    good(".."),
    reject_trailing_slash,
    ),
    indices=("La rponse tient sur deux caractres",
             ),
    )

add(name="relatif 2",
    required=["relatif", "point point"],
    before=image,
    question="""Si <tt>/usr/include</tt> est le rpertoire courant,
    quel est le chemin relatif le plus court indiquant
    <tt>/usr/bin/xemacs</tt>""",
    tests=(
    good("../bin/xemacs"),
    reject("usr", "Essayez de ne pas crire <tt>usr</tt>"),
    reject_double_slash,
    reject_space,
    reject_trailing_slash,
    ),
    )

add(name="relatif 3",
    required=["relatif", "point point"],
    before=image,
    question="""Si <tt>/home/p0123456/Toto</tt> est le rpertoire courant,
    quel est le chemin relatif le plus court indiquant
    <tt>/home/p0123456/.profile</tt>""",
    tests=(
    good("../.profile"),
    bad("~/.profile", "On vous demande un chemin relatif"),
    require(".profile",
            """Le chemin relatif indique forcment sa destination&nbsp;:
            <tt>.profile</tt>"""),
    reject_double_slash,
    reject_space,
    reject_trailing_slash,
    ),
    )

add(name="rp. connexion",
    required=["nom absolu 2"],
    before="""Quand un paramtre d'une commande commence
    par une certaine squence de caractres,
    le shell (l'interprteur de commande, pas Unix)
    remplace cette squence de caractres par
    le nom absolu du rpertoire de connexion.""",
    question="""Quel est la squence de caractre qui
    est remplace par le rpertoire de connexion&nbsp;?""",
    tests=(
    good("~/"),
    good("~",
        """Non, car dans <tt>~toto/x</tt>, <tt>~toto</tt> est remplac
        par le rpertoire de connexion de <tt>toto</tt>.
        Je vous accorde la rponse.
        """),
    bad("$HOME",
        """Non, car si la valeur de la variable <tt>HOME</tt> change,
        cela ne sera plus le rpertoire de connexion.
        De plus, c'est un peu long  taper."""),
    reject_double_slash,
    reject_space,
    reject_dot,
    ),
    )

image = "<a href='graphe.png'><img src='graphe_small.png'></a>"

add(name="graphe",
    required=["relatif 3"],
    before=image,
    question="""Votre rpertoire courant est <tt>/home/p0123456/Toto</tt>,
    quel est le chemin relatif le plus court indiquant
    <tt>/usr/bin</tt>""",
    tests=(
    good("../../../usr/bin",
         """Si vous tes certain que votre racine ne changera pas
         d'emplacement, <tt>/usr/bin</tt> est plus court.
         Mais dans certain cas, il est intressant de tout
         faire en relatif."""),
    reject_double_slash,
    reject_space,
    reject_trailing_slash,
    ),
    )

image = "<a href='graphe_cercle.png'><img src='graphe_cercle_small.png'></a>"

add(name="rp. connexion 2",
    required=["rp. connexion"],
    before=image,
    question="""Donnez le nom absolu
    (bien que ne commenant pas par <tt>/</tt>)
    le plus court dsignant le fichier <tt>/home/p0123456/toto</tt>
    si vous tes l'utilisateur <tt>p0123456</tt>""",
    good_answer="""Ce n'est pas un nom reconnu par Unix.
    C'est le shell qui fait la substitution.
    Cela ne fonctionne donc que dans la ligne de commande ou les scripts.""",
    tests=(
    good("~/toto"),
    bad("toto",
        """Ceci est juste seulement si votre rpertoire courant
        est votre rpertoire de connexion.
        Mais si ce n'est pas le cas&nbsp;?"""),
    require("~",
            """Vous savez dj que <tt>~/</tt> est remplac
            par le shell par votre rpertoire de connexion"""),        
    reject_double_slash,
    reject_space,
    reject_trailing_slash,
    reject_dot,
    ),
    )

image = "<a href='tree.svg'><img border=0 src='tree_small.png'></a>"

add(name="arbre",
    required=["graphe"],
    before=image,
    question="""Dans la figure,
    combien <tt>/home</tt> contient de rpertoires&nbsp;?""",
    tests=(
    good("1"),
    bad("2",
        """On vous demande le nombre de rpertoires dans <tt>/home</tt>
        Il ne faut pas compter ceux qui sont dans ses sous rpertoires."""),
    good("3",
         """J'accepte cette rponse car je suppose que vous
         avez compt <tt>.</tt> et <tt>..</tt> bien qu'ils ne
         soient pas affichs sur le dessin."""),
    require_int,
    ),
    )
    
add(name="final",
    required=["point point 2", "pre", "ici", "arbre",
              "relatif 2", "rp. connexion 2"],
    question="Quel est le nom absolu de fichier le plus court&nbsp;?",
    tests=(
    good("/"),
    bad("~",
        """Ceci est un pattern du shell,
        il est en effet remplac par un nom absolu.
        Ce nom n'est pas connu par le noyau Unix.
        """),
    require("/", "Un nom absolu commence par un <tt>/</tt>"),
    ),
    )

