# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

add(name="intro",
    required=["sh:console"],
    question="""Quel est le nom de la commande permettant
    de faire disparatre (dtruire) les fichiers&nbsp;?""",
    tests=(
    good("rm"),
    ),
    indices=("En anglais cela vient du mot <em>remove</em>",
             """Elle est dans la liste affiche par :
             <tt>man -k 'remove.*file'</tt>""",
             ),
    )

add(name="simple",
    question="""Quelle commande permet de dtruire les
    deux fichiers nomms :
    <ul>
    <li><tt>a</tt> (donc dans le rpertoire courant)
    <li><tt>/tmp/a</tt>
    </ul>""",
    tests=(
    shell_good("rm a /tmp/a"),
    shell_good("rm /tmp/a a", "Pourquoi avez-vous chang l'ordre&nbsp;?"),
    shell_require("<argument>a</argument>",
                  "On veut dtruire <tt>a</tt> dans le rpertoire courant."),
    shell_require("<argument>/tmp/a</argument>",
                  "On veut dtruire <tt>a</tt> dans le rpertoire <tt>/tmp</tt>"),
    shell_require("<argument>rm</argument>",
                  "On utilise la commande <tt>rm</tt>"),
    reject(";", "On veut lancer qu'une seule commande"),
    reject("~/a",
           "<tt>a</tt> dans le rpertoire courant, pas celui de connexion"),
    reject("./a",
           """Il y a plus court que <tt>./a</tt> pour indiquer <tt>a</tt>
           dans le rpertoire courant"""),
    shell_display,
    ),
    )
    

add(name="problmes",
    required=["simple", "sh:affiche toile", "lister:spcial"],
    question="""Quelle commande permet de dtruire les
    fichiers nomms <tt>*</tt> et <tt>-z</tt>""",
    tests=(
    shell_good("rm '*' -z"),
    shell_good("rm '*' ./-z",
               """Le <tt>./</tt> devant <tt>z</tt>
               est inutile car on considre qu'il n'y a plus d'options
               aprs la premire chose qui n'est pas une option (<tt>*</tt>
               dans cet exemple)"""),
    shell_good("rm ./-z '*'",
               "La rponse attendue tait <tt>rm '*' -z</tt>"),
    shell_reject("<argument>./*</argument>",
                 "Le <tt>./</tt> devant l'toile ne sert  rien"),
    shell_reject("<pattern_char>*</pattern_char>",
                 "Il faut protger l'toile car <tt>rm</tt> doit la voir"),
    shell_require("<argument>*</argument>",
                   """Il faut dtruire tous les fichiers
                   du rpertoire courant, on utilise un <em>pattern</em>"""),
    reject((" ./* ", " * "),
           "Cela dtruit tous les fichiers du rpertoire&nbsp;!"),
    reject(" -- ",
           """C'est bien d'avoir trouv l'astuce du <tt>--</tt>
           mais elle n'est pas portable..."""),
    require("-z", "Il faut dtruire <tt>-z</tt>"),
    shell_display,
    ),
    )
    

add(name="pattern",
    required=["simple", "pattern:final"],
    question="""Donnez la ligne de commande permettant de dtruire
    tous les fichiers dont le nom se termine par <tt>.o</tt>
    dans le rpertoire courant""",
    tests=(
    shell_good("rm *.o"),
    reject("./*.o", """On peut faire un <em>pattern</em> plus court."""),
    shell_display,
    ),
    )

dumb_replace=(("-R","-r"),)

add(name="pattern arbre",
    required=["simple", "sh:remplacement", "chercher:pattern", "chercher:excuter"],
    question="""Donnez la ligne de commande permettant de dtruire
    tous les fichiers dont le nom se termine par <tt>.o</tt>
    dans le rpertoire courant et toute la hirarchie de rpertoires
    au dessous.""",
    tests=(
    shell_good("find . -name '*.o' -exec rm {} \;"),
    shell_good( ( "rm $(find . -name '*.o')",
                  "find . -name '*.o' | xargs rm" ),
                """Cette commande est dangereuse dans le cas ou les noms de
                fichiers contiennent des espaces ou des retours  la ligne
                car le shell considre que ce sont des sparateurs"""
                ),
    shell_bad("rm -r '*.o'",
              """La commande <tt>rm</tt> va dtruire rcursivement
              l'unique fichier nomm <tt>*.o</tt> qu'il soit un fichier
              ou un rpertoire.""",
              dumb_replace=dumb_replace,
              ),
    shell_bad("rm -r *.o",
              """Le shell remplace le <tt>*.o</tt> par tous les
              fichiers qui correspondent dans le rpertoire courant.
              Ensuite <tt>rm</tt> les dtruit rsursivement.
              Du coup, un rpertoire nomm <tt>toto.o</tt> voit
              son contenu dtruit mme s'il ne se termine pas par <tt>.o</tt>,
              Et le fichier <tt>toto/x.o</tt> n'est pas dtruit.""",
              dumb_replace=dumb_replace,
              ),
    shell_require("<argument>*.o</argument>",
                  """<tt>find</tt> ne voit pas le <em>pattern</em>
                  car le shell l'a peut-tre substitu"""),
    require("find","Il faut utiliser <tt>find</tt> pour trouver les fichiers"),
    reject(("-R", "-r"), "Pourquoi dtruire rcursivement&nbsp;?"),
    shell_display,
    ),
    indices=("Il faut utiliser <tt>find</tt> pour trouver les fichiers",
             ),
    )



    

    
