# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

grep_required = require("grep","On utilise <tt>grep</tt> pour cribler")
grep_e_inutile = reject("-e",
                        """L'option <tt>-e</tt> est inutile si
                        il y a un seul <em>pattern</em>""")

add(name="intro",
    required=["manuel:chercher"],
    question="""Quel est le nom de la commande permettant d'afficher
    les lignes d'un fichier contenant une chaine de caractres spcifique.
    """,
    tests=(
    good("grep"),
    good("fgrep", "On utilise plutt <tt>grep -F</tt>"),
    good("egrep", "On utilise plutt <tt>grep -E</tt>"),
    ),
    )

add(name="simple",
    question="""Quelle est la commande la plus simple pour afficher
    toutes les lignes du fichier <tt>/etc/passwd</tt>
    contenant la chaine de caractre <tt>/var</tt>""",
    tests=(
    shell_good("grep /var /etc/passwd"),
    grep_required,
    reject(("|","<"),
           """On veut une solution simple,
           sans redirection de l'entre standard
           que cela soit par <tt>&lt;</tt> ou <tt>|</tt>."""),
    require("/etc/passwd",
            """Il faut indiquer le nom du fichier
            dans lequel on veut chercher.
            (Sans fautes d'orthographe)"""),
    grep_e_inutile,
    shell_display,
    ),
    )

add(name="source",
    required=["simple", "pattern:final"],
    question="""Quelle est la commande la plus simple pour afficher
    toutes les lignes qui contiennent la chane 'sqrt'
    dans tous les fichiers avec l'extension '.c'
    qui sont dans le rpertoire courant""",
    tests=(
    shell_good(("grep sqrt *.c","grep -h sqrt *.c") ),
    grep_required,
    grep_e_inutile,
    reject(".C",
           "L'extension est <tt>.c</tt> pas <tt>.C</tt>"
           ),
    reject("./*.c",
           """Simplifiez votre <em>pattern</em>
           il contient des caractres inutiles"""
           ),
    reject("find",
           """Les fichiers du rpertoire courant,
           pas ceux qui sont au dessous."""
           ),
    reject("|",
           """Pas besoin de pipeline pour
           faire une commande aussi simple."""
           ),
    shell_display,
    ),
    )

add(name="ou",
    required=["simple"],
    question="""Quelle est la commande la plus simple pour afficher
    toutes les lignes du fichier <tt>/etc/passwd</tt>
    contenant la chaine de caractres <tt>/var</tt> ou <tt>/usr</tt>""",
    tests=(
    shell_good(("grep -e /var -e /usr /etc/passwd",
                "grep -e /usr -e /var /etc/passwd",
                )),
    shell_good(("grep -E -e '/usr|/var' /etc/passwd",
                "grep -E -e '(/usr|/var)' /etc/passwd",
                "grep -Ee '/usr|/var' /etc/passwd",
                "grep -Ee '(/usr|/var)' /etc/passwd",
                ),
               """Il y avait plus simple :
               <tt>grep -e /var -e /usr /etc/passwd</tt>"""),
    shell_bad("grep /etc/passwd -e /var /usr",
              """Cette commande est FAUSSE, de plus il faut
              toujours mettre les options au dbut de la liste
              des arguments"""
              ),
    shell_reject("grep -e /var /usr",
                 """Quand <tt>grep</tt> lit ses arguments il croit
                 qu'il faut commencer  chercher <tt>/var</tt>
                 dans le fichier nomm <tt>/usr</tt>.
                 Il faut rpter le <tt>-e</tt> devant chaque
                 chaine que l'on dsire rechercher."""
                 ),
    reject("|",
           """N'utilisez pas d'expression rgulire
           pour cet exercice, car la rponse est plus courte mais plus
           complique  trouver"""),
    require("-e", "Il faut utiliser l'option <tt>-e</tt>"),
    require("grep /etc/passwd",
            "On met le <em>pattern</em> avant les fichiers."),
    shell_display,
    ),
    indices=("""L'option  utiliser est <tt>-e</tt>""",
             ),
    )
    
add(name="casse",
    required=["simple"],
    before="""Bien qu'il soit possible d'crire des
    <em>patterns</em> de la forme <tt>[Tt][Oo][Tt][Oo]</tt>.
    Ce n'est pas du tout joli et c'est long  crire.
    La rponse attendue  cette question n'utilise
    donc pas cette astuce.""",
    question="""Quelle est la commande la plus simple pour cribler
    toutes les lignes contenant <tt>toto</tt> et ceci
    indpendemment de la casse (diffrence majucule/minuscule).""",
    tests=(
    shell_good("grep -i toto"),
    shell_bad("grep toto -i",
               """Bien que cela fonctionne sur Linux ce n'est pas portable.
               il faut mettre les options avant les autres arguments"""),
    grep_required,
    require("toto", "Quelle chaine de caractre voulez-vous chercher&nbsp;?"),
    require("-", "Vous devez ajouter une option"),
    shell_display,
    ),
    indices=("""En anglais 'casse' se dit 'case' comme dans 'upercase' et
    'lowercase' pour majuscule et minuscule.""",
            """Tapez 'grep --help' pour avoir l'aide""",
            ),
    )

add(name="lister",
    required=["simple", "pattern:final"],
    question="""Quelle est la commande la plus simple pour
    seulement lister les noms des fichiers dans <tt>/etc</tt>
    qui contienne le mot <tt>a4</tt>
    Ce n'est pas grave si votre commande affiche des erreurs
    parce qu'elle ne peut pas lire les rpertoires.""",
    tests=(
    shell_good("grep -l a4 /etc/*"),
    grep_required,
    require("/etc/*",
            """Pour passer la liste de tous les fichiers qui
            sont dans <tt>/etc</tt> on utilise un <em>pattern</em>"""
            ),
    require("-l",
            """Il manque l'option indiquant que l'on veut
            lister les noms des fichiers qui contiennent
            cette ligne.
            On ne veux pas afficher les lignes trouves"""),
    reject("-L",
           """On veut lister les fichiers qui contienne
           le texte. Pas ceux qui ne le contiennent pas."""),    
    shell_display,
    ),
    bad_answer="On veut lister les noms des fichiers, pas les lignes qu'ils contiennent, regardez  nouveau les options de <tt>grep</tt>",
    )

add(name="lister sans erreur",
    required=["lister", "sh:redirection erreur", "device:poubelle"],
    question="""Compltez la commande suivante
    pour que les messages d'erreur existant ne s'affiche pas.
    <pre>grep -l a4 /etc/*</pre>
    """,
    tests=(
    shell_good("grep -l a4 /etc/* 2>/dev/null"),
    require("2>", "Il faut rediriger la sortie d'erreur"),
    require("/dev/null", "Il faut utiliser le priphrique poubelle"),
    reject(("-s", "-ls", "-sl"),
           """La documentation vous dit de ne pas utiliser
           L'option <tt>-s</tt>"""),
    shell_display,
    ),
    )


