# -*- coding: latin-1 -*-
#    QUENLIG: Questionnaire en ligne (Online interactive tutorial)
#    Copyright (C) 2005-2006 Thierry EXCOFFIER, Universite Claude Bernard
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    Contact: Thierry.EXCOFFIER@bat710.univ-lyon1.fr
#

from questions import *
from check import *

a = "<tt>mv a b</tt> est plus simple et plus court"

add(name="intro",
    required=["manuel:chercher"],
    question="""Quelle commande permet de copier des fichiers&nbsp;?""",
    tests=(
    good("cp"),
    ),
    indices=("Abbrviation de <em>copy</em> en anglais", ),
    )

add(name="simple",
    question="""Donnez la commande permettant de copier le fichier
    texte <tt>A</tt> dans <tt>B</tt>""",
    tests=(
    shell_good("cp A B"),
    shell_bad("cat A >B",
              """Cela fonctionne, mais on vous demande d'utiliser
              la commande de copie"""),
    reject("./", "Le <tt>./</tt> est inutile"),
    shell_display,
    ),
    )


