/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jeumaladie;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Classe Patient
 * @author remi.watrigant
 */
public class Patient {
    
    /**
     * attribut static qui va compter les malades
     */
    private static int nbMalades = 0;
    
    /**
     * les autres attributs du patient
     */
    private double vie;
    private double age;    
    private String nom;
    private String prenom;    
    private Set<Maladie> lesMaladies;

    
    public Patient() {
    	
    }
    
    /**
     * Constructeur 
     * @param nom nom du patient
     * @param prenom prenom du patient
     * @param vie points de vie du patient
     * @param age age du patient
     */
    public Patient(String nom, String prenom, double vie, double age) {
        this.nom = nom;
        this.prenom = prenom;
        this.vie = vie;
        this.age = age;
        lesMaladies = new HashSet<Maladie>();
    }

    /**
     * ajoute une maladie au patient.
     * clone la maladie reçue en parmètre (relation de composition)
     * @param m la maladie à ajouter
     */
    public void ajoutMaladie(Maladie m) {
        try {
            //si c'est la première maladie, on incrémente le nombre de patients malades
            if (lesMaladies.size() == 0) {
                nbMalades++;
            }
            
            lesMaladies.add((Maladie)m.clone());
        } catch (CloneNotSupportedException ex) {
        	ex.printStackTrace();
        }
    }

    /**
     * applique l'évolution des maladies du patient
     */
    public void subirMaladie() {
        int impact;
        for (Maladie m : lesMaladies) {
            impact = m.evolue();
            if (age < 15) {
                vie -= impact * 1.25;
            } else if (age > 65) {
                vie -= impact * 1.33;
            } else {
                vie -= impact;
            }
        }
    }

    /**
     * applique un médicament à toutes les maladies
     * @param med le médicament à appliquer
     */
    public void seSoigner(Medicament med) {
        Set<Maladie> maladiesEradiquees = new HashSet<Maladie>();
        
        for (Maladie m : lesMaladies) {
            m.traiter(med);
            //si la maladie est éradiquée, elle est supprimée de la liste
            if (m.etat()) {
                maladiesEradiquees.add(m);
            }
        }
        
        lesMaladies.removeAll(maladiesEradiquees);
        
        //si il n'y a plus de maladies, le patient est sain
        if (lesMaladies.size() == 0) {
            nbMalades--;
        }
    }

    /**
     * teste si le patient est malade (s'il a une maladie)
     * @return vrai ssi le patient est malade
     */
    public boolean estMalade() {
        return lesMaladies.size() > 0 ;
    }

    /**
     * teste si le patient est mort
     * @return vrai ssi le patient est mort (plus de point de vie)
     */
    public boolean estMort() {
        return vie <= 0;
    }
    
    /**
     * affiche le résumé d'un patient
     * @return le résumé du patient
     */
    public String toString() {
        String str = "";
        str += nom+" "+prenom+"\n";
        str += "\tage : "+age+"\n";
        str += "\tpoints de vie : "+vie+"\n";
        str += "\tsymptomes : ";
        for (Maladie maladie : this.lesMaladies) {
            str += maladie.toString()+" ";
        }
        str += "\n\n";
        return str;
    }

    /**
     * getter des maladies du patient
     * @return la liste des maladies du patient
     */
    Iterable<Maladie> getMaladies() {
        return this.lesMaladies;
    }


}
