/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jeumaladie;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import jeumaladie.Medicament.Type;

/**
 *
 * @author remi
 */
public class Moteur {

    private List<Patient> patients;

    private List<Maladie> maladiesPossibles;

    public Moteur(int nbPatients) {
        initMaladies();
        initPatients(nbPatients);

    }

    private void initMaladies() {
        
        	
        maladiesPossibles = new ArrayList<Maladie>();
        Maladie grippe = new Virus("Grippe", (int) Math.round(Math.random() * 100), (int) Math.round(Math.random() * 10) + 1, "etat grippal");
       
        maladiesPossibles.add(grippe);
        Maladie angine = new Virus("angine", (int) Math.round(Math.random() * 100), (int) Math.round(Math.random() * 10) + 1, "mal a la gorge");
        maladiesPossibles.add(angine);
        Maladie gastro = new Bacterie("gastro", (int) Math.round(Math.random() * 100), (int) Math.round(Math.random() * 10) + 1, "vomissement diarhees", (int) (Math.round(Math.random() * 4) + 1));
        maladiesPossibles.add(gastro);
        Maladie toxo = new Parasite("toxo", (int) Math.round(Math.random() * 100), (int) Math.round(Math.random() * 10) + 1, "fievre");
        maladiesPossibles.add(toxo);
    }

    public void start() {
       

        while (tousSains() != true && unMort() != true) {

            for (Patient patient : this.patients) {
                consultation(patient);
            }

            evolutionMaladies();

        }

        if (tousSains()) {
            System.out.println("tous sains !");
        } 
        if (unMort()) {
            System.out.println("un mort !");
        }
    }

    

    private void initPatients(int nbPatients) {
        patients = new ArrayList<Patient>();

        for (int i = 0; i < nbPatients; i++) {
            Patient patient = new Patient("Patient", String.valueOf(i + 1), 100, Math.round(Math.random() * 100));
            int nbMaladies = (int) Math.round(Math.random() * 2)+1 ;
            for (int j = 0; j < nbMaladies; j++) {
                patient.ajoutMaladie(this.maladiesPossibles.get((int) Math.round(Math.random() * (this.maladiesPossibles.size()-1))));
            }

            patients.add(patient);
        }
    }

    private boolean tousSains() {
        for (Patient patient : this.patients) {
            if (patient.estMalade()) {
                return false;
            }
        }
        return true;
    }

    private boolean unMort() {
        for (Patient patient : this.patients) {
            if (patient.estMort()) {
                return true;
            }
        }
        return false;
    }

    private void consultation(Patient patient) {
        System.out.println("\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
        System.out.println(patient);

        int choix = -1;
        while (choix <= 0 || choix >= 5) {
            System.out.println("Choisir médicament :");
            System.out.println("\t1) Antibiotique");
            System.out.println("\t2) Antiviral");
            System.out.println("\t3) Antalgique");
            System.out.println("\t4) Antiparasite");
            Scanner keyboard = new Scanner(System.in);
            System.out.print("Votre choix :");
            choix = keyboard.nextInt();
        }
        
        Medicament med = null;
        
       
        

        
        
        switch (choix) {
            case 1: 
                med = new Medicament("Antibiotique", Medicament.Type.ANTIBIOTIQUE, "soigne", (int)Math.round(Math.random()*4)+1 ); 
                break;
            case 2: 
                med = new Medicament("Antiviral", Medicament.Type.ANTIVIRAL, "soigne", (int)Math.round(Math.random()*4)+1 ); 
                break;
            case 3: 
                med = new Medicament("Antalgique", Medicament.Type.ANTIBIOTIQUE, "soigne", (int)Math.round(Math.random()*4)+1 ); 
                break;
            case 4: 
                med = new Medicament("Antiparasitaire", Medicament.Type.ANTIPARASITE, "soigne", (int)Math.round(Math.random()*4)+1 ); 
                break;
            default:
                med = new Medicament("Antalgique", Medicament.Type.ANTIBIOTIQUE, "soigne", (int)Math.round(Math.random()*4)+1 ); 
                break;                
        }
        
        patient.seSoigner(med);
        
    }

    private void evolutionMaladies() {
        for (Patient patient : patients) {
            patient.subirMaladie();
        }
    }
    
    

}
