/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jeumaladie;


/**
 * Représente un médicament
 * @author remi.watrigant
 */
public class Medicament {
    
    /**
     * Ici on fait un enum pour le type de médicament, 
     * cela permet de restreindre les valeurs possibles
     */
    public enum Type {
        
        
        ANTIBIOTIQUE("Antibiotique"),
        ANTIVIRAL("Antiviral"),
        ANTIPARASITE("Antiparasite");

        //on peut associer chaque élément avec un String, 
        //par exemple pour pouvoir l'afficher correctement
        private String nom = "";
        
        Type(String nom) {
            this.nom = nom;
        }        
        
        public String toString() {
            return nom;
        }       
    }

    /**
     * les attributs
     */
    private String nom;
    public String getNom() {
		return nom;
		
		
	}

    /**
     * 
     * @param nom
     */
	public void setNom(String nom) {
		this.nom = nom;
	}

	private Type type;
    private String effet;
    private int efficacite;

    public void setEfficacite(int efficacite) {
    	if (efficacite < 0 || efficacite > 4) {
    		//message d'erreur
    		//lancer une exception
    	} else {
    		this.efficacite = efficacite;
    	}
	}

	/**
     * Constructeur
     * @param nom le nom du médicament
     * @param type le type du médicament
     * @param effet l'effet du médicament
     * @param efficaicte l'efficacité du médicament (de 1 à 4 : 1 : efficacité faible, 4 : grosse efficacité)
     */
    public Medicament(String nom, Type type, String effet, int efficaicte) {
        this.nom = nom;
        this.type = type;
        this.effet = effet;
        this.efficacite = efficacite;
    }
    
    /**
     * @return the type
     */
    public Type getType() {
        return type;
    }

    /**
     * @return the efficacite
     */
    public int getEfficacite() {
        return efficacite;
    }

    /**
     * affiche un médicament
     * @return 
     */
    public String toString() {
        return nom + " est un " + type + " sert à " + effet + " efficacité :" + efficacite;
    }
}
