/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jeumaladie;

/**
 * Classe Maladie
 * @author remi.watrigant
 */
public abstract class Maladie implements Cloneable {

    /**
     * les attributs d'une maladie
     */
    protected String nom;
    protected int force;
    protected int dangerosite;
    protected String symptome;

    /**
     * Constructeur par paramètres
     * @param nom nom de la maladie
     * @param force force de la maladie
     * @param dangerosite dangerosité de la maladie
     * @param symptome symptomes de la maladie
     */
    public Maladie(String nom, int force, int dangerosite, String symptome) {
        this.nom = nom;
        this.force = force;
        this.dangerosite = dangerosite;
        this.symptome = symptome;
    }
    
    /**
     * setter du nom
     * @param nom le nom
     */
    public void setNom(String nom) {
        this.nom = nom;
    }

    /**
     * getter du nom
     * @return le nom
     */
    public String getNom() {
        return nom;
    }
    
    
    /**
     * état de la maladie
     * @return vrai ssi la maladie est éradiquée
     */
    public boolean etat() {
        
        if (force > 0) {
            return false;
        } else {
            return true;
        }
    }
    
    
    /**
     * méthode abstraite qui fait évoluer la maladie
     * @return le nombre de point de vie à retirer au malade
     */
    public abstract int evolue();

    /**
     * applique un médicament à la maladie
     * @param med médicament à appliquer
     * @return vrai ssi la maladie est éradiquée
     */
    public abstract boolean traiter(Medicament med);

  
    
    /**
     * affiche les symptomes de la maladie
     * @return les symptomes
     */
    public String toString() {
        return symptome;
    }
    
    
    /**
     * permet de comparer deux maladies
     * @param other une autre maladie à comparer
     * @return vrai ssi même référence, ou référence différente mais même nom
     */
    @Override
    public boolean equals(Object other) {
        if (other == null) return false;
        if (this == other) return true;
        if ((other instanceof Maladie) == false) return false;
        Maladie otherMaladie = (Maladie)other;
        
        //puis les "vrais" tests de comparaison
        return nom.equals(otherMaladie.nom);        
    }
    
    
   
    /**
     * permet de cloner une maladie : copie en profondeur des attributs
     * @return une maladie clonée
     * @throws CloneNotSupportedException 
     */
    public Object clone() throws CloneNotSupportedException  {

		
		return (Maladie) super.clone();
		
   }

   
}
