/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jeumaladie;

/**
 * représente une bactérie
 * @author remi.watrigant
 */
public class Bacterie extends Maladie {

    /**
     * stade de la bacterie
     */
    private int stade;

    public Bacterie(String nom, int force, int dangerosite, String symptome, int stade) {
        //on appelle le constructeur de la classe mère (Maladie)
        super(nom, force, dangerosite, symptome);
        
        //puis on s'occupe de l'attribut spécifique à Bacterie
        this.stade = stade;
    }

 
    @Override
    public boolean traiter(Medicament med) {
        switch (stade) {
            case 1:
                if (med.getType().equals("Antibiotique")) {
                    force = 0;
                } else if (med.getType().equals("Antiviral")) {
                    force -= 10;
                }
                break;
            case 2:
                if (med.getType().equals("Antibiotique")) {
                    force -= 10;
                } else if (med.getType().equals("Antiviral")) {
                    force -= 3;
                }
                break;
            case 3:
                if (med.getType().equals("Antibiotique")) {
                    stade--;
                }
                break;
            case 4:
                if (med.getType().equals("Antibiotique")) {
                    force -= 5;
                }
                break;
        }
        return etat();
    }

    @Override
    public int evolue() {
        int pourcent = 0;
        double rand = Math.random();
        if (rand <= 0.5) {
            stade++;
        } else {
            force += 5;
        }

        switch (stade) {
            case 1:
                pourcent = 20;
                break;
            case 2:
                pourcent = 30;
                break;
            case 3:
                pourcent = 70;
                break;
            case 4:
                pourcent = 90;
                break;
        }
        pourcent = force * pourcent / 100;

        return pourcent;
    }
    
    /**
     * clone une bacterie (copie en profondeur de tous les attributs)
     * @return une nouvelle bacterie
     * @throws CloneNotSupportedException 
     *//*
    public Bacterie clone() throws CloneNotSupportedException {
    	System.out.println("hello world");
        //on appelle le clone de la superclasse (Maladie)
        Bacterie clonedObj = (Bacterie)super.clone();
        
        //puis on copie en profondeur les autres attributs
        clonedObj.stade = stade;
        return clonedObj;
    }*/
}
