#define j1900 2415020.5
#define SMALL_TIME 1e-10
void   sec85_to_gregorian();
void   julian_to_gregorian();
void   mjd_to_gregorian();
void   yyddd_to_gregorian();
double gregorian_to_julian();
double gregorian_to_mjd();
double gregorian_to_sec85();
double julian_to_mjd();
double julian_to_sec85();
double mjd_to_julian();
double mjd_to_sec85();
double sec85_to_julian();
double sec85_to_julian();
double yyddd_to_sec85();

static int mth[2][12] = {{0,31,59,90,120,151,181,212,243,273,304,334},
			{0,31,60,91,121,152,182,213,244,274,305,335}};

static char *months[] = {"January", "February", "March", "April",
		"May", "June", "July", "August", "September",
		"October", "November", "December"};

static char *short_months[] = {"Jan","Feb","Mar","Apr","May","Jun",
			       "Jul","Aug","Sep","Oct","Nov","Dec"};


static char *days[] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

typedef struct {
	double second;
	double julian;
	double decimal_day;
	double mjd;
	double j2000;
	double sec85;
	double date;
	char monthname[10];
	char smonth[4];
	char weekday[10];
	char ampm[3];
	char adbc[3];
	int year;
	int month;
	int day;
	int hour;
	int minute;
	int doy;
	int gweek[2];
} utc_time;

utc_time time_from_gregorian(int, int, int, int, int, double);
utc_time time_from_doy_gregorian(int, int, int, int, double);
utc_time time_from_julian(double);
utc_time time_from_mjd(double);
utc_time time_from_sec85(double);
utc_time time_from_yyddd(double);
utc_time time_from_date(double);

utc_time thisDecade(utc_time time);
utc_time thisYear(utc_time time);
utc_time thisMonth(utc_time time);
utc_time thisDay(utc_time time);
utc_time thisHour(utc_time time);
utc_time thisMinute(utc_time time);
utc_time thisSecond(utc_time time);
utc_time thisWeek(utc_time time);

utc_time nextDecade(utc_time time);
utc_time nextYear(utc_time time);
utc_time nextMonth(utc_time time);
utc_time nextWeek(utc_time time);
utc_time nextDay(utc_time time);
utc_time nextHour(utc_time time);
utc_time nextMinute(utc_time time);
utc_time nextSecond(utc_time time);

utc_time lastYear(utc_time time);
utc_time lastMonth(utc_time time);
utc_time lastWeek(utc_time time);
utc_time lastDay(utc_time time);
utc_time lastHour(utc_time time);
utc_time lastMinute(utc_time time);
utc_time lastSecond(utc_time time);

utc_time today(utc_time time);
utc_time tomorrow(utc_time time);
utc_time yesterday(utc_time time);

utc_time addYears(utc_time time, int years);
utc_time addMonths(utc_time time, int months);
utc_time addWeeks(utc_time time, int weeks);
utc_time addDays(utc_time time, int days);
utc_time addHours(utc_time time, int hours);
