#include "timeseries.h"
                                                                                                                                                  
double whittle_MLE(double *P, double *Pfull, int n_psd, double *r, int end_flag) {

int i, j, k;

double c1, c2, scale, mle;
double N;

c1 = c2 = 0.0;

for (j = 0; j < n_psd; j++) {
	c1 += log(Pfull[j]);
	c2 += P[j]/Pfull[j];
} 

N = (double) n_psd;

scale = sqrt(c2 / N);

mle = -1.0 * (N * log(c2 / N) + c1 + N);

r[0] = scale;

return(mle);

}
