#include "timeseries.h"

void psd_wrapper(noise_model *nm, int n_models, time_series ts, data_kernel dk, options op, double *P, double *f, int n_psd) {

	int i, j, k, l, m;
	int sm, wm;

	/***********************************************************************************/
	/* We wont bother with all the different variations we saw in mle_wrapper because  */
	/* this is so much faster we might as well just do it the simple way with an inner */
	/* and outer simplex                                                               */
	/***********************************************************************************/

	for (i = 0, j = 0; j < n_models; j++) {
		for (k = 0; k < nm[j].n_pvec; k++) i += (nm[j].pvec_flag[k] == 0);
	}

	if (i == 0) { /* model parameters are fixed */
		whittle_inner_simplex(P, f, n_psd, ts.fs, dk, nm, n_models, op, 1);
	} else {
		whittle_outer_simplex(P, f, n_psd, ts, dk, nm, n_models, op);
	}
}
