#include "timeseries.h"

void mle_wrapper(noise_model *nm, int n_models, time_series ts, data_kernel dk, options op) {

	int i, j, k, l, m;
	int sm, wm;

	switch(n_models) {
                case 1:
			if (nm[0].model == 'w') {
				white_only(ts, dk, nm[0], op, 1);
			} else {

				for (i = 0, j = 0; j < nm[0].n_pvec; j++) i += (nm[0].pvec_flag[j] == 0);
				if (i == 0) { /* model parameters are fixed */
					color_only(ts, dk, nm[0], op, 1); 
				} else if (i == 1) { 
					brent_color_only(ts, dk, nm[0], op);
				} else {
					simplex_color_only(ts, dk, nm[0], op, i); 
				}	
			}
			break;
                case 2:
			/* First we have the case that one model is white noise */
			if (nm[0].model == 'w' || nm[1].model == 'w') {

				k = (nm[0].model == 'w' ? 1 : 0);

				for (i = 0, j = 0; j < nm[k].n_pvec; j++) i += (nm[k].pvec_flag[j] == 0);

				if (i == 0) brent_color_white(ts,dk,nm,2,op,1);
				else general_outer_simplex(ts, dk, nm, n_models, op);
				
			} else {
				for (i = 0, j = 0; j < n_models; j++) {
					for (k = 0; k < nm[j].n_pvec; k++) i += (nm[j].pvec_flag[k] == 0);
				}

				if (i == 0) { /* model parameters are fixed */
					general_inner_simplex(ts, dk, nm, n_models, op, 1);
				} else {
					general_outer_simplex(ts, dk, nm, n_models, op);
				}
			}
                        break;
                default: 
			for (i = 0, j = 0; j < n_models; j++) {
				for (k = 0; k < nm[j].n_pvec; k++) i += (nm[j].pvec_flag[k] == 0);
			}

			if (i == 0) { /* model parameters are fixed */
				general_inner_simplex(ts, dk, nm, n_models, op, 1);
			} else {
				general_outer_simplex(ts, dk, nm, n_models, op);
			}
			break; 
        }

}
