#include "timeseries.h"

double exact_radius(int nrow, double *Eig_values, double *Eig_vectors, double *residual, double angle, double *radius) {

int i, j, k;

double a, b, c, d, out, alpha, beta;
double ta2, sa2, ca2, slv, r;

double *temp, *work1, *work2, *work3;

alpha = 1.0;
beta  = 0.0;

work1 = (double *) calloc( (size_t) (nrow * nrow), sizeof(double) );
work2 = (double *) calloc( (size_t) nrow,          sizeof(double) );
work3 = (double *) calloc( (size_t) nrow,          sizeof(double) );
temp  = (double *) calloc( (size_t) nrow,          sizeof(double) );

ta2 = tan(angle) * tan(angle);
sa2 = sin(angle) * sin(angle);
ca2 = cos(angle) * cos(angle);

for (slv = 0.0, j = 0; j < nrow; j++) {
	temp[j] = 1.0 / (ta2 +  Eig_values[j]);
	slv += log(sa2 + ca2 * Eig_values[j]);
}

for (j = 0; j < nrow; j++) {
	for (k = 0; k < nrow; k++) {
		work1[j + k * nrow] = temp[j] * Eig_vectors[k + j * nrow];
	}
}

i = 1;
dgemm_("T","N",&i,&nrow,&nrow,&alpha,residual,&nrow,Eig_vectors,&nrow,&beta,work2,&i);
dgemm_("N","N",&i,&nrow,&nrow,&alpha,work2,&i,work1,&nrow,&beta,work3,&i);

d = 0.0;
for (j = 0; j < nrow; j++) d += work3[j] * residual[j];

r = sqrt(d / (double) nrow / ca2);

a = -0.5 * (double) nrow * log(2.0 * M_PI);
b = -0.5 * (slv + 2 * (double) nrow * log(r) );
c = -0.5 * d / r / r / ca2;

out = a + b + c;

free(temp);
free(work1);
free(work2);
free(work3);

radius[0] = r;

return(out);
}
