#!/bin/csh
# convert time series downloaded from Nevada website to neu readable by tserie and cat
# read file called stat_nevada.enu
if ($#argv < 1) then
  echo ""
  echo 'USAGE: nevadaenu2neu.csh station_name'
  echo 'read files downloaded from Nevada web site stat_nevada.enu'
endif
set stat = $1
set station = `echo $1 | awk '{print toupper($0)}'`
echo $station
set out = $station.neu

awk '{if (NR>1) print $3, $11, $9, $13, $16, $15, $17, $2, $1}' $stat"_nevada.enu" > $out

#write header
echo "#"     $station  Time Series > titi
set test = `grep $station list_coord.txt | wc -l`
if ($test > 0) then
grep $station list_coord.txt | awk '{print "# X(m)", $2}' >> titi
grep $station list_coord.txt | awk '{print "# Y(m)", $3}' >> titi
grep $station list_coord.txt | awk '{print "# Z(m)", $4}' >> titi
else
echo NO COORDINDATE FOR THIS STATION
endif


if (-e ./time-series) then
echo directory existing
else
echo creating directory
mkdir time-series
mkdir time-series/raw
endif

cat titi $out > ./time-series/raw/$out
rm -f $out titi
