#include <math.h>
#include <stdio.h>
#include "utc_time.h"

void yyddd_to_gregorian(year,month,day,hour,minute,second,yyddd)
int *year, *month, *day, *hour, *minute;
double *second, yyddd;
{

int yy, doy, leap, m, days;
int daytab[13] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

double s, decimal_day;

yy = (int)floor(yyddd / 1000.0);

doy = (int)floor(yyddd - (double)yy*1000.0);
decimal_day = yyddd - yy * 1000 - doy;

if (yy < 100 && yy >= 0) {
	yy = ( yy < 10 ? yy + 2000 : yy + 1900);
}

leap = yy%4 == 0 && yy%100 != 0 || yy%400 == 0;
if (leap) daytab[2] = 29;

m = 1;
days = 0;
while (days + daytab[m] < doy) {
	days += daytab[m];
	m++;
}

(*year) = yy;
(*month) = m;
(*day) = doy - days;

s = decimal_day * 86400.0;
(*second) = fmod(s,60.0);
s -= (*second);
(*minute) = (int)s/60%60;
(*hour) = (int)s/60/60;

}
