#include "timeseries.h"

void print_model(noise_model nm, options op, double sf) {

int j, id;

fprintf(op.fpout, "+%s ", comp_names[nm.c_id]);

switch (nm.model) {
	case 'p':
		fprintf(op.fpout, " POWER LAW NOISE\n");
		break;
	case 'f':
		fprintf(op.fpout, " FIRST ORDER GAUSS MARKOV NOISE\n");
		break;
	case 'b':
		fprintf(op.fpout, " BAND PASS NOISE\n");
		break;
	case 'w':
		fprintf(op.fpout, " WHITE NOISE\n");
		break;
	case 'v':
		fprintf(op.fpout, " VARIABLE WHITE NOISE\n");
		break;
	case 's':
		fprintf(op.fpout, " CHANGE POINT WHITE NOISE\n");
		break;
	case 't':
		fprintf(op.fpout, " TIME VARIABLE WHITE NOISE\n");
		break;
	case 'g':
		fprintf(op.fpout, " GENERALISED GAUSS MARKOV NOISE\n");
		break;
}

		
for (j = 0; j < nm.n_pvec; j++) {
	fprintf(op.fpout, "+%s ", comp_names[nm.c_id]);

	fprintf(op.fpout, " %s ", par_names[nm.names[j*2]]);
	if (nm.pvec_flag[j] == 0) {
		fprintf(op.fpout, "     IS FREE\n");
	} else if (nm.pvec_flag[j] == 1) {
		fprintf(op.fpout, " %11.4f\n", nm.pvec[j]);
	} else {
		fprintf(op.fpout, " %11.4f +- %11.4f\n", nm.pvec[j], nm.pvec_sigma[j] );
	}
}

fprintf(op.fpout, "+%s ", comp_names[nm.c_id]); 
fprintf(op.fpout, " %s ", par_names[nm.sigma_id]);

if (nm.model == 'v') {
	if (nm.sigma_flag[0] == 0)      fprintf(op.fpout, "     IS FREE\n");
	else if (nm.sigma_flag[0] == 1) fprintf(op.fpout, " %11.4f\n", nm.sigma[0]);
	else                             fprintf(op.fpout, " %11.4f +- %11.4f\n", nm.sigma[0], nm.dsigma[0]);
} else {
	if (nm.sigma_flag[0] == 0)      fprintf(op.fpout, "     IS FREE\n");
	else if (nm.sigma_flag[0] == 1) fprintf(op.fpout, " %11.4f\n", nm.sigma[0]*sf);
	else                             fprintf(op.fpout, " %11.4f +- %11.4f\n", nm.sigma[0]*sf, nm.dsigma[0]*sf);
}
fprintf(op.fpout, "\n");


}
