#include "timeseries.h"

noise_model decode_model_string(char *args, int cf) {

int j, k, i, i1, i2, flag, series;

double value;

noise_model nm;

if (args[0] == 'p' && args[1] == 'l') {
	nm.model       = 'p';
	nm.n_pvec      =  1;
	nm.names = (int *) calloc((size_t) (nm.n_pvec*2), sizeof(int));
	nm.names[0] = 10;
	nm.names[1] = 17;
	nm.sigma_id =  6; 

	nm.pvec         = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_sigma   = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_flag    =    (int *) calloc((size_t) nm.n_pvec,    sizeof(int));

	for (j = 0; j < nm.n_pvec; j++) {
		nm.pvec[j]       = 0.0 / 0.0;
		nm.pvec_flag[j]  = 0;
		nm.pvec_sigma[j] = 0.0 / 0.0;
	}

} else if (args[0] == 'g' && args[1] == 'm') {
	nm.model       = 'f';
	nm.n_pvec      =  1;

	nm.names = (int *) calloc((size_t) (nm.n_pvec*2), sizeof(int));
	nm.names[0] = 8;
	nm.names[1] = 18;
	nm.sigma_id =  7;

	nm.pvec         = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_sigma   = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_flag    =    (int *) calloc((size_t) nm.n_pvec,    sizeof(int));

	for (j = 0; j < nm.n_pvec; j++) {
		nm.pvec[j]       = 0.0 / 0.0;
		nm.pvec_flag[j]  = 0;
		nm.pvec_sigma[j] = 0.0 / 0.0;
	}

} else if (args[0] == 'b' && args[1] == 'p') {
	nm.model       = 'b';
	nm.n_pvec      =  3;

	nm.names = (int *) calloc((size_t) (nm.n_pvec*2), sizeof(int));
	nm.names[0] = 11;
	nm.names[1] = 19;
	nm.names[2] = 12;
	nm.names[3] = 20;
	nm.names[4] = 13;
	nm.names[5] = 21;
	nm.sigma_id =  9;

	nm.pvec         = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_sigma   = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_flag    =    (int *) calloc((size_t) nm.n_pvec,    sizeof(int));

	for (j = 0; j < nm.n_pvec; j++) {
		nm.pvec[j]       = 0.0 / 0.0;
		nm.pvec_flag[j]  = 0;
		nm.pvec_sigma[j] = 0.0 / 0.0;
	}

} else if (args[0] == 'w' && args[1] == 'h') {

	nm.model      = 'w';
	nm.n_pvec     =  0;
	nm.sigma_id   =  5;

} else if (args[0] == 'v' && args[1] == 'w') {

	nm.model      = 'v';
	nm.n_pvec     =  0;
	nm.sigma_id   = 14;

} else if (args[0] == 's' && args[1] == 'w') {

	nm.model      = 's';
	nm.n_pvec     =  2;

	nm.names = (int *) calloc((size_t) (nm.n_pvec*2), sizeof(int));
	nm.names[0] = 15;
	nm.names[1] = 23;
	nm.names[2] = 26;
	nm.names[3] = 27;
	nm.sigma_id =  5;

	nm.pvec         = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_sigma   = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_flag    =    (int *) calloc((size_t) nm.n_pvec,    sizeof(int));

	for (j = 0; j < nm.n_pvec; j++) {
		nm.pvec[j]       = 0.0 / 0.0;
		nm.pvec_flag[j]  = 0;
		nm.pvec_sigma[j] = 0.0 / 0.0;
	}
} else if (args[0] == 't' && args[1] == 'w') {

	nm.model      = 't';
	nm.n_pvec     =  1;

	nm.names = (int *) calloc((size_t) (nm.n_pvec*2), sizeof(int));
	nm.names[0] = 24;
	nm.names[1] = 25;
	nm.sigma_id =  5;

	nm.pvec         = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_sigma   = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_flag    =    (int *) calloc((size_t) nm.n_pvec,    sizeof(int));

	for (j = 0; j < nm.n_pvec; j++) {
		nm.pvec[j]       = 0.0 / 0.0;
		nm.pvec_flag[j]  = 0;
		nm.pvec_sigma[j] = 0.0 / 0.0;
	}
	
} else if (args[0] == 'g' && args[1] == 'g') {

	nm.model = 'g';
	nm.n_pvec = 2;

	nm.names = (int *) calloc((size_t) (nm.n_pvec*2), sizeof(int));
	nm.names[0] = 8;
	nm.names[1] = 18;
	nm.names[2] = 10 ;
	nm.names[3] = 17;
	nm.sigma_id = 16;

	nm.pvec         = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_sigma   = (double *) calloc((size_t) nm.n_pvec, sizeof(double));
	nm.pvec_flag    =    (int *) calloc((size_t) nm.n_pvec,    sizeof(int));

	for (j = 0; j < nm.n_pvec; j++) {
		nm.pvec[j]       = 0.0 / 0.0;
		nm.pvec_flag[j]  = 0;
		nm.pvec_sigma[j] = 0.0 / 0.0;
	}

} else {
	fprintf(stderr, " Unknown model type : %c%c\n", args[0], args[1]);
	exit(EXIT_FAILURE);
}

nm.sigma      = (double *) calloc((size_t) 1, sizeof(double));
nm.dsigma     = (double *) calloc((size_t) 1, sizeof(double));
nm.sigma_flag =    (int *) calloc((size_t) 1, sizeof(int));

nm.sigma[0]      = (0.0 / 0.0);
nm.dsigma[0]     = (0.0 / 0.0);
nm.sigma_flag[0] = 0;
nm.c_id          = -1;

series = 0;
i1 = 3;
while (args[i1]) {
	if (args[i1] == '/') {
		if (++series > cf) {
			break;
		}
		i1++;
	}
	flag = '*';
	if (isalpha((int)args[i1])) {
		flag = args[i1];
		i1++;
	}

	i2 = i1;
	while (args[i2] && strchr ("bkshlpt/", (int)args[i2]) == NULL) i2++;
	i = i2+1;
	if (flag != ' ') {
		value = atof(&args[i1]);
	} 
	/* Power-Law Noise */
	if (flag == 'k' && nm.model == 'p') {
		nm.pvec[0] = value;
		nm.pvec_flag[0] = 1;
	}
	/* First-Order Gauss Markov */
	if (flag == 'b' && nm.model == 'f') {
		nm.pvec[0] = value;
		nm.pvec_flag[0] = 1;
	}
	/* Band-Pass */
	if (flag == 'c' && nm.model == 'b') {
		nm.pvec[0] = value;
		nm.pvec_flag[0] = 1;
	}
	if (flag == 'w' && nm.model == 'b') {
		nm.pvec[1] = value;
		nm.pvec_flag[1] = 1;
	}
	if (flag == 'p' && nm.model == 'b') {
		nm.pvec[2] = value;
		nm.pvec_flag[2] = 1;
	}
	/* Change Point White Noise */
	if (flag == 'b' && nm.model == 's') {
		nm.pvec[0] = value;
		nm.pvec_flag[0] = 1;
	}
	if (flag == 'e' && nm.model == 's') {
		nm.pvec[1] = value;
		nm.pvec_flag[1] = 1;
	}
	/* Generalised Gauss Markov */
	if (flag == 'k' && nm.model == 'g') {
		nm.pvec[1] = value;
		nm.pvec_flag[1] = 1;
	}
	if (flag == 'b' && nm.model == 'g') {
		nm.pvec[0] = value;
		nm.pvec_flag[0] = 1;
	}
	if (flag == 'a' && nm.model == 't') {
		nm.pvec[0] = value;
		nm.pvec_flag[0] = 1;
	}
	if (flag == 's') {
		nm.sigma[0]      = value;
		nm.dsigma[0]     = 0.0;
		nm.sigma_flag[0] = 1;
	}
	i1 = i2;
}

return(nm);

}
