#include "timeseries.h"
                                                                                                                        
double color_white_mle_res(double *par, int n_params, int n_lpar, int n_data, double *d, double *A, double *Eig_values, double *Eig_vectors){
                                                                                                                        
        int i, j;
                                                                                                                        
        double out, alpha, beta;
        double *residual, *params, *fit;
                                                                                                                        
        alpha = 1.0;
        beta  = 0.0;
                                                                                                                        
        i = n_params - n_lpar;
        residual = (double *) calloc( (size_t) n_data,            sizeof(double) );
        fit      = (double *) calloc( (size_t) n_lpar,            sizeof(double) );
        params   = (double *) calloc( (size_t) i,                 sizeof(double) );
                                                                                                                        
        /***********************/
        /* Get residuals first */
        /***********************/
                                                                                                                        
        for (j = 0; j < n_lpar; j++) fit[j]    = par[j];
        for (j = 0; j < i; j++)      params[j] = par[j+n_lpar];
                                                                                                                        
        i = 1;
        dgemm_("N","N",&n_data,&i,&n_lpar,&alpha,A,&n_data,fit,&n_lpar,&beta,residual,&n_data);
        for (j = 0; j < n_data; j++) residual[j] = d[j] - residual[j];
                                                                                                                        
        out = color_white_mle(params, n_data, Eig_values, Eig_vectors, residual);
                                                                                                                        
        free(residual);
        free(fit);
        free(params);
                                                                                                                        
        return(out);
}

