/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.session;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.annotation.RemoteBindings;
import org.jboss.ejb3.annotation.impl.LocalBindingImpl;
import org.jboss.ejb3.annotation.impl.RemoteBindingImpl;
import org.jboss.ejb3.annotation.impl.RemoteBindingsImpl;
import org.jboss.ejb3.proxy.ProxyFactory;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyDeployer {
    private static final Logger log = Logger.getLogger(ProxyDeployer.class);
    private SessionContainer container;
    private Map<Object, ProxyFactory> proxyFactories = new HashMap<Object, ProxyFactory>();
    private RemoteBindings remoteBindings;
    private LocalBinding localBinding;

    public ProxyDeployer(SessionContainer container) {
        assert (container != null) : "container is null";
        this.container = container;
    }

    private static <T> Constructor<T> getConstructor(Class<T> cls, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        try {
            return cls.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] constructors;
            log.warn((Object)("Class " + cls + " does not have a proper constructor with parameters " + Arrays.toString(parameterTypes) + ", will try to find one"));
            for (Constructor<?> constructor : constructors = cls.getConstructors()) {
                int i;
                if (parameterTypes.length != constructor.getParameterTypes().length) continue;
                for (i = 0; i < parameterTypes.length && constructor.getParameterTypes()[i].isAssignableFrom(parameterTypes[i]); ++i) {
                }
                if (i != parameterTypes.length) continue;
                return constructor;
            }
            throw e;
        }
    }

    public Map<Object, ProxyFactory> getProxyFactories() {
        return this.proxyFactories;
    }

    public ProxyFactory getProxyFactory(Object key) {
        return this.getProxyFactories().get(key);
    }

    public void start() throws Exception {
        if (this.remoteBindings != null) {
            RemoteBinding[] list;
            for (RemoteBinding binding : list = this.remoteBindings.value()) {
                RemoteProxyFactory factory;
                assert (binding.jndiBinding().length() != 0) : "jndiBinding not set on binding " + binding;
                String factoryImplementationRegistryKey = binding.factory();
                if (factoryImplementationRegistryKey.equals("RemoteProxyFactory")) {
                    factory = this.container.getProxyFactory(binding);
                } else {
                    Class<? extends RemoteProxyFactory> remoteFactoryClass = this.container.getDeployment().getRemoteProxyFactoryRegistry().getProxyFactoryClass(binding.factory());
                    Constructor<? extends RemoteProxyFactory> constructor = ProxyDeployer.getConstructor(remoteFactoryClass, this.container.getClass(), RemoteBinding.class);
                    factory = constructor.newInstance(this.container, binding);
                }
                factory.start();
                this.proxyFactories.put(binding, factory);
            }
        }
        if (this.localBinding != null) {
            ProxyFactory factory = this.container.getProxyFactory(this.localBinding);
            factory.start();
            this.proxyFactories.put(this.localBinding, factory);
        }
    }

    protected boolean hasJNDIBinding(String jndiName) {
        assert (jndiName != null) : "jndiName is null";
        if (this.localBinding != null && this.localBinding.jndiBinding().equals(jndiName)) {
            return true;
        }
        if (this.remoteBindings != null) {
            for (RemoteBinding binding : this.remoteBindings.value()) {
                if (!binding.jndiBinding().equals(jndiName)) continue;
                return true;
            }
        }
        return false;
    }

    public void initializeLocalBindingMetadata() {
        this.localBinding = this.container.getAnnotation(LocalBinding.class);
        if (this.localBinding == null && ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(this.container).length > 0) {
            this.localBinding = new LocalBindingImpl(ProxyFactoryHelper.getLocalJndiName(this.container));
            this.container.getAnnotations().addClassAnnotation(LocalBinding.class, (Object)this.localBinding);
        }
    }

    private RemoteBinding initializeRemoteBinding(RemoteBinding binding) {
        if (binding.jndiBinding().length() == 0) {
            return new RemoteBindingImpl(ProxyFactoryHelper.getDefaultRemoteBusinessJndiName(this.container), binding.interceptorStack(), binding.clientBindUrl(), binding.factory());
        }
        return binding;
    }

    public void initializeRemoteBindingMetadata() {
        this.remoteBindings = this.container.getAnnotation(RemoteBindings.class);
        if (this.remoteBindings == null) {
            RemoteBinding binding = this.container.getAnnotation(RemoteBinding.class);
            if (binding == null) {
                log.debug((Object)("no declared remote bindings for : " + this.container.getEjbName()));
                if (ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this.container).length > 0) {
                    log.debug((Object)("there is remote interfaces for " + this.container.getEjbName()));
                    String jndiName = ProxyFactoryHelper.getDefaultRemoteBusinessJndiName(this.container);
                    log.debug((Object)("default remote binding has jndiName of " + jndiName));
                    String uri = "";
                    RemoteBinding[] list = new RemoteBinding[]{new RemoteBindingImpl(jndiName, "", uri, "RemoteProxyFactory")};
                    this.remoteBindings = new RemoteBindingsImpl(list);
                    this.container.getAnnotations().addClassAnnotation(RemoteBindings.class, (Object)this.remoteBindings);
                }
            } else {
                RemoteBinding[] list = new RemoteBinding[]{this.initializeRemoteBinding(binding)};
                this.remoteBindings = new RemoteBindingsImpl(list);
                this.container.getAnnotations().addClassAnnotation(RemoteBindings.class, (Object)this.remoteBindings);
            }
        } else {
            ArrayList<RemoteBinding> list = new ArrayList<RemoteBinding>();
            for (RemoteBinding binding : this.remoteBindings.value()) {
                list.add(this.initializeRemoteBinding(binding));
            }
            this.remoteBindings = new RemoteBindingsImpl(list);
            this.container.getAnnotations().addClassAnnotation(RemoteBindings.class, (Object)this.remoteBindings);
        }
    }

    public void stop() throws Exception {
        Collection<ProxyFactory> proxyFactories = this.getProxyFactories().values();
        for (ProxyFactory factory : proxyFactories) {
            factory.stop();
        }
    }
}

