/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.stateless;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ejb3.SpecificationInterfaceType;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactory;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactoryRegistry;
import org.jboss.ejb3.proxy.factory.stateless.BaseStatelessRemoteProxyFactory;
import org.jboss.ejb3.proxy.handler.stateless.StatelessClusteredInvocationHandler;
import org.jboss.ejb3.remoting.LoadBalancePolicyNotRegisteredException;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.client.loadbalance.RandomRobin;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.HAPartitionLocator;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessClusterProxyFactory
extends BaseStatelessRemoteProxyFactory
implements RemoteProxyFactory,
DistributedReplicantManager.ReplicantListener {
    private static final Logger log = Logger.getLogger(StatelessClusterProxyFactory.class);
    private static final String STACK_NAME_CLUSTERED_STATELESS_SESSION_CLIENT_INTERCEPTORS = "ClusteredStatelessSessionClientInterceptors";
    private RemoteBinding binding;
    private Clustered clustered;
    private InvokerLocator locator;
    private DistributedReplicantManager drm;
    private HATarget hatarget;
    private String proxyFamilyName;
    private LoadBalancePolicy lbPolicy;
    private FamilyWrapper wrapper;
    private Object proxy;

    public StatelessClusterProxyFactory(SessionSpecContainer container, RemoteBinding binding, Clustered clustered) {
        super(container, binding);
        assert (clustered != null) : "clustered is null";
        this.binding = binding;
        this.clustered = clustered;
    }

    @Override
    public void start() throws Exception {
        String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
        this.locator = new InvokerLocator(clientBindUrl);
        StatelessContainer container = (StatelessContainer)this.getContainer();
        String partitionName = container.getPartitionName();
        this.proxyFamilyName = container.getDeploymentQualifiedName() + this.locator.getProtocol() + partitionName;
        HAPartition partition = HAPartitionLocator.getHAPartitionLocator().getHAPartition(partitionName, container.getInitialContextProperties());
        this.drm = partition.getDistributedReplicantManager();
        this.hatarget = new HATarget(partition, this.proxyFamilyName, (Serializable)this.locator, 2);
        ClusteringTargetsRepository.initTarget((String)this.proxyFamilyName, (List)this.hatarget.getReplicants());
        container.getClusterFamilies().put(this.proxyFamilyName, this.hatarget);
        if (this.clustered.loadBalancePolicy() == null || this.clustered.loadBalancePolicy().equals("LoadBalancePolicy")) {
            this.lbPolicy = new RandomRobin();
        } else {
            String policyClass = this.clustered.loadBalancePolicy();
            try {
                RemoteProxyFactoryRegistry registry = container.getDeployment().getRemoteProxyFactoryRegistry();
                Class<LoadBalancePolicy> policy = registry.getLoadBalancePolicy(policyClass);
                policyClass = policy.getName();
            }
            catch (LoadBalancePolicyNotRegisteredException e) {
                // empty catch block
            }
            this.lbPolicy = (LoadBalancePolicy)Thread.currentThread().getContextClassLoader().loadClass(policyClass).newInstance();
        }
        this.wrapper = new FamilyWrapper(this.proxyFamilyName, (List)this.hatarget.getReplicants());
        this.drm.registerListener(this.proxyFamilyName, (DistributedReplicantManager.ReplicantListener)this);
        super.start();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.proxy = null;
        this.hatarget.destroy();
        this.drm.unregisterListener(this.proxyFamilyName, (DistributedReplicantManager.ReplicantListener)this);
        ((StatelessContainer)this.getContainer()).getClusterFamilies().remove(this.proxyFamilyName);
    }

    @Override
    public Object createProxyBusiness(String businessInterfaceClassName) {
        String stackName = this.getStackNameInterceptors();
        if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
            stackName = this.binding.interceptorStack();
        }
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        String partitionName = ((StatelessContainer)this.getContainer()).getPartitionName();
        this.proxy = this.constructProxy(new StatelessClusteredInvocationHandler(this.getContainer(), stack.createInterceptors(this.getContainer().getAdvisor(), null), this.wrapper, this.lbPolicy, partitionName, this.getLocator(), businessInterfaceClassName), SpecificationInterfaceType.EJB30_BUSINESS);
        return this.proxy;
    }

    @Override
    protected boolean bindHomeAndBusinessTogether() {
        return false;
    }

    public synchronized void replicantsChanged(String key, List newReplicants, int newReplicantsViewId, boolean merge) {
        try {
            ArrayList targets = new ArrayList(newReplicants);
            this.wrapper.get().updateClusterInfo(targets, (long)newReplicantsViewId);
            if (this.proxy != null) {
                this.bindProxy(this.proxy);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    @Override
    protected Class<?> getHomeType() {
        return null;
    }

    @Override
    String getStackNameInterceptors() {
        return STACK_NAME_CLUSTERED_STATELESS_SESSION_CLIENT_INTERCEPTORS;
    }
}

