/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.asynch.AsynchMixin;
import org.jboss.aspects.asynch.AsynchProvider;
import org.jboss.aspects.asynch.AsynchProxyInterceptor;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb3.proxy.JBossProxy;
import org.jboss.ejb3.proxy.handler.ProxyInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyUtils {
    public static final Class<AsynchProvider> ASYNCH_PROVIDER_CLASS = AsynchProvider.class;
    public static final long GET_ASYNCHRONOUS;
    public static final long TO_STRING;
    public static final long EQUALS;
    public static final long HASHCODE;
    public static final Method GET_PRIMARY_KEY;
    public static final Method GET_HANDLE;
    public static final Method GET_EJB_HOME;
    public static final Method IS_IDENTICAL;
    public static final Method GET_HOME_HANDLE;
    public static final Method GET_EJB_METADATA;
    public static final Method REMOVE;

    public static boolean isAsynchronous(Class<?>[] infs) {
        for (int i = 0; i < infs.length; ++i) {
            if (infs[i] != ASYNCH_PROVIDER_CLASS) continue;
            return true;
        }
        return false;
    }

    public static Class<?>[] addAsynchProviderInterface(Class<?>[] infs) {
        ArrayList interfaces = new ArrayList();
        for (int i = 0; i < infs.length; ++i) {
            if (infs[i] == ASYNCH_PROVIDER_CLASS) continue;
            interfaces.add(infs[i]);
        }
        interfaces.add(ASYNCH_PROVIDER_CLASS);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Interceptor[] addAsynchProxyInterceptor(AsynchMixin mixin, Interceptor[] interceptors) {
        AsynchProxyInterceptor interceptor = new AsynchProxyInterceptor((FutureHolder)mixin);
        Interceptor[] newInterceptors = null;
        newInterceptors = new Interceptor[interceptors.length + 1];
        newInterceptors[0] = interceptor;
        System.arraycopy(interceptors, 0, newInterceptors, 1, interceptors.length);
        return newInterceptors;
    }

    public static void addLocalAsynchronousInfo(MethodInvocation invocation, FutureHolder provider) {
        if (provider != null) {
            invocation.getMetaData().addMetaData((Object)"ASYNCH", (Object)"INVOKE_ASYNCH", (Object)"YES", PayloadKey.AS_IS);
            invocation.getMetaData().addMetaData((Object)"ASYNCH", (Object)"FUTURE_HOLDER", (Object)provider, PayloadKey.AS_IS);
        }
    }

    public static Object handleCallLocally(Object jbproxy, ProxyInvocationHandler ih, Method m, Object[] args) {
        long hash = MethodHashing.calculateHash((Method)m);
        return ProxyUtils.handleCallLocally(hash, jbproxy, ih, m, args);
    }

    public static Object handleCallLocally(long hash, Object jbproxy, ProxyInvocationHandler ih, Method m, Object[] args) {
        if (hash == GET_ASYNCHRONOUS) {
            return ih.getAsynchronousProxy((JBossProxy)jbproxy);
        }
        if (hash == TO_STRING) {
            return ((Object)ih).toString();
        }
        if (hash == HASHCODE) {
            return new Integer(((Object)ih).toString().hashCode());
        }
        if (hash == EQUALS) {
            return new Boolean(((Object)ih).toString().equals(args[0].toString()));
        }
        return null;
    }

    static {
        try {
            Class[] empty = new Class[]{};
            Method method = JBossProxy.class.getMethod("getAsynchronousProxy", empty);
            GET_ASYNCHRONOUS = MethodHashing.calculateHash((Method)method);
            TO_STRING = MethodHashing.calculateHash((Method)Object.class.getDeclaredMethod("toString", empty));
            EQUALS = MethodHashing.calculateHash((Method)Object.class.getDeclaredMethod("equals", Object.class));
            HASHCODE = MethodHashing.calculateHash((Method)Object.class.getDeclaredMethod("hashCode", empty));
            GET_PRIMARY_KEY = EJBObject.class.getMethod("getPrimaryKey", empty);
            GET_HANDLE = EJBObject.class.getMethod("getHandle", empty);
            GET_EJB_HOME = EJBObject.class.getMethod("getEJBHome", empty);
            IS_IDENTICAL = EJBObject.class.getMethod("isIdentical", EJBObject.class);
            REMOVE = EJBObject.class.getMethod("remove", empty);
            GET_HOME_HANDLE = EJBHome.class.getMethod("getHomeHandle", empty);
            GET_EJB_METADATA = EJBHome.class.getMethod("getEJBMetaData", empty);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

