/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.Local;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.jboss.aop.Domain;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.PayloadKey;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.annotation.Consumer;
import org.jboss.ejb3.annotation.DefaultActivationSpecs;
import org.jboss.ejb3.annotation.MessageProperties;
import org.jboss.ejb3.annotation.Producer;
import org.jboss.ejb3.annotation.Producers;
import org.jboss.ejb3.annotation.impl.MessagePropertiesImpl;
import org.jboss.ejb3.mdb.LocalProducerFactory;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.mdb.ProducerFactory;
import org.jboss.ejb3.mdb.RemoteProducerFactory;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossConsumerBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerContainer
extends MessagingContainer {
    private static final Logger log = Logger.getLogger(ConsumerContainer.class);
    protected Class messagingType = null;
    protected Method ON_MESSAGE;
    protected ArrayList<ProducerFactory> producers = new ArrayList();
    protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
    public static final String CONSUMER_MESSAGE = "CONSUMER_MESSAGE";

    public ConsumerContainer(String ejbName, Domain domain, ClassLoader cl, String beanClassName, Hashtable ctxProperties, Ejb3Deployment deployment, JBossConsumerBeanMetaData beanMetaData) throws ClassNotFoundException {
        super(ejbName, domain, cl, beanClassName, ctxProperties, deployment, (JBossEnterpriseBeanMetaData)beanMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResponse dynamicInvoke(Invocation invocation) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        EJBContainerInvocation newSi = null;
        this.pushEnc();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            MethodInvocation si = (MethodInvocation)invocation;
            MethodInfo info = this.getAdvisor().getMethodInfo(si.getMethodHash());
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call");
            }
            newSi = new EJBContainerInvocation(info);
            newSi.setArguments(si.getArguments());
            newSi.setMetaData(si.getMetaData());
            newSi.setAdvisor(this.getAdvisor());
            InvocationResponse response = new InvocationResponse(newSi.invokeNext());
            response.setContextInfo(newSi.getResponseContextInfo());
            InvocationResponse invocationResponse = response;
            return invocationResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            this.popEnc();
        }
    }

    protected Method getOnMessage() {
        if (this.ON_MESSAGE != null) {
            return this.ON_MESSAGE;
        }
        try {
            Class<Message> arg = Message.class;
            this.ON_MESSAGE = MessageListener.class.getMethod("onMessage", arg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
        return this.ON_MESSAGE;
    }

    @Override
    protected NamedMethodMetaData getTimeoutMethodMetaData() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object localInvoke(MethodInfo info, Object[] args) throws Throwable {
        if (info.getMethod().equals(this.getOnMessage())) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            this.pushEnc();
            try {
                Message message = (Message)args[0];
                MethodInvocation invocation = (MethodInvocation)((ObjectMessage)message).getObject();
                invocation.getMetaData().addMetaData((Object)CONSUMER_MESSAGE, (Object)CONSUMER_MESSAGE, (Object)message, PayloadKey.TRANSIENT);
                InvocationResponse invocationResponse = this.dynamicInvoke((Invocation)invocation);
                return invocationResponse;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
                this.popEnc();
            }
        }
        return super.localInvoke(info, args);
    }

    @Override
    public Class<MessageListener> getMessagingType() {
        return MessageListener.class;
    }

    @Override
    public MethodInfo getMethodInfo(Method method) {
        MethodInfo info = new MethodInfo();
        info.setAdvisor(this.getAdvisor());
        info.setAdvisedMethod(method);
        info.setUnadvisedMethod(method);
        return info;
    }

    @Override
    public Map<String, ActivationConfigPropertyMetaData> getActivationConfigProperties() {
        HashMap<String, ActivationConfigPropertyMetaData> result = new HashMap<String, ActivationConfigPropertyMetaData>();
        Consumer annotation = (Consumer)this.resolveAnnotation(Consumer.class);
        for (ActivationConfigProperty property : annotation.activationConfig()) {
            this.addActivationSpecProperty(result, property);
        }
        DefaultActivationSpecs defaultSpecsAnnotation = (DefaultActivationSpecs)this.resolveAnnotation(DefaultActivationSpecs.class);
        if (defaultSpecsAnnotation != null) {
            for (ActivationConfigProperty property : defaultSpecsAnnotation.value()) {
                this.addActivationSpecProperty(result, property);
            }
        }
        return result;
    }

    @Override
    protected List<Class<?>> resolveBusinessInterfaces() {
        Producer producer;
        Class<?>[] classInterfaces = this.getBeanClass().getInterfaces();
        if (classInterfaces.length == 0) {
            throw new RuntimeException("Bean class must implement at least one interface: " + this.getBeanClass().getName());
        }
        if (classInterfaces.length == 1) {
            ArrayList list = new ArrayList();
            list.add(classInterfaces[0]);
            return list;
        }
        ArrayList interfaces = new ArrayList();
        Producers producers = (Producers)this.resolveAnnotation(Producers.class);
        if (producers != null) {
            for (Producer producer2 : producers.value()) {
                interfaces.add(producer2.producer());
            }
        }
        if ((producer = (Producer)this.resolveAnnotation(Producer.class)) != null) {
            interfaces.add(producer.producer());
        }
        for (Class<?> implIf : this.getBeanClass().getInterfaces()) {
            if (implIf.getAnnotation(Producer.class) == null) continue;
            interfaces.add(implIf);
        }
        return interfaces;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.registerProducers();
    }

    protected void registerProducers() throws Exception {
        Destination dest = (Destination)this.getInitialContext().lookup(this.getDestination());
        MessageProperties props = (MessageProperties)this.resolveAnnotation(MessageProperties.class);
        if (props == null) {
            props = new MessagePropertiesImpl();
        }
        for (Class<?> producer : this.getBusinessInterfaces()) {
            log.debug((Object)("Producer: " + producer.getName()));
            ProducerFactory producerFactory = null;
            producerFactory = producer.isAnnotationPresent(Local.class) ? new LocalProducerFactory(this, (Class)producer, props, dest, this.getInitialContext(), this.initialContextProperties) : new RemoteProducerFactory(this, (Class)producer, props, dest, this.getInitialContext(), this.initialContextProperties);
            this.producers.add(producerFactory);
            producerFactory.start();
        }
    }

    protected void unregisterProducers() throws Exception {
        for (ProducerFactory factory : this.producers) {
            factory.stop();
        }
    }

    @Override
    protected void populateActivationSpec() {
        DefaultActivationSpecs defaultSpecs = (DefaultActivationSpecs)this.resolveAnnotation(DefaultActivationSpecs.class);
        if (defaultSpecs != null) {
            this.activationSpec.merge(defaultSpecs.value());
        }
        Consumer md = (Consumer)this.resolveAnnotation(Consumer.class);
        this.activationSpec.merge(md.activationConfig());
    }

    @Override
    public void stop() throws Exception {
        this.unregisterProducers();
        super.stop();
    }
}

