/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.jboss.ejb3.PersistenceUnitRegistry;
import org.jboss.ejb3.entity.HibernateSession;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionScopedEntityManager
implements EntityManager,
HibernateSession,
Externalizable {
    private static final long serialVersionUID = 4260828563883650376L;
    private static final Logger log = Logger.getLogger(TransactionScopedEntityManager.class);
    private transient ManagedEntityManagerFactory factory;

    @Override
    public Session getHibernateSession() {
        EntityManager em = this.factory.getTransactionScopedEntityManager();
        if (em instanceof HibernateEntityManager) {
            return ((HibernateEntityManager)em).getSession();
        }
        throw new RuntimeException("ILLEGAL ACTION:  Not a Hibernate persistence provider");
    }

    public TransactionScopedEntityManager(ManagedEntityManagerFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory must not be null");
        }
        this.factory = factory;
    }

    public TransactionScopedEntityManager() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.factory.getKernelName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String kernelName = in.readUTF();
        PersistenceUnitDeployment deployment = PersistenceUnitRegistry.getPersistenceUnit(kernelName);
        if (deployment == null) {
            throw new IOException("Unable to find persistence unit in registry: " + kernelName);
        }
        this.factory = deployment.getManagedFactory();
    }

    public Object getDelegate() {
        return this.getEntityManager().getDelegate();
    }

    public void joinTransaction() {
        this.factory.verifyInTx();
        this.getEntityManager().joinTransaction();
    }

    public void clear() {
        this.getEntityManager().clear();
    }

    public FlushModeType getFlushMode() {
        return this.getEntityManager().getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.factory.verifyInTx();
        this.getEntityManager().lock(entity, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        EntityManager em = this.getEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        try {
            Object object = em.getReference(entityClass, primaryKey);
            return (T)object;
        }
        finally {
            if (!this.factory.isInTx()) {
                em.clear();
            }
        }
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.getEntityManager().setFlushMode(flushMode);
    }

    public Query createQuery(String ejbqlString) {
        EntityManager em = this.getEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        return em.createQuery(ejbqlString);
    }

    public Query createNamedQuery(String name) {
        EntityManager em = this.getEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        return em.createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString) {
        EntityManager em = this.getEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        return em.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        EntityManager em = this.getEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        return em.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        EntityManager em = this.getEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        return em.createNativeQuery(sqlString, resultSetMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> A find(Class<A> entityClass, Object primaryKey) {
        EntityManager em = this.getEntityManager();
        if (!this.factory.isInTx()) {
            em.clear();
        }
        try {
            Object object = em.find(entityClass, primaryKey);
            return (A)object;
        }
        finally {
            if (!this.factory.isInTx()) {
                em.clear();
            }
        }
    }

    public void persist(Object entity) {
        this.factory.verifyInTx();
        this.getEntityManager().persist(entity);
    }

    public <A> A merge(A entity) {
        this.factory.verifyInTx();
        return (A)this.getEntityManager().merge(entity);
    }

    public void remove(Object entity) {
        this.factory.verifyInTx();
        this.getEntityManager().remove(entity);
    }

    public void refresh(Object entity) {
        this.factory.verifyInTx();
        this.getEntityManager().refresh(entity);
    }

    public boolean contains(Object entity) {
        return this.getEntityManager().contains(entity);
    }

    public void flush() {
        this.factory.verifyInTx();
        this.getEntityManager().flush();
    }

    public void close() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    public boolean isOpen() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    protected EntityManager getEntityManager() {
        StatefulBeanContext beanContext = StatefulBeanContext.currentBean.get();
        if (beanContext != null) {
            List<StatefulBeanContext> beanContexts = StatefulBeanContext.currentBean.getList();
            for (StatefulBeanContext bc : beanContexts) {
                EntityManager em = bc.getExtendedPersistenceContext(this.factory.getKernelName());
                if (em == null) continue;
                return em;
            }
        }
        return this.factory.getTransactionScopedEntityManager();
    }
}

