/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.StandardQueryCache;
import org.hibernate.cache.UpdateTimestampsCache;

public class SecondLevelCacheUtil {
    public static final String HIBERNATE_CACHE_REGION_PREFIX = "hibernate.cache.region_prefix";

    public static String createCacheRegionPrefix(String earName, String jarName, String unitName) {
        StringBuilder sb = new StringBuilder();
        if (earName != null) {
            sb.append(earName);
            if (!earName.endsWith(".ear")) {
                sb.append("_ear");
            }
            sb.append(",");
        }
        if (jarName != null) {
            sb.append(jarName);
            if (!jarName.endsWith(".jar")) {
                sb.append("_jar");
            }
            sb.append(",");
        }
        sb.append(unitName);
        String raw = sb.toString();
        String escaped = raw.replace('.', '_');
        return escaped;
    }

    public static String createRegionFqn(String regionName, String regionPrefix) {
        String escaped = null;
        int idx = -1;
        if (regionPrefix != null) {
            idx = regionName.indexOf(regionPrefix);
        }
        if (idx > -1) {
            int regionEnd = idx + regionPrefix.length();
            String prefix = regionName.substring(0, regionEnd);
            String suffix = regionName.substring(regionEnd);
            suffix = suffix.replace('.', '/');
            escaped = prefix + suffix;
        } else {
            escaped = regionName.replace('.', '/');
        }
        return escaped;
    }

    public static boolean isSharedClassLoaderRegion(String regionName) {
        return StandardQueryCache.class.getName().equals(regionName) || UpdateTimestampsCache.class.getName().equals(regionName);
    }

    public static CacheException convertToHibernateException(Exception e) {
        CacheException he = null;
        if (e instanceof org.jboss.cache.CacheException) {
            he = new CacheException(e.getClass().getName() + " " + e.getMessage());
            he.setStackTrace(e.getStackTrace());
        } else {
            he = e instanceof CacheException ? (CacheException)((Object)e) : new CacheException((Throwable)e);
        }
        return he;
    }

    private SecondLevelCacheUtil() {
    }
}

