/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Properties;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.QueryKey;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.ejb3.entity.JBCCacheBase;
import org.jboss.ejb3.entity.OptimisticJBCCache;
import org.jboss.ejb3.entity.SecondLevelCacheUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PessimisticJBCCache
extends JBCCacheBase
implements Cache {
    public PessimisticJBCCache(org.jboss.cache.Cache<Object, Object> cache, String regionName, String regionPrefix, TransactionManager transactionManager, Properties properties) throws CacheException {
        super(cache, regionName, regionPrefix, transactionManager, properties);
    }

    @Override
    protected void establishRegionRootNode() {
        this.regionRoot = this.cache.getRoot().getChild(this.regionFqn);
    }

    @Override
    protected Node<Object, Object> createRegionRootNode() {
        Node root = this.cache.getRoot();
        Node targetNode = root.getChild(this.regionFqn);
        if (targetNode == null || !targetNode.isValid()) {
            this.cache.getInvocationContext().getOptionOverrides().setDataVersion(OptimisticJBCCache.NonLockingDataVersion.INSTANCE);
            targetNode = root.addChild(this.regionFqn);
        }
        targetNode.setResident(true);
        return targetNode;
    }

    public Object get(Object key) throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.ensureRegionRootExists();
            if (key instanceof QueryKey) {
                this.cache.getInvocationContext().getOptionOverrides().setLockAcquisitionTimeout(0);
            }
            Object object = this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item");
            return object;
        }
        catch (TimeoutException e) {
            if (key instanceof QueryKey) {
                Object var4_5 = null;
                return var4_5;
            }
            throw SecondLevelCacheUtil.convertToHibernateException((Exception)((Object)e));
        }
        finally {
            this.resume(tx);
        }
    }

    public Object read(Object key) throws CacheException {
        try {
            this.ensureRegionRootExists();
            return this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item");
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void update(Object key, Object value) throws CacheException {
        try {
            this.ensureRegionRootExists();
            if (this.localOnlyQueries && key instanceof QueryKey) {
                this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            }
            this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    /*
     * Loose catch block
     */
    public void put(Object key, Object value) throws CacheException {
        Transaction tx;
        block9: {
            tx = null;
            try {
                if (this.forTimestamps) {
                    tx = this.suspend();
                    this.ensureRegionRootExists();
                    if (this.forceAsync) {
                        this.cache.getInvocationContext().getOptionOverrides().setForceAsynchronous(true);
                    }
                    this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
                    break block9;
                }
                if (key instanceof QueryKey) {
                    this.ensureRegionRootExists();
                    Option option = new Option();
                    option.setCacheModeLocal(this.localOnlyQueries);
                    option.setLockAcquisitionTimeout(2);
                    this.cache.getInvocationContext().setOptionOverrides(option);
                    this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
                    break block9;
                }
                this.ensureRegionRootExists();
                this.cache.putForExternalRead(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
            }
            catch (TimeoutException te) {
                block10: {
                    if (key instanceof QueryKey) break block10;
                    throw SecondLevelCacheUtil.convertToHibernateException((Exception)((Object)te));
                }
                this.resume(tx);
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
                {
                    catch (Throwable throwable) {
                        this.resume(tx);
                        throw throwable;
                    }
                }
            }
        }
        this.resume(tx);
    }

    public void remove(Object key) throws CacheException {
        try {
            this.ensureRegionRootExists();
            if (this.localOnlyQueries && key instanceof QueryKey) {
                this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            }
            this.cache.removeNode(new Fqn(this.regionFqn, new Object[]{key}));
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.removeNode(this.regionFqn);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void destroy() throws CacheException {
        try {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.cache.removeNode(this.regionFqn);
            if (this.cache.getConfiguration().isUseRegionBasedMarshalling() && !SecondLevelCacheUtil.isSharedClassLoaderRegion(this.regionName)) {
                this.inactivateCacheRegion();
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public String toString() {
        return "PessimisticJBCCache(" + this.regionName + ')';
    }
}

