/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Comparator;
import java.util.Properties;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.OptimisticCacheSource;
import org.hibernate.cache.QueryKey;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.ejb3.entity.JBCCacheBase;
import org.jboss.ejb3.entity.SecondLevelCacheUtil;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticJBCCache
extends JBCCacheBase
implements OptimisticCache {
    private static final Logger log = Logger.getLogger(OptimisticJBCCache.class);
    private OptimisticCacheSource source;

    public OptimisticJBCCache(Cache<Object, Object> cache, String regionName, String regionPrefix, TransactionManager transactionManager, Properties properties) throws CacheException {
        super(cache, regionName, regionPrefix, transactionManager, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void establishRegionRootNode() {
        Transaction tx = this.suspend();
        Node<Object, Object> newRoot = null;
        try {
            newRoot = this.createRegionRootNode();
        }
        finally {
            this.resume(tx);
            this.regionRoot = newRoot;
        }
    }

    @Override
    protected Node<Object, Object> createRegionRootNode() {
        Node root = this.cache.getRoot();
        Node targetNode = root.getChild(this.regionFqn);
        if (targetNode == null || !targetNode.isValid()) {
            this.cache.getInvocationContext().getOptionOverrides().setDataVersion(NonLockingDataVersion.INSTANCE);
            targetNode = root.addChild(this.regionFqn);
        } else if (targetNode instanceof NodeSPI && !(((NodeSPI)targetNode).getVersion() instanceof NonLockingDataVersion)) {
            ((NodeSPI)targetNode).setVersion(NonLockingDataVersion.INSTANCE);
        }
        targetNode.setResident(true);
        return targetNode;
    }

    public void setSource(OptimisticCacheSource source) {
        this.source = source;
    }

    public void writeInsert(Object key, Object value, Object currentVersion) {
        this.writeUpdate(key, value, currentVersion, null);
    }

    public void writeUpdate(Object key, Object value, Object currentVersion, Object previousVersion) {
        try {
            this.ensureRegionRootExists();
            Option option = new Option();
            DataVersion dv = this.source != null && this.source.isVersioned() ? new DataVersionAdapter(currentVersion, previousVersion, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
            option.setDataVersion(dv);
            if (this.localOnlyQueries && key instanceof QueryKey) {
                option.setCacheModeLocal(true);
            }
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    /*
     * Loose catch block
     */
    public void writeLoad(Object key, Object value, Object currentVersion) {
        Transaction tx = null;
        try {
            Option option = new Option();
            DataVersion dv = this.source != null && this.source.isVersioned() ? new DataVersionAdapter(currentVersion, currentVersion, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
            option.setDataVersion(dv);
            if (this.forTimestamps) {
                tx = this.suspend();
                this.ensureRegionRootExists();
                if (this.forceAsync) {
                    option.setForceAsynchronous(true);
                }
                this.cache.getInvocationContext().setOptionOverrides(option);
                this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
            } else if (key instanceof QueryKey) {
                this.ensureRegionRootExists();
                option.setCacheModeLocal(this.localOnlyQueries);
                option.setLockAcquisitionTimeout(2);
                this.cache.getInvocationContext().setOptionOverrides(option);
                this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
            } else {
                this.ensureRegionRootExists();
                this.cache.getInvocationContext().setOptionOverrides(option);
                this.cache.putForExternalRead(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
            }
            this.resume(tx);
        }
        catch (TimeoutException te) {
            if (!(key instanceof QueryKey)) {
                throw SecondLevelCacheUtil.convertToHibernateException((Exception)((Object)te));
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resume(tx);
        }
    }

    public Object get(Object key) throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.ensureRegionRootExists();
            if (key instanceof QueryKey) {
                this.cache.getInvocationContext().getOptionOverrides().setLockAcquisitionTimeout(0);
            }
            Object object = this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item");
            return object;
        }
        catch (TimeoutException e) {
            if (key instanceof QueryKey) {
                Object var4_6 = null;
                return var4_6;
            }
            throw SecondLevelCacheUtil.convertToHibernateException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
        finally {
            this.resume(tx);
        }
    }

    public Object read(Object key) throws CacheException {
        try {
            this.ensureRegionRootExists();
            return this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item");
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void update(Object key, Object value) throws CacheException {
        try {
            this.ensureRegionRootExists();
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            if (this.localOnlyQueries && key instanceof QueryKey) {
                option.setCacheModeLocal(true);
            }
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    /*
     * Loose catch block
     */
    public void put(Object key, Object value) throws CacheException {
        Transaction tx = null;
        try {
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            if (this.forTimestamps) {
                tx = this.suspend();
                this.ensureRegionRootExists();
                if (this.forceAsync) {
                    option.setForceAsynchronous(true);
                }
                this.cache.getInvocationContext().setOptionOverrides(option);
                this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
            } else if (key instanceof QueryKey) {
                this.ensureRegionRootExists();
                option.setCacheModeLocal(this.localOnlyQueries);
                option.setLockAcquisitionTimeout(2);
                this.cache.getInvocationContext().setOptionOverrides(option);
                this.cache.put(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
            } else {
                this.ensureRegionRootExists();
                this.cache.getInvocationContext().setOptionOverrides(option);
                this.cache.putForExternalRead(new Fqn(this.regionFqn, new Object[]{key}), (Object)"item", value);
            }
            this.resume(tx);
        }
        catch (TimeoutException te) {
            if (!(key instanceof QueryKey)) {
                throw SecondLevelCacheUtil.convertToHibernateException((Exception)((Object)te));
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resume(tx);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            this.ensureRegionRootExists();
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            if (this.localOnlyQueries && key instanceof QueryKey) {
                option.setCacheModeLocal(true);
            }
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.removeNode(new Fqn(this.regionFqn, new Object[]{key}));
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.getInvocationContext().getOptionOverrides().setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.removeNode(this.regionFqn);
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public void destroy() throws CacheException {
        try {
            Option option = new Option();
            option.setCacheModeLocal(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.getInvocationContext().setOptionOverrides(option);
            this.cache.removeNode(this.regionFqn);
            if (this.cache.getConfiguration().isUseRegionBasedMarshalling() && !SecondLevelCacheUtil.isSharedClassLoaderRegion(this.regionName)) {
                this.inactivateCacheRegion();
            }
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public String toString() {
        return "OptimisticJBCCache(" + this.regionName + ')';
    }

    public static class CircumventChecksDataVersion
    implements DataVersion {
        private static final long serialVersionUID = 7996980646166032369L;
        public static final DataVersion INSTANCE = new CircumventChecksDataVersion();

        public boolean newerThan(DataVersion dataVersion) {
            throw new CacheException("optimistic locking checks should never happen on CircumventChecksDataVersion");
        }
    }

    public static class NonLockingDataVersion
    implements DataVersion {
        private static final long serialVersionUID = 7050722490368630553L;
        public static final DataVersion INSTANCE = new NonLockingDataVersion();

        public boolean newerThan(DataVersion dataVersion) {
            log.trace((Object)"non locking lock check...");
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataVersionAdapter
    implements DataVersion {
        private static final long serialVersionUID = 5564692336076405571L;
        private final Object currentVersion;
        private final Object previousVersion;
        private final Comparator<Object> versionComparator;
        private final String sourceIdentifer;

        public DataVersionAdapter(Object currentVersion, Object previousVersion, Comparator<Object> versionComparator, String sourceIdentifer) {
            this.currentVersion = currentVersion;
            this.previousVersion = previousVersion;
            this.versionComparator = versionComparator;
            this.sourceIdentifer = sourceIdentifer;
            log.trace((Object)("created " + this));
        }

        public boolean newerThan(DataVersion dataVersion) {
            log.trace((Object)("checking [" + this + "] against [" + dataVersion + "]"));
            if (dataVersion instanceof CircumventChecksDataVersion) {
                log.trace((Object)"skipping lock checks...");
                return false;
            }
            if (dataVersion instanceof NonLockingDataVersion) {
                log.trace((Object)"skipping lock checks...");
                return false;
            }
            DataVersionAdapter other = (DataVersionAdapter)dataVersion;
            if (other.previousVersion == null) {
                log.warn((Object)"Unexpected optimistic lock check on inserting data");
                if (this == dataVersion) {
                    log.trace((Object)"skipping lock checks due to same DV instance");
                    return false;
                }
            }
            if (this.currentVersion == null) {
                return other.previousVersion != null;
            }
            return this.versionComparator.compare(this.currentVersion, other.previousVersion) >= 1;
        }

        public String toString() {
            return super.toString() + " [current=" + this.currentVersion + ", previous=" + this.previousVersion + ", src=" + this.sourceIdentifer + "]";
        }
    }
}

