/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Properties;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.jboss.cache.CacheManager;
import org.jboss.cache.CacheStatus;
import org.jboss.ejb3.entity.OptimisticJBCCache;
import org.jboss.ejb3.entity.PessimisticJBCCache;
import org.jboss.ejb3.entity.TransactionalCacheFactory;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.ha.framework.server.CacheManagerLocator;
import org.jboss.logging.Logger;

class JBCCacheFactory
extends TransactionalCacheFactory {
    private static final Logger log = Logger.getLogger(JBCCacheFactory.class);
    private CacheManager cacheManager;
    private String cacheName;
    private org.jboss.cache.Cache<Object, Object> cache;
    private boolean optimistic;

    JBCCacheFactory() {
    }

    protected void configure(Properties hibernateConfig) {
        try {
            this.cacheManager = CacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
            this.cacheName = (String)hibernateConfig.get("hibernate.cache.jbc2.config.name");
            if (this.cacheName == null) {
                this.cacheName = (String)hibernateConfig.get("hibernate.treecache.mbean.object_name");
            }
            if (this.cacheName == null) {
                this.cacheName = "jboss.cache:service=EJB3EntityTreeCache";
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void start() {
        try {
            this.cache = this.cacheManager.getCache(this.cacheName, true);
            this.optimistic = this.cache.getConfiguration().isNodeLockingOptimistic();
            if (this.cache.getCacheStatus() != CacheStatus.STARTED) {
                if (this.cache.getCacheStatus() != CacheStatus.CREATED) {
                    this.cache.create();
                }
                if (this.cache.getConfiguration().getRuntimeConfig().getTransactionManager() == null && this.cache.getConfiguration().getTransactionManagerLookupClass() == null) {
                    this.cache.getConfiguration().getRuntimeConfig().setTransactionManager(TxUtil.getTransactionManager());
                }
                this.cache.start();
            }
        }
        catch (Exception e) {
            throw new CacheException("Problem accessing cache " + this.cacheName, (Throwable)e);
        }
    }

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        String regionPrefix = properties.getProperty("hibernate.cache.region_prefix");
        if (this.optimistic) {
            return new OptimisticJBCCache(this.cache, regionName, regionPrefix, TxUtil.getTransactionManager(), properties);
        }
        return new PessimisticJBCCache(this.cache, regionName, regionPrefix, TxUtil.getTransactionManager(), properties);
    }

    public void stop() {
        if (this.cache != null) {
            this.cacheManager.releaseCache(this.cacheName);
            log.debug((Object)("Cache " + this.cacheName + " released"));
        }
    }

    public boolean isOptimistic() {
        return this.optimistic;
    }
}

