/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.security.Identity;
import java.security.Principal;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.TimerService;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.SecurityActions;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.security.helpers.EJBContextHelper;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;
import org.jboss.security.RealmMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EJBContextImpl<T extends Container, B extends BeanContext<T>>
implements EJBContext {
    private static final Logger log = Logger.getLogger(EJBContextImpl.class);
    protected transient T container;
    protected transient RealmMapping rm;
    protected B beanContext;
    protected EJBContextHelper ejbContextHelper;
    private Principal beanPrincipal;

    protected EJBContextImpl(B beanContext) {
        assert (beanContext != null) : "beanContext is null";
        this.beanContext = beanContext;
        this.container = beanContext.getContainer();
        this.rm = this.container.getSecurityManager(RealmMapping.class);
        this.ejbContextHelper = new EJBContextHelper();
    }

    protected T getContainer() {
        return this.container;
    }

    protected RealmMapping getRm() {
        return this.rm;
    }

    public Object lookup(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        String newName = name.startsWith("/") ? "env" + name : "env/" + name;
        try {
            return this.getContainer().getEnc().lookup(newName);
        }
        catch (NameNotFoundException ignored) {
            try {
                return this.getContainer().getInitialContext().lookup(name);
            }
            catch (NameNotFoundException ignored2) {
                throw new IllegalArgumentException("Unable to find an entry in java:comp/env (or global JNDI) for '" + name + "'");
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public Identity getCallerIdentity() {
        throw new IllegalStateException("deprecated");
    }

    public Principal getCallerPrincipal() {
        if (this.beanPrincipal == null) {
            EJBContainer ec = (EJBContainer)this.container;
            SecurityDomain domain = ec.getAnnotation(SecurityDomain.class);
            Principal callerPrincipal = this.ejbContextHelper.getCallerPrincipal(SecurityActions.getSecurityContext(), this.rm, domain);
            if (callerPrincipal == null) {
                throw new IllegalStateException("No valid security context for the caller identity");
            }
            this.beanPrincipal = callerPrincipal;
        }
        return this.beanPrincipal;
    }

    public boolean isCallerInRole(Identity role) {
        throw new IllegalStateException("deprecated");
    }

    public boolean isCallerInRole(String roleName) {
        EJBContainer ejbc = (EJBContainer)this.container;
        return this.ejbContextHelper.isCallerInRole(SecurityActions.getSecurityContext(), ejbc.getAnnotation(SecurityDomain.class), this.rm, ejbc.getXml(), roleName, ejbc.getEjbName());
    }

    public TimerService getTimerService() throws IllegalStateException {
        return this.getContainer().getTimerService();
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        return TxUtil.getUserTransaction(this.beanContext);
    }

    public EJBHome getEJBHome() {
        throw new IllegalStateException("EJB 3.0 does not have a home type.");
    }

    public EJBLocalHome getEJBLocalHome() {
        throw new IllegalStateException("EJB 3.0 does not have a home type.");
    }

    public Properties getEnvironment() {
        throw new EJBException("Deprecated");
    }

    public void setRollbackOnly() throws IllegalStateException {
        TxUtil.setRollbackOnly();
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        return TxUtil.getRollbackOnly();
    }
}

