/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxws.DynamicWrapperGenerator;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.tools.jaxws.impl.WritableWrapperGenerator;

public class BytecodeWrapperGenerator
extends DynamicWrapperGenerator
implements WritableWrapperGenerator {
    private List<String> typeNames = new ArrayList<String>();
    PrintStream stream;

    public BytecodeWrapperGenerator(ClassLoader loader, PrintStream stream) {
        super(loader);
        this.stream = stream;
        this.prune = false;
    }

    public void reset(ClassLoader loader) {
        super.reset(loader);
        this.typeNames.clear();
    }

    public void generate(FaultMetaData fmd) {
        super.generate(fmd);
        this.typeNames.add(fmd.getFaultBeanName());
    }

    public void generate(ParameterMetaData pmd) {
        super.generate(pmd);
        this.typeNames.add(pmd.getJavaTypeName());
    }

    public void write(File directory) throws IOException {
        if (this.typeNames.isEmpty()) {
            System.out.println("No Classes to generate...");
            return;
        }
        this.stream.println("Writing Classes:");
        for (String name : this.typeNames) {
            try {
                this.stream.println(name.replace('.', '/') + ".class");
                this.pool.get(name).writeFile(directory.getAbsolutePath());
            }
            catch (CannotCompileException e) {
                throw new WSException(e);
            }
            catch (NotFoundException e) {
                throw new WSException(e);
            }
        }
    }
}

