/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.security.MessageDigest;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import javax.security.auth.callback.Callback;
import org.jboss.logging.Logger;
import org.jboss.security.Base64Encoder;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.auth.callback.UsernameTokenCallback;
import org.jboss.ws.extensions.security.auth.callback.UsernameTokenCallbackHandler;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.UsernameToken;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.nonce.NonceGenerator;
import org.jboss.ws.extensions.security.operation.EncodingOperation;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.Document;

public class SendUsernameOperation
implements EncodingOperation {
    private static Logger log = Logger.getLogger(SendUsernameOperation.class);
    private String username;
    private String credential;
    private boolean digestPassword;
    private boolean useNonce;
    private boolean useCreated;
    private NonceGenerator nonceGenerator;

    public SendUsernameOperation(String username, String credential, boolean digestPassword, boolean useNonce, boolean useCreated, NonceGenerator nonceGenerator) {
        this.username = username;
        this.credential = credential;
        this.digestPassword = digestPassword;
        this.useNonce = useNonce;
        this.useCreated = useCreated;
        this.nonceGenerator = nonceGenerator;
    }

    public void process(Document message, SecurityHeader header, SecurityStore store) throws WSSecurityException {
        String created = this.useCreated ? SendUsernameOperation.getCurrentTimestampAsString() : null;
        String nonce = this.useNonce ? this.nonceGenerator.generateNonce() : null;
        String password = this.digestPassword ? SendUsernameOperation.createPasswordDigest(nonce, created, this.credential) : this.credential;
        header.addToken(new UsernameToken(this.username, password, message, this.digestPassword, nonce, created));
    }

    private static String getCurrentTimestampAsString() {
        GregorianCalendar timestamp = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        return SimpleTypeBindings.marshalDateTime((Calendar)timestamp);
    }

    public static String createPasswordDigest(String nonce, String created, String password) {
        String passwordHash = null;
        try {
            byte[] passBytes = password.getBytes("UTF-8");
            UsernameTokenCallback callback = new UsernameTokenCallback();
            HashMap options = new HashMap();
            callback.init(options);
            UsernameTokenCallbackHandler handler = new UsernameTokenCallbackHandler(nonce, created);
            handler.handle((Callback[])options.get("callbacks"));
            MessageDigest md = MessageDigest.getInstance("SHA");
            callback.preDigest(md);
            md.update(passBytes);
            callback.postDigest(md);
            byte[] hash = md.digest();
            passwordHash = Base64Encoder.encode((byte[])hash);
        }
        catch (Exception e) {
            log.error((Object)"Password hash calculation failed ", (Throwable)e);
        }
        return passwordHash;
    }
}

