/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.handler;

import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.jaxws.handler.HandlerChainExecutor;
import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
import org.jboss.ws.core.jaxws.handler.PortInfoImpl;
import org.jboss.ws.core.server.ServerHandlerDelegate;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerDelegateJAXWS
extends ServerHandlerDelegate {
    private static Logger log = Logger.getLogger(HandlerDelegateJAXWS.class);
    private HandlerResolverImpl resolver = new HandlerResolverImpl();
    private ThreadLocal<HandlerChainExecutor> preExecutor = new ThreadLocal();
    private ThreadLocal<HandlerChainExecutor> jaxwsExecutor = new ThreadLocal();
    private ThreadLocal<HandlerChainExecutor> postExecutor = new ThreadLocal();

    public HandlerDelegateJAXWS(ServerEndpointMetaData sepMetaData) {
        super(sepMetaData);
        sepMetaData.registerConfigObserver(this);
    }

    @Override
    public UnifiedHandlerMetaData.HandlerType[] getHandlerTypeOrder() {
        return new UnifiedHandlerMetaData.HandlerType[]{UnifiedHandlerMetaData.HandlerType.POST, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.PRE};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        log.debug((Object)("callRequestHandlerChain: " + type));
        if (!this.isInitialized()) {
            HandlerResolverImpl handlerResolverImpl = this.resolver;
            synchronized (handlerResolverImpl) {
                if (!this.isInitialized()) {
                    this.resolver.initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.PRE, true);
                    this.resolver.initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.ENDPOINT, true);
                    this.resolver.initHandlerChain(sepMetaData, UnifiedHandlerMetaData.HandlerType.POST, true);
                    this.setInitialized(true);
                }
            }
        }
        HandlerChainExecutor executor = this.createExecutor(sepMetaData, type);
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        return executor.handleMessage(msgContext);
    }

    @Override
    public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        log.debug((Object)("callResponseHandlerChain: " + type));
        HandlerChainExecutor executor = this.getExecutor(type);
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        boolean status = executor != null ? executor.handleMessage(msgContext) : true;
        MessageAbstraction msg = ((CommonMessageContext)msgContext).getMessageAbstraction();
        if (msg instanceof SOAPMessage) {
            XOPContext.visitAndRestoreXOPData();
        }
        return status;
    }

    @Override
    public void closeHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        log.debug((Object)"closeHandlerChain");
        HandlerChainExecutor executor = this.getExecutor(type);
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        if (executor != null) {
            executor.close(msgContext);
            this.removeExecutor(type);
        }
    }

    @Override
    public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
        log.debug((Object)("callFaultHandlerChain: " + type));
        HandlerChainExecutor executor = this.getExecutor(type);
        MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
        boolean status = executor != null ? executor.handleFault(msgContext, ex) : true;
        MessageAbstraction msg = ((CommonMessageContext)msgContext).getMessageAbstraction();
        if (msg instanceof SOAPMessage) {
            XOPContext.visitAndRestoreXOPData();
        }
        return status;
    }

    private List<Handler> getHandlerChain(EndpointMetaData epMetaData, UnifiedHandlerMetaData.HandlerType type) {
        PortInfo info = this.getPortInfo(epMetaData);
        return this.resolver.getHandlerChain(info, type);
    }

    private PortInfo getPortInfo(EndpointMetaData epMetaData) {
        QName serviceName = epMetaData.getServiceMetaData().getServiceName();
        QName portName = epMetaData.getPortName();
        String bindingId = epMetaData.getBindingId();
        PortInfoImpl info = new PortInfoImpl(serviceName, portName, bindingId);
        return info;
    }

    @Override
    public Set<QName> getHeaders() {
        return this.resolver.getHeaders();
    }

    private HandlerChainExecutor createExecutor(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        if (type == UnifiedHandlerMetaData.HandlerType.ALL) {
            throw new IllegalArgumentException("Invalid handler type: " + type);
        }
        HandlerChainExecutor executor = new HandlerChainExecutor(sepMetaData, this.getHandlerChain(sepMetaData, type));
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            this.preExecutor.set(executor);
        } else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
            this.jaxwsExecutor.set(executor);
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            this.postExecutor.set(executor);
        }
        return executor;
    }

    private HandlerChainExecutor getExecutor(UnifiedHandlerMetaData.HandlerType type) {
        if (type == UnifiedHandlerMetaData.HandlerType.ALL) {
            throw new IllegalArgumentException("Invalid handler type: " + type);
        }
        HandlerChainExecutor executor = null;
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            executor = this.preExecutor.get();
        } else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
            executor = this.jaxwsExecutor.get();
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            executor = this.postExecutor.get();
        }
        return executor;
    }

    private void removeExecutor(UnifiedHandlerMetaData.HandlerType type) {
        if (type == UnifiedHandlerMetaData.HandlerType.ALL) {
            throw new IllegalArgumentException("Invalid handler type: " + type);
        }
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            this.preExecutor.remove();
        } else if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
            this.jaxwsExecutor.remove();
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            this.postExecutor.remove();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
    }
}

