/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.DeserializerSupport;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Element;

public class SOAPElementDeserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger(SOAPElementDeserializer.class);

    public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
        return this.deserialize(xmlName, xmlType, SOAPElementDeserializer.sourceToString(xmlFragment), serContext);
    }

    private Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContext serContext) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        }
        try {
            Element domElement = DOMUtils.parse((String)xmlFragment);
            SOAPElement soapElement = new SOAPFactoryImpl().createElement(domElement);
            return soapElement;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new BindingException();
        }
    }
}

