/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.ws.addressing.AddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPBinding;
import org.jboss.ws.core.DirectionHolder;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.HeaderSource;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.StubExt;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.RemoteConnection;
import org.jboss.ws.core.client.RemoteConnectionFactory;
import org.jboss.ws.core.jaxrpc.ParameterWrapping;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.core.soap.UnboundHeader;
import org.jboss.ws.core.utils.HolderUtils;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonClient
implements StubExt,
HeaderSource {
    private static Logger log = Logger.getLogger(CommonClient.class);
    public static String SESSION_COOKIES = "org.jboss.ws.maintain.session.cookies";
    protected EndpointMetaData epMetaData;
    protected QName operationName;
    protected EndpointInvocation epInv;
    protected CommonBindingProvider bindingProvider;
    private Map<QName, UnboundHeader> unboundHeaders = new LinkedHashMap<QName, UnboundHeader>();
    private List<AttachmentPart> attachmentParts = new ArrayList<AttachmentPart>();
    private String securityConfig;

    protected CommonClient(ServiceMetaData serviceMetaData) {
        if (serviceMetaData != null && serviceMetaData.getEndpoints().size() == 1) {
            this.epMetaData = serviceMetaData.getEndpoints().get(0);
        }
        this.bindingProvider = this.getCommonBindingProvider();
    }

    protected CommonClient(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
        this.bindingProvider = this.getCommonBindingProvider();
    }

    protected CommonClient(ServiceMetaData serviceMetaData, QName portName, QName opName) {
        if (serviceMetaData != null) {
            EndpointMetaData epMetaData = null;
            if (serviceMetaData.getEndpoints().size() > 0 && (epMetaData = serviceMetaData.getEndpoint(portName)) == null) {
                throw new WSException("Cannot find endpoint for name: " + portName);
            }
            if (epMetaData != null) {
                this.epMetaData = epMetaData;
            }
        }
        if (opName != null) {
            this.setOperationName(opName);
        }
        this.bindingProvider = this.getCommonBindingProvider();
    }

    public abstract String getTargetEndpointAddress();

    public abstract void setTargetEndpointAddress(String var1);

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName operationName) {
        this.operationName = operationName;
    }

    public OperationMetaData getOperationMetaData() {
        if (this.operationName == null) {
            throw new WSException("Operation name not set");
        }
        return this.getOperationMetaData(this.operationName);
    }

    public OperationMetaData getOperationMetaData(QName opName) {
        if (opName == null) {
            throw new IllegalArgumentException("Cannot get OperationMetaData for null");
        }
        EndpointMetaData epMetaData = this.getEndpointMetaData();
        OperationMetaData opMetaData = epMetaData.getOperation(opName);
        if (opMetaData == null && epMetaData.getServiceMetaData().getWsdlDefinitions() == null) {
            opMetaData = new OperationMetaData(epMetaData, opName, opName.getLocalPart());
            epMetaData.addOperation(opMetaData);
        }
        if (opMetaData == null) {
            throw new WSException("Cannot obtain operation meta data for: " + opName);
        }
        return opMetaData;
    }

    @Override
    public EndpointMetaData getEndpointMetaData() {
        if (this.epMetaData == null) {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            ResourceLoaderAdapter vfsRoot = new ResourceLoaderAdapter();
            UnifiedMetaData wsMetaData = new UnifiedMetaData((UnifiedVirtualFile)vfsRoot);
            wsMetaData.setClassLoader(ctxLoader);
            ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, new QName("http://www.jboss.org/jbossws", "AnonymousService"));
            wsMetaData.addService(serviceMetaData);
            QName anonQName = new QName("http://www.jboss.org/jbossws", "Anonymous");
            QName anonPort = new QName("http://www.jboss.org/jbossws", "AnonymousPort");
            this.epMetaData = new ClientEndpointMetaData(serviceMetaData, anonPort, anonQName, EndpointMetaData.Type.JAXRPC);
            this.epMetaData.setStyle(Style.RPC);
            serviceMetaData.addEndpoint(this.epMetaData);
        }
        return this.epMetaData;
    }

    protected abstract boolean callRequestHandlerChain(QName var1, UnifiedHandlerMetaData.HandlerType var2);

    protected abstract boolean callResponseHandlerChain(QName var1, UnifiedHandlerMetaData.HandlerType var2);

    protected abstract boolean callFaultHandlerChain(QName var1, UnifiedHandlerMetaData.HandlerType var2, Exception var3);

    protected abstract void closeHandlerChain(QName var1, UnifiedHandlerMetaData.HandlerType var2);

    protected abstract void setInboundContextProperties();

    protected abstract void setOutboundContextProperties();

    protected abstract boolean shouldMaintainSession();

    protected Object invoke(QName opName, Object[] inputParams, boolean forceOneway) throws Exception {
        if (!opName.equals(this.operationName)) {
            this.setOperationName(opName);
        }
        OperationMetaData opMetaData = this.getOperationMetaData();
        boolean oneway = forceOneway || opMetaData.isOneWay();
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        msgContext.setOperationMetaData(opMetaData);
        msgContext.putAll((Map<? extends String, ? extends Object>)this.getRequestContext());
        DirectionHolder direction = new DirectionHolder(DirectionHolder.Direction.OutBound);
        UnifiedHandlerMetaData.HandlerType[] handlerType = new UnifiedHandlerMetaData.HandlerType[]{UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST};
        UnifiedHandlerMetaData.HandlerType[] faultType = new UnifiedHandlerMetaData.HandlerType[]{UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST};
        QName portName = this.epMetaData.getPortName();
        try {
            CommonBinding binding = this.getCommonBindingProvider().getCommonBinding();
            binding.setHeaderSource(this);
            this.epInv = new EndpointInvocation(opMetaData);
            this.epInv.initInputParams(inputParams);
            this.setOutboundContextProperties();
            MessageAbstraction reqMessage = binding.bindRequestMessage(opMetaData, this.epInv, this.unboundHeaders);
            this.addAttachmentParts(reqMessage);
            boolean handlerPass = this.callRequestHandlerChain(portName, handlerType[0]);
            handlerPass = handlerPass && this.callRequestHandlerChain(portName, handlerType[1]);
            handlerPass = handlerPass && this.callRequestHandlerChain(portName, handlerType[2]);
            XOPContext.visitAndRestoreXOPData();
            reqMessage = msgContext.getMessageAbstraction();
            if (handlerPass) {
                String targetAddress = this.getTargetEndpointAddress();
                AddressingProperties addrProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.outbound");
                if (targetAddress == null && addrProps != null && addrProps.getTo() != null) {
                    AddressingConstantsImpl ADDR = new AddressingConstantsImpl();
                    String wsaTo = addrProps.getTo().getURI().toString();
                    if (!wsaTo.equals(ADDR.getAnonymousURI())) {
                        try {
                            URL wsaToURL = new URL(wsaTo);
                            log.debug((Object)("Sending request to addressing destination: " + wsaToURL));
                            targetAddress = wsaToURL.toExternalForm();
                        }
                        catch (MalformedURLException ex) {
                            log.debug((Object)("Not a valid URL: " + wsaTo));
                        }
                    }
                }
                if (targetAddress == null) {
                    throw new WSException("Target endpoint address not set");
                }
                HashMap<String, Object> callProps = new HashMap<String, Object>(this.getRequestContext());
                EndpointInfo epInfo = new EndpointInfo(this.epMetaData, targetAddress, callProps);
                if (this.shouldMaintainSession()) {
                    this.addSessionInfo(reqMessage, callProps);
                }
                RemoteConnection remoteConnection = new RemoteConnectionFactory().getRemoteConnection(epInfo);
                MessageAbstraction resMessage = remoteConnection.invoke(reqMessage, epInfo, oneway);
                if (this.shouldMaintainSession()) {
                    this.saveSessionInfo(callProps, this.getRequestContext());
                }
                msgContext = this.processPivotInternal(msgContext, direction);
                msgContext.put(CommonMessageContext.REMOTING_METADATA, (Object)callProps);
                msgContext.setMessageAbstraction(resMessage);
            }
            this.setInboundContextProperties();
            Object retObj = null;
            boolean isWsrmMessage = msgContext.get("wsrm.requestContext") != null;
            boolean wsrmOneWay = false;
            if (isWsrmMessage) {
                Boolean temp = (Boolean)((Map)msgContext.get("wsrm.requestContext")).get("wsrm.oneWayOperation");
                boolean bl = wsrmOneWay = temp == null ? Boolean.FALSE.booleanValue() : temp.booleanValue();
            }
            if (!oneway && handlerPass || isWsrmMessage && !wsrmOneWay) {
                MessageAbstraction resMessage;
                if (binding instanceof CommonSOAPBinding) {
                    ((CommonSOAPBinding)binding).checkMustUnderstand(opMetaData);
                }
                handlerPass = this.callResponseHandlerChain(portName, handlerType[2]);
                faultType[2] = null;
                if (handlerPass) {
                    resMessage = msgContext.getMessageAbstraction();
                    binding.unbindResponseMessage(opMetaData, resMessage, this.epInv, this.unboundHeaders);
                }
                handlerPass = handlerPass && this.callResponseHandlerChain(portName, handlerType[1]);
                faultType[1] = null;
                handlerPass = handlerPass && this.callResponseHandlerChain(portName, handlerType[0]);
                faultType[0] = null;
                if (msgContext.isModified()) {
                    log.debug((Object)"Handler modified body payload, unbind message again");
                    resMessage = msgContext.getMessageAbstraction();
                    binding.unbindResponseMessage(opMetaData, resMessage, this.epInv, this.unboundHeaders);
                }
                retObj = this.syncOutputParams(inputParams, this.epInv);
            }
            Object object = retObj;
            return object;
        }
        catch (Exception ex) {
            this.processPivotInternal(msgContext, direction);
            if (faultType[2] != null) {
                this.callFaultHandlerChain(portName, faultType[2], ex);
            }
            if (faultType[1] != null) {
                this.callFaultHandlerChain(portName, faultType[1], ex);
            }
            if (faultType[0] != null) {
                this.callFaultHandlerChain(portName, faultType[0], ex);
            }
            throw ex;
        }
        finally {
            this.closeHandlerChain(portName, handlerType[2]);
            this.closeHandlerChain(portName, handlerType[1]);
            this.closeHandlerChain(portName, handlerType[0]);
        }
    }

    private void saveSessionInfo(Map<String, Object> remotingMetadata, Map<String, Object> requestContext) {
        List setCookies2;
        HashMap<String, String> cookies = (HashMap<String, String>)requestContext.get(SESSION_COOKIES);
        if (cookies == null) {
            cookies = new HashMap<String, String>();
            requestContext.put(SESSION_COOKIES, cookies);
        }
        ArrayList setCookies = new ArrayList();
        List setCookies1 = (List)remotingMetadata.get("Set-Cookie");
        if (setCookies1 != null) {
            setCookies.addAll(setCookies1);
        }
        if ((setCookies2 = (List)remotingMetadata.get("Set-Cookie2")) != null) {
            setCookies.addAll(setCookies2);
        }
        for (String setCookie : setCookies) {
            String pair;
            int index = setCookie.indexOf(59);
            if (index == -1 || (index = (pair = setCookie.substring(0, index)).indexOf(61)) == -1) continue;
            String name = pair.substring(0, index);
            String value = pair.substring(index + 1);
            cookies.put(name, value);
        }
    }

    protected void addSessionInfo(MessageAbstraction reqMessage, Map<String, Object> callProperties) {
        Map cookies = (Map)callProperties.get(SESSION_COOKIES);
        if (cookies != null) {
            for (Map.Entry cookie : cookies.entrySet()) {
                reqMessage.getMimeHeaders().addHeader("Cookie", (String)cookie.getKey() + "=" + (String)cookie.getValue());
            }
        }
    }

    private CommonMessageContext processPivotInternal(CommonMessageContext msgContext, DirectionHolder direction) {
        if (direction.getDirection() == DirectionHolder.Direction.OutBound) {
            msgContext = this.processPivot(msgContext);
            direction.setDirection(DirectionHolder.Direction.InBound);
        }
        return msgContext;
    }

    protected void addAttachmentParts(MessageAbstraction reqMessage) {
        for (AttachmentPart part : this.attachmentParts) {
            log.debug((Object)("Adding attachment part: " + part.getContentId()));
            reqMessage.addAttachmentPart(part);
        }
    }

    protected abstract CommonMessageContext processPivot(CommonMessageContext var1);

    protected abstract CommonBindingProvider getCommonBindingProvider();

    protected abstract Map<String, Object> getRequestContext();

    private Object syncOutputParams(Object[] inParams, EndpointInvocation epInv) throws SOAPException {
        Object retValue = null;
        OperationMetaData opMetaData = this.getOperationMetaData();
        ParameterMetaData retMetaData = opMetaData.getReturnParameter();
        if (retMetaData != null) {
            retValue = epInv.getReturnValue();
            if (opMetaData.isDocumentWrapped() && !retMetaData.isMessageType()) {
                retValue = ParameterWrapping.unwrapResponseParameters(retMetaData, retValue, inParams);
            }
        }
        for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
            ParameterMode paramMode = paramMetaData.getMode();
            int index = paramMetaData.getIndex();
            if (index != -1 && paramMode != ParameterMode.INOUT && paramMode != ParameterMode.OUT) continue;
            QName xmlName = paramMetaData.getXmlName();
            Object value = epInv.getResponseParamValue(xmlName);
            if (index == -1) {
                retValue = value;
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("holder [" + index + "] " + xmlName));
            }
            HolderUtils.setHolderValue(inParams[index], value);
        }
        return retValue;
    }

    @Override
    public void addUnboundHeader(QName xmlName, QName xmlType, Class javaType, ParameterMode mode) {
        UnboundHeader unboundHeader = new UnboundHeader(xmlName, xmlType, javaType, mode);
        this.unboundHeaders.put(xmlName, unboundHeader);
    }

    @Override
    public Object getUnboundHeaderValue(QName xmlName) {
        UnboundHeader unboundHeader = this.unboundHeaders.get(xmlName);
        return unboundHeader != null ? unboundHeader.getHeaderValue() : null;
    }

    @Override
    public void setUnboundHeaderValue(QName xmlName, Object value) {
        UnboundHeader unboundHeader = this.unboundHeaders.get(xmlName);
        if (unboundHeader == null) {
            throw new IllegalArgumentException("Cannot find unbound header: " + xmlName);
        }
        unboundHeader.setHeaderValue(value);
    }

    @Override
    public void clearUnboundHeaders() {
        this.unboundHeaders.clear();
    }

    @Override
    public void removeUnboundHeader(QName xmlName) {
        this.unboundHeaders.remove(xmlName);
    }

    @Override
    public Iterator getUnboundHeaders() {
        return this.unboundHeaders.keySet().iterator();
    }

    @Override
    public void addAttachmentPart(AttachmentPart part) {
        this.attachmentParts.add(part);
    }

    @Override
    public void clearAttachmentParts() {
        this.attachmentParts.clear();
    }

    @Override
    public AttachmentPart createAttachmentPart() {
        try {
            MessageFactory factory = MessageFactory.newInstance();
            return factory.createMessage().createAttachmentPart();
        }
        catch (SOAPException ex) {
            throw new JAXRPCException("Cannot create attachment part");
        }
    }

    @Override
    public String getConfigName() {
        EndpointMetaData epMetaData = this.getEndpointMetaData();
        return epMetaData.getConfigName();
    }

    @Override
    public void setConfigName(String configName) {
        this.setConfigName(configName, null);
    }

    @Override
    public abstract void setConfigName(String var1, String var2);

    @Override
    public String getConfigFile() {
        EndpointMetaData epMetaData = this.getEndpointMetaData();
        return epMetaData.getConfigFile();
    }

    @Override
    public String getSecurityConfig() {
        return this.securityConfig;
    }

    @Override
    public void setSecurityConfig(String securityConfig) {
        EndpointMetaData epMetaData;
        ServiceMetaData serviceMetaData;
        this.securityConfig = securityConfig;
        if (securityConfig != null && (serviceMetaData = (epMetaData = this.getEndpointMetaData()).getServiceMetaData()).getSecurityConfiguration() == null) {
            try {
                WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
                UnifiedVirtualFile vfsRoot = serviceMetaData.getUnifiedMetaData().getRootFile();
                WSSecurityConfiguration config = wsseConfFactory.createConfiguration(vfsRoot, securityConfig);
                serviceMetaData.setSecurityConfiguration(config);
            }
            catch (IOException ex) {
                WSException.rethrow("Cannot set security config", ex);
            }
        }
    }
}

