/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.factories;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBElement;
import org.jboss.security.xacml.bridge.JBossPolicyFinder;
import org.jboss.security.xacml.core.JBossXACMLPolicy;
import org.jboss.security.xacml.core.SecurityActions;
import org.jboss.security.xacml.core.model.policy.ObjectFactory;
import org.jboss.security.xacml.core.model.policy.PolicyType;
import org.jboss.security.xacml.interfaces.XACMLPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyFactory {
    public static Class<?> constructingClass = JBossXACMLPolicy.class;

    public static void setConstructingClass(Class<?> clazz) {
        if (!XACMLPolicy.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("clazz is not of type XACMLPolicy");
        }
        constructingClass = clazz;
    }

    public static void setConstructingClass(String fqn) {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        try {
            PolicyFactory.setConstructingClass(tcl.loadClass(fqn));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static XACMLPolicy createPolicySet(InputStream policySetFile) throws Exception {
        return PolicyFactory.getCtr().newInstance(policySetFile, 0);
    }

    public static XACMLPolicy createPolicySet(InputStream policySetFile, JBossPolicyFinder theFinder) throws Exception {
        return PolicyFactory.getCtrWithFinder().newInstance(new Object[]{policySetFile, 0, theFinder});
    }

    public static XACMLPolicy createPolicy(InputStream policyFile) throws Exception {
        return PolicyFactory.getCtr().newInstance(policyFile, 1);
    }

    public static XACMLPolicy createPolicy(PolicyType policyFile) throws Exception {
        JAXBElement<PolicyType> jaxbPolicy = new ObjectFactory().createPolicy(policyFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXB.marshal(jaxbPolicy, (OutputStream)baos);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        return PolicyFactory.getCtr().newInstance(bis, 1);
    }

    private static Constructor<XACMLPolicy> getCtr() throws Exception {
        return constructingClass.getConstructor(InputStream.class, Integer.TYPE);
    }

    private static Constructor<XACMLPolicy> getCtrWithFinder() throws Exception {
        return constructingClass.getConstructor(InputStream.class, Integer.TYPE, JBossPolicyFinder.class);
    }
}

